/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class ComponentProperty
extends PassThroughComponent {
    private final PropertyDefinition m_property;
    private boolean m_skipMarshal;
    private boolean m_forceUnmarshal;

    public ComponentProperty(PropertyDefinition prop, IComponent impl, boolean skip) {
        super(impl);
        this.m_property = prop;
        this.m_skipMarshal = skip;
    }

    public void setSkipping(boolean skip) {
        this.m_skipMarshal = skip;
    }

    public void setForceUnmarshal(boolean force) {
        this.m_forceUnmarshal = force;
    }

    public PropertyDefinition getProperty() {
        return this.m_property;
    }

    public boolean isOptional() {
        return this.m_property.isOptional();
    }

    public boolean hasContent() {
        return this.m_forceUnmarshal || super.hasContent();
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (!this.m_property.isImplicit() && !this.m_property.isThis()) {
            mb.loadObject();
        }
        BranchWrapper ifpres = null;
        BranchWrapper tosave = null;
        if (this.m_property.isOptional()) {
            this.m_component.genAttrPresentTest(mb);
            ifpres = mb.appendIFNE(this);
            mb.appendACONST_NULL();
            tosave = mb.appendUnconditionalBranch(this);
        }
        mb.targetNext(ifpres);
        if (this.m_property.isImplicit()) {
            this.m_component.genNewInstance(mb);
        } else if (!this.m_property.isThis()) {
            mb.loadObject();
            this.m_property.genLoad(mb);
            mb.appendCreateCast(this.m_property.getGetValueType(), this.m_component.getType());
            mb.appendDUP();
            BranchWrapper haveinst = mb.appendIFNONNULL(this);
            mb.appendPOP();
            this.m_component.genNewInstance(mb);
            mb.targetNext(haveinst);
        }
        this.m_component.genAttributeUnmarshal(mb);
        mb.appendCreateCast(this.m_component.getType(), this.m_property.getSetValueType());
        mb.targetNext(tosave);
        if (!this.m_property.isImplicit() && !this.m_property.isThis()) {
            this.m_property.genStore(mb);
        }
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_skipMarshal) {
            this.m_component.genAttributeMarshal(mb);
        } else {
            if (!this.m_property.isImplicit()) {
                mb.loadObject();
                this.m_property.genLoad(mb);
            }
            BranchWrapper ifpres = null;
            BranchWrapper toend = null;
            if (this.m_property.isOptional()) {
                mb.appendDUP();
                ifpres = mb.appendIFNONNULL(this);
                mb.appendPOP();
                toend = mb.appendUnconditionalBranch(this);
            }
            mb.targetNext(ifpres);
            this.m_component.genAttributeMarshal(mb);
            mb.targetNext(toend);
        }
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_component.hasAttribute()) {
            if (!this.m_property.isImplicit()) {
                mb.loadObject();
                this.m_property.genLoad(mb);
            } else {
                mb.appendDUP();
            }
            BranchWrapper toend = null;
            if (this.m_property.isOptional()) {
                toend = mb.appendIFNULL(this);
                if (!this.m_property.isImplicit()) {
                    mb.loadObject();
                    this.m_property.genLoad(mb);
                } else {
                    mb.appendDUP();
                }
            }
            this.m_component.genContentUnmarshal(mb);
            mb.appendPOP();
            mb.targetNext(toend);
        } else {
            if (!this.m_property.isImplicit() && !this.m_property.isThis()) {
                mb.loadObject();
            }
            BranchWrapper ifpres = null;
            BranchWrapper tosave = null;
            if (this.m_property.isOptional() && !this.m_forceUnmarshal) {
                this.m_component.genContentPresentTest(mb);
                ifpres = mb.appendIFNE(this);
                mb.appendACONST_NULL();
                tosave = mb.appendUnconditionalBranch(this);
            }
            mb.targetNext(ifpres);
            if (this.m_property.isImplicit()) {
                this.m_component.genNewInstance(mb);
            } else if (!this.m_property.isThis()) {
                mb.loadObject();
                this.m_property.genLoad(mb);
                mb.appendCreateCast(this.m_property.getGetValueType(), this.m_component.getType());
                mb.appendDUP();
                BranchWrapper haveinst = mb.appendIFNONNULL(this);
                mb.appendPOP();
                this.m_component.genNewInstance(mb);
                mb.targetNext(haveinst);
            }
            if (!this.m_forceUnmarshal) {
                this.m_component.genContentUnmarshal(mb);
            }
            mb.appendCreateCast(this.m_component.getType(), this.m_property.getSetValueType());
            mb.targetNext(tosave);
            if (!this.m_property.isImplicit() && !this.m_property.isThis()) {
                this.m_property.genStore(mb);
            }
        }
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_forceUnmarshal) {
            mb.appendPOP();
        } else if (this.m_skipMarshal) {
            this.m_component.genContentMarshal(mb);
        } else {
            if (!this.m_property.isImplicit()) {
                mb.loadObject();
                this.m_property.genLoad(mb);
            }
            BranchWrapper ifpres = null;
            BranchWrapper tonext = null;
            if (this.m_property.isOptional()) {
                mb.appendDUP();
                ifpres = mb.appendIFNONNULL(this);
                mb.appendPOP();
                tonext = mb.appendUnconditionalBranch(this);
            }
            mb.targetNext(ifpres);
            this.m_component.genContentMarshal(mb);
            mb.targetNext(tonext);
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("component " + this.m_property.toString());
        if (this.m_skipMarshal) {
            System.out.print(" (pass-through marshal)");
        }
        System.out.println();
        this.m_component.print(depth + 1);
    }
}

