/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.web.BaseOAuthWrapperController;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

@Component(value="oauth20WrapperController")
public final class OAuth20WrapperController
extends BaseOAuthWrapperController {
    @Resource(name="authorizeController")
    private Controller authorizeController;
    @Resource(name="callbackAuthorizeController")
    private Controller callbackAuthorizeController;
    @Resource(name="accessTokenController")
    private Controller accessTokenController;
    @Resource(name="profileController")
    private Controller profileController;

    @Override
    protected ModelAndView internalHandleRequest(String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("authorize".equals(method)) {
            return this.authorizeController.handleRequest(request, response);
        }
        if ("callbackAuthorize".equals(method)) {
            return this.callbackAuthorizeController.handleRequest(request, response);
        }
        if ("accessToken".equals(method)) {
            return this.accessTokenController.handleRequest(request, response);
        }
        if ("profile".equals(method)) {
            return this.profileController.handleRequest(request, response);
        }
        this.logger.error("Unknown method : {}", (Object)method);
        OAuthUtils.writeTextError((HttpServletResponse)response, (String)"invalid_request", (int)200);
        return null;
    }

    public Controller getAuthorizeController() {
        return this.authorizeController;
    }

    public Controller getCallbackAuthorizeController() {
        return this.callbackAuthorizeController;
    }

    public Controller getAccessTokenController() {
        return this.accessTokenController;
    }

    public Controller getProfileController() {
        return this.profileController;
    }
}

