/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.support.oauth.web.AccessTokenGenerator;
import org.jasig.cas.support.oauth.web.BaseOAuthWrapperController;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component(value="profileController")
public final class OAuth20ProfileController
extends BaseOAuthWrapperController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ProfileController.class);
    private static final String ID = "id";
    private static final String ATTRIBUTES = "attributes";
    @Autowired
    @Qualifier(value="defaultAccessTokenGenerator")
    private AccessTokenGenerator accessTokenGenerator;
    private final JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());

    /*
     * Unable to fully structure code
     */
    @Override
    protected ModelAndView internalHandleRequest(String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        accessToken = request.getParameter("access_token");
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)(authHeader = request.getHeader("Authorization"))) && authHeader.toLowerCase().startsWith(String.valueOf("Bearer".toLowerCase()) + ' ')) {
            accessToken = authHeader.substring("Bearer".length() + 1);
        }
        OAuth20ProfileController.LOGGER.debug("{} : {}", (Object)"access_token", (Object)accessToken);
        try {
            var5_5 = null;
            var6_7 = null;
            try {
                jsonGenerator = this.jsonFactory.createJsonGenerator((Writer)response.getWriter());
                try {
                    block25: {
                        block24: {
                            block23: {
                                response.setContentType("application/json");
                                if (StringUtils.isBlank((CharSequence)accessToken)) {
                                    OAuth20ProfileController.LOGGER.error("Missing {}", (Object)"access_token");
                                    jsonGenerator.writeStartObject();
                                    jsonGenerator.writeStringField("error", "missing_accessToken");
                                    jsonGenerator.writeEndObject();
                                    while (true) {
                                        response.flushBuffer();
                                        return null;
                                    }
                                }
                                pair = this.accessTokenGenerator.degenerate(accessToken);
                                accessToken = (String)pair.getFirst();
                                ticketGrantingTicket = this.verifyAccessToken(accessToken, jsonGenerator);
                                if (ticketGrantingTicket != null) break block23;
                                response.flushBuffer();
                                return null;
                            }
                            service = this.verifyRegisteredService(jsonGenerator, pair);
                            if (service != null) break block24;
                            response.flushBuffer();
                            return null;
                        }
                        principal = ticketGrantingTicket.getAuthentication().getPrincipal();
                        if (this.verifyPrincipalServiceAccess(jsonGenerator, service, principal)) break block25;
                        response.flushBuffer();
                        return null;
                    }
                    try {
                        this.writeOutProfileResponse(jsonGenerator, service, principal);
                    }
                    catch (Exception e) {
                        jsonGenerator.writeStartObject();
                        jsonGenerator.writeStringField("error", "invalid_request. " + e.getMessage());
                        jsonGenerator.writeEndObject();
                    }
                    ** try [egrp 11[TRYBLOCK] [9 : 380->388)] { 
                }
lbl54:
                // 1 sources

                catch (Throwable var5_6) {
                    throw var5_6;
                }
                finally {
                    if (jsonGenerator == null) ** continue;
                    jsonGenerator.close();
                }
lbl-1000:
                // 1 sources

                {
                    response.flushBuffer();
                    return null;
                }
            }
            catch (Throwable var6_8) {
                if (var5_5 == null) {
                    var5_5 = var6_8;
                } else if (var5_5 != var6_8) {
                    var5_5.addSuppressed(var6_8);
                }
                throw var5_5;
            }
        }
        catch (Throwable var12_15) {
            response.flushBuffer();
            throw var12_15;
        }
    }

    private boolean verifyPrincipalServiceAccess(JsonGenerator jsonGenerator, RegisteredService service, Principal principal) throws IOException {
        if (!service.getAccessStrategy().doPrincipalAttributesAllowServiceAccess(principal.getId(), principal.getAttributes())) {
            this.logger.warn("Service [{}] is not authorized for use by [{}].", (Object)service.getServiceId(), (Object)principal);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("error", "screen.service.error.message");
            jsonGenerator.writeEndObject();
            return false;
        }
        return true;
    }

    private RegisteredService verifyRegisteredService(JsonGenerator jsonGenerator, Pair<String, Service> pair) throws IOException {
        RegisteredService service = this.servicesManager.findServiceBy(Long.parseLong(((Service)pair.getSecond()).getId()));
        if (service == null || !service.getAccessStrategy().isServiceAccessAllowed()) {
            this.logger.warn("Service {}] is not found in the registry or it is disabled.", (Object)service);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("error", "invalid_request");
            jsonGenerator.writeEndObject();
            return null;
        }
        return service;
    }

    private TicketGrantingTicket verifyAccessToken(String accessToken, JsonGenerator jsonGenerator) throws IOException {
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.ticketRegistry.getTicket(accessToken);
        if (ticketGrantingTicket == null || ticketGrantingTicket.isExpired()) {
            LOGGER.error("expired accessToken : {}", (Object)accessToken);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("error", "invalid_request");
            jsonGenerator.writeEndObject();
            return null;
        }
        return ticketGrantingTicket;
    }

    private void writeOutProfileResponse(JsonGenerator jsonGenerator, RegisteredService service, Principal principal) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(ID, principal.getId());
        jsonGenerator.writeArrayFieldStart(ATTRIBUTES);
        Map attributes = service.getAttributeReleasePolicy().getAttributes(principal);
        for (Map.Entry entry : attributes.entrySet()) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

