/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.services.OAuthRegisteredService;
import org.jasig.cas.support.oauth.web.BaseOAuthWrapperController;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component(value="authorizeController")
public final class OAuth20AuthorizeController
extends BaseOAuthWrapperController {
    @Override
    protected ModelAndView internalHandleRequest(String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String clientId = request.getParameter("client_id");
        this.logger.debug("{} : {}", (Object)"client_id", (Object)clientId);
        String redirectUri = request.getParameter("redirect_uri");
        this.logger.debug("{} : {}", (Object)"redirect_uri", (Object)redirectUri);
        String state = request.getParameter("state");
        this.logger.debug("{} : {}", (Object)"state", (Object)state);
        if (StringUtils.isBlank((CharSequence)clientId)) {
            this.logger.error("Missing {}", (Object)"client_id");
            return new ModelAndView("serviceErrorView");
        }
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            this.logger.error("Missing {}", (Object)"redirect_uri");
            return new ModelAndView("serviceErrorView");
        }
        OAuthRegisteredService service = OAuthUtils.getRegisteredOAuthService((ServicesManager)this.servicesManager, (String)clientId);
        if (service == null) {
            this.logger.error("Unknown {} : {}", (Object)"client_id", (Object)clientId);
            return new ModelAndView("serviceErrorView");
        }
        String serviceId = service.getServiceId();
        if (!redirectUri.matches(serviceId)) {
            this.logger.error("Unsupported {} : {} for serviceId : {}", new Object[]{"redirect_uri", redirectUri, serviceId});
            return new ModelAndView("serviceErrorView");
        }
        HttpSession session = request.getSession();
        session.setAttribute("oauth20_callbackUrl", (Object)redirectUri);
        session.setAttribute("oauth20_service_name", (Object)service.getName());
        session.setAttribute("bypass_approval_prompt", (Object)service.isBypassApprovalPrompt());
        session.setAttribute("oauth20_state", (Object)state);
        String callbackAuthorizeUrl = request.getRequestURL().toString().replace("/authorize", "/callbackAuthorize");
        this.logger.debug("{} : {}", (Object)"callbackAuthorize", (Object)callbackAuthorizeUrl);
        String loginUrlWithService = OAuthUtils.addParameter((String)this.loginUrl, (String)"service", (String)callbackAuthorizeUrl);
        this.logger.debug("loginUrlWithService : {}", (Object)loginUrlWithService);
        return OAuthUtils.redirectTo((String)loginUrlWithService);
    }
}

