/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.OAuthWebApplicationService;
import org.jasig.cas.support.oauth.services.OAuthRegisteredService;
import org.jasig.cas.support.oauth.web.AccessTokenGenerator;
import org.jasig.cas.support.oauth.web.BaseOAuthWrapperController;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component(value="accessTokenController")
public final class OAuth20AccessTokenController
extends BaseOAuthWrapperController {
    @Autowired
    @Qualifier(value="defaultAccessTokenGenerator")
    private AccessTokenGenerator accessTokenGenerator;

    @Override
    protected ModelAndView internalHandleRequest(String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String redirectUri = request.getParameter("redirect_uri");
        this.logger.debug("{} : {}", (Object)"redirect_uri", (Object)redirectUri);
        String clientId = request.getParameter("client_id");
        this.logger.debug("{} : {}", (Object)"client_id", (Object)clientId);
        String clientSecret = request.getParameter("client_secret");
        String code = request.getParameter("code");
        this.logger.debug("{} : {}", (Object)"code", (Object)code);
        boolean isVerified = this.verifyAccessTokenRequest(response, redirectUri, clientId, clientSecret, code);
        if (!isVerified) {
            return OAuthUtils.writeTextError((HttpServletResponse)response, (String)"invalid_request", (int)400);
        }
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(code);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            this.logger.error("Code expired : {}", (Object)code);
            return OAuthUtils.writeTextError((HttpServletResponse)response, (String)"invalid_grant", (int)400);
        }
        TicketGrantingTicket ticketGrantingTicket = serviceTicket.getGrantingTicket();
        this.ticketRegistry.deleteTicket(serviceTicket.getId());
        OAuthRegisteredService registeredService = OAuthUtils.getRegisteredOAuthService((ServicesManager)this.servicesManager, (String)clientId);
        OAuthWebApplicationService service = new OAuthWebApplicationService(registeredService.getId());
        String accessTokenEncoded = this.accessTokenGenerator.generate((Service)service, ticketGrantingTicket);
        int expires = (int)(this.timeout - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - ticketGrantingTicket.getCreationTime()));
        String text = String.format("%s=%s&%s=%s", "access_token", accessTokenEncoded, "expires_in", expires);
        this.logger.debug("OAuth access token response: {}", (Object)text);
        response.setContentType("text/plain");
        return OAuthUtils.writeText((HttpServletResponse)response, (String)text, (int)200);
    }

    private boolean verifyAccessTokenRequest(HttpServletResponse response, String redirectUri, String clientId, String clientSecret, String code) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            this.logger.error("Missing {}", (Object)"client_id");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            this.logger.error("Missing {}", (Object)"redirect_uri");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)clientSecret)) {
            this.logger.error("Missing {}", (Object)"client_secret");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            this.logger.error("Missing {}", (Object)"code");
            return false;
        }
        OAuthRegisteredService service = OAuthUtils.getRegisteredOAuthService((ServicesManager)this.servicesManager, (String)clientId);
        if (service == null) {
            this.logger.error("Unknown {} : {}", (Object)"client_id", (Object)clientId);
            return false;
        }
        String serviceId = service.getServiceId();
        if (!redirectUri.matches(serviceId)) {
            this.logger.error("Unsupported {} : {} for serviceId : {}", new Object[]{"redirect_uri", redirectUri, serviceId});
            return false;
        }
        if (!StringUtils.equals((CharSequence)service.getClientSecret(), (CharSequence)clientSecret)) {
            this.logger.error("Wrong client secret for service {}", (Object)service);
            return false;
        }
        return true;
    }
}

