/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.support.oauth.web.AccessTokenGenerator;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.CompressionUtils;
import org.jasig.cas.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="defaultAccessTokenGenerator")
public final class DefaultAccessTokenGenerator
implements AccessTokenGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAccessTokenGenerator.class);
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    @Override
    public String generate(Service service, TicketGrantingTicket ticketGrantingTicket) {
        String accessToken = String.valueOf(ticketGrantingTicket.getId()) + "#" + service.getId();
        LOGGER.debug("Created access token {}, now encoding it as base64", (Object)accessToken);
        return CompressionUtils.encodeBase64((byte[])accessToken.getBytes());
    }

    @Override
    public Pair<String, Service> degenerate(String accessTokenInput) {
        String accessTokenEncoded = new String(CompressionUtils.decodeBase64((String)accessTokenInput));
        String[] token = accessTokenEncoded.split("#");
        if (token.length == 2) {
            return new Pair((Object)token[0], (Object)this.webApplicationServiceFactory.createService(token[1]));
        }
        throw new IllegalArgumentException("Access token received must include both the id and the requesting service");
    }
}

