/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

@Component(value="baseOAuthWrapperController")
public abstract class BaseOAuthWrapperController
extends AbstractController {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    @Value(value="${server.prefix:http://localhost:8080/cas}/login")
    protected String loginUrl;
    @NotNull
    @Autowired
    @Qualifier(value="servicesManager")
    protected ServicesManager servicesManager;
    @NotNull
    @Autowired
    @Qualifier(value="ticketRegistry")
    protected TicketRegistry ticketRegistry;
    @NotNull
    @Value(value="${tgt.timeToKillInSeconds:7200}")
    protected long timeout;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String method = this.getMethod(request);
        this.logger.debug("method : {}", (Object)method);
        return this.internalHandleRequest(method, request, response);
    }

    protected abstract ModelAndView internalHandleRequest(String var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    private String getMethod(HttpServletRequest request) {
        int pos;
        String method = request.getRequestURI();
        if (method.indexOf(63) >= 0) {
            method = StringUtils.substringBefore((String)method, (String)"?");
        }
        if ((pos = method.lastIndexOf(47)) >= 0) {
            method = method.substring(pos + 1);
        }
        return method;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

