/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth;

import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.support.oauth.services.OAuthCallbackAuthorizeService;
import org.jasig.cas.web.AbstractServletContextInitializer;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@WebListener
@Component
public class OAuthServletContextListener
extends AbstractServletContextInitializer {
    @Value(value="${server.prefix:http://localhost:8080/cas}/oauth2.0/callbackAuthorize")
    private String callbackAuthorizeUrl;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    protected void initializeServletApplicationContext() {
        this.addControllerToCasServletHandlerMapping("/oauth2.0/*", "oauth20WrapperController");
        ReloadableServicesManager servicesManager = this.getServicesManager();
        Service callbackService = this.webApplicationServiceFactory.createService(this.callbackAuthorizeUrl);
        if (!servicesManager.matchesExistingService(callbackService)) {
            OAuthCallbackAuthorizeService service = new OAuthCallbackAuthorizeService();
            service.setName("OAuth Callback url");
            service.setDescription("OAuth Wrapper Callback Url");
            service.setServiceId(this.callbackAuthorizeUrl);
            this.addRegisteredServiceToServicesManager((RegisteredService)service);
            servicesManager.reload();
        }
    }

    protected void initializeServletContext(ServletContextEvent event) {
        if (WebUtils.isCasServletInitializing((ServletContextEvent)event)) {
            this.addEndpointMappingToCasServlet(event, "/oauth2.0/*");
        }
    }
}

