/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.system.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ElasticSearchSetup {
    TRANSPORT_CLIENT{

        @Override
        public Connection connect(Configuration config) throws IOException {
            log.debug("Configuring TransportClient");
            ImmutableSettings.Builder settingsBuilder = ElasticSearchSetup.settingsBuilder(config);
            if (config.has(ElasticSearchIndex.CLIENT_SNIFF, new String[0])) {
                String k = "client.transport.sniff";
                settingsBuilder.put(k, ((Boolean)config.get(ElasticSearchIndex.CLIENT_SNIFF, new String[0])).booleanValue());
                log.debug("Set {}: {}", (Object)k, config.get(ElasticSearchIndex.CLIENT_SNIFF, new String[0]));
            }
            TransportClient tc = new TransportClient(settingsBuilder.build());
            int defaultPort = config.has(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) ? (Integer)config.get(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) : 9300;
            for (String host : (String[])config.get(GraphDatabaseConfiguration.INDEX_HOSTS, new String[0])) {
                String[] hostparts = host.split(":");
                String hostname = hostparts[0];
                int hostport = defaultPort;
                if (hostparts.length == 2) {
                    hostport = Integer.parseInt(hostparts[1]);
                }
                log.info("Configured remote host: {} : {}", (Object)hostname, (Object)hostport);
                tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, hostport));
            }
            return new Connection(null, (Client)tc);
        }
    }
    ,
    NODE{

        @Override
        public Connection connect(Configuration config) throws IOException {
            log.debug("Configuring Node Client");
            ImmutableSettings.Builder settingsBuilder = ElasticSearchSetup.settingsBuilder(config);
            if (config.has(ElasticSearchIndex.TTL_INTERVAL, new String[0])) {
                String k = "indices.ttl.interval";
                settingsBuilder.put(k, (String)config.get(ElasticSearchIndex.TTL_INTERVAL, new String[0]));
                log.debug("Set {}: {}", (Object)k, config.get(ElasticSearchIndex.TTL_INTERVAL, new String[0]));
            }
            ElasticSearchSetup.makeLocalDirsIfNecessary(settingsBuilder, config);
            NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder().settings(settingsBuilder.build());
            if (config.has(ElasticSearchIndex.CLIENT_ONLY, new String[0])) {
                boolean clientOnly = (Boolean)config.get(ElasticSearchIndex.CLIENT_ONLY, new String[0]);
                nodeBuilder.client(clientOnly).data(!clientOnly);
            }
            if (config.has(ElasticSearchIndex.LOCAL_MODE, new String[0])) {
                nodeBuilder.local(((Boolean)config.get(ElasticSearchIndex.LOCAL_MODE, new String[0])).booleanValue());
            }
            if (config.has(ElasticSearchIndex.LOAD_DEFAULT_NODE_SETTINGS, new String[0])) {
                nodeBuilder.loadConfigSettings(((Boolean)config.get(ElasticSearchIndex.LOAD_DEFAULT_NODE_SETTINGS, new String[0])).booleanValue());
            }
            Node node = nodeBuilder.node();
            Client client = node.client();
            return new Connection(node, client);
        }
    };

    private static final Logger log;

    private static ImmutableSettings.Builder settingsBuilder(Configuration config) throws IOException {
        String disableScriptsKey;
        String disableScriptsVal;
        String k;
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.put("client.transport.ignore_cluster_name", true);
        ElasticSearchSetup.applySettingsFromFile(settings, config, (ConfigOption<String>)GraphDatabaseConfiguration.INDEX_CONF_FILE);
        ElasticSearchSetup.applySettingsFromJanusGraphConf(settings, config, ElasticSearchIndex.ES_EXTRAS_NS);
        if (config.has(ElasticSearchIndex.CLUSTER_NAME, new String[0])) {
            String clustername = (String)config.get(ElasticSearchIndex.CLUSTER_NAME, new String[0]);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)clustername), (String)"Invalid cluster name: %s", (Object[])new Object[]{clustername});
            k = "cluster.name";
            settings.put(k, clustername);
            log.debug("Set {}: {}", (Object)k, (Object)clustername);
        }
        if (config.has(ElasticSearchIndex.IGNORE_CLUSTER_NAME, new String[0])) {
            boolean ignoreClusterName = (Boolean)config.get(ElasticSearchIndex.IGNORE_CLUSTER_NAME, new String[0]);
            k = "client.transport.ignore_cluster_name";
            settings.put(k, ignoreClusterName);
            log.debug("Set {}: {}", (Object)k, (Object)ignoreClusterName);
        }
        if (null != (disableScriptsVal = settings.get(disableScriptsKey = "script.disable_dynamic")) && !"false".equals(disableScriptsVal)) {
            log.warn("JanusGraph requires Elasticsearch dynamic scripting.  Setting {} to false.  Dynamic scripting must be allowed in the Elasticsearch cluster configuration.", (Object)disableScriptsKey);
        }
        settings.put(disableScriptsKey, false);
        log.debug("Set {}: {}", (Object)disableScriptsKey, (Object)false);
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void applySettingsFromFile(ImmutableSettings.Builder settings, Configuration config, ConfigOption<String> confFileOption) throws FileNotFoundException {
        block3: {
            block2: {
                if (!config.has(confFileOption, new String[0])) break block2;
                String confFile = (String)config.get(confFileOption, new String[0]);
                log.debug("Loading Elasticsearch settings from file {}", (Object)confFile);
                FileInputStream confStream = null;
                try {
                    confStream = new FileInputStream(confFile);
                    settings.loadFromStream(confFile, (InputStream)confStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(confStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)confStream);
                break block3;
            }
            log.debug("Option {} is not set; not attempting to load Elasticsearch settings from file", confFileOption);
        }
    }

    static void applySettingsFromJanusGraphConf(ImmutableSettings.Builder settings, Configuration config, ConfigNamespace rootNS) {
        int keysLoaded = 0;
        Map configSub = config.getSubset(rootNS, new String[0]);
        for (Map.Entry entry : configSub.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (null == val) continue;
            if (List.class.isAssignableFrom(val.getClass())) {
                List l = (List)val;
                settings.put(key, Joiner.on((String)",").join((Iterable)l));
            } else if (val.getClass().isArray()) {
                Object[] copy = new Object[Array.getLength(val)];
                for (int i = 0; i < copy.length; ++i) {
                    copy[i] = Array.get(val, i);
                }
                settings.put(key, Joiner.on((String)",").join(copy));
            } else {
                settings.put(key, val.toString());
            }
            log.debug("[ES ext.* cfg] Set {}: {}", (Object)key, val);
            ++keysLoaded;
        }
        log.debug("Loaded {} settings from the {} JanusGraph config namespace", (Object)keysLoaded, (Object)rootNS);
    }

    private static void makeLocalDirsIfNecessary(ImmutableSettings.Builder settingsBuilder, Configuration config) {
        if (config.has(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0])) {
            String dataDirectory = (String)config.get(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]);
            File f = new File(dataDirectory);
            if (!f.exists()) {
                log.info("Creating ES directory prefix: {}", (Object)f);
                f.mkdirs();
            }
            for (String sub : ElasticSearchIndex.DATA_SUBDIRS) {
                String subdir = dataDirectory + File.separator + sub;
                f = new File(subdir);
                if (!f.exists()) {
                    log.info("Creating ES {} directory: {}", (Object)sub, (Object)f);
                    f.mkdirs();
                }
                settingsBuilder.put("path." + sub, subdir);
                log.debug("Set ES {} directory: {}", (Object)sub, (Object)f);
            }
        }
    }

    public abstract Connection connect(Configuration var1) throws IOException;

    static {
        log = LoggerFactory.getLogger(ElasticSearchSetup.class);
    }

    public static class Connection {
        private final Node node;
        private final Client client;

        public Connection(Node node, Client client) {
            this.node = node;
            this.client = client;
            Preconditions.checkNotNull((Object)this.client, (Object)"Unable to instantiate Elasticsearch Client object");
        }

        public Node getNode() {
            return this.node;
        }

        public Client getClient() {
            return this.client;
        }
    }
}

