/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.StaticArrayEntryList;

public class CassandraHelper {
    public static List<ByteBuffer> convert(List<StaticBuffer> keys) {
        return keys.stream().map(StaticBuffer::asByteBuffer).collect(Collectors.toCollection(() -> new ArrayList(keys.size())));
    }

    public static <E> EntryList makeEntryList(Iterable<E> entries, StaticArrayEntry.GetColVal<E, ByteBuffer> getter, StaticBuffer lastColumn, int limit) {
        return StaticArrayEntryList.ofByteBuffer(() -> Iterators.filter(entries.iterator(), new FilterResultColumns(lastColumn, limit, getter)), getter);
    }

    public static <E> Iterator<Entry> makeEntryIterator(Iterable<E> entries, final StaticArrayEntry.GetColVal<E, ByteBuffer> getter, StaticBuffer lastColumn, int limit) {
        return Iterators.transform((Iterator)Iterators.filter(entries.iterator(), new FilterResultColumns(lastColumn, limit, getter)), (Function)new Function<E, Entry>(){

            @Nullable
            public Entry apply(@Nullable E e) {
                return StaticArrayEntry.ofByteBuffer(e, (StaticArrayEntry.GetColVal)getter);
            }
        });
    }

    public static KeyRange transformRange(Range<Token> range) {
        return CassandraHelper.transformRange((Token)range.left, (Token)range.right);
    }

    public static KeyRange transformRange(Token leftKeyExclusive, Token rightKeyInclusive) {
        byte[] rightTokenValue;
        if (!(leftKeyExclusive instanceof BytesToken)) {
            throw new UnsupportedOperationException();
        }
        assert (rightKeyInclusive instanceof BytesToken);
        BytesToken l = (BytesToken)leftKeyExclusive;
        BytesToken r = (BytesToken)rightKeyInclusive;
        byte[] leftTokenValue = l.getTokenValue();
        Preconditions.checkArgument((leftTokenValue.length == (rightTokenValue = r.getTokenValue()).length ? 1 : 0) != 0, (Object)"Tokens have unequal length");
        int tokenLength = leftTokenValue.length;
        byte[][] tokens = new byte[][]{leftTokenValue, rightTokenValue};
        byte[][] plusOne = new byte[2][tokenLength];
        for (int j = 0; j < 2; ++j) {
            boolean carry = true;
            for (int i = tokenLength - 1; i >= 0; --i) {
                byte b = tokens[j][i];
                if (carry) {
                    carry = (b = (byte)(b + 1)) == 0;
                }
                plusOne[j][i] = b;
            }
        }
        StaticArrayBuffer lb = StaticArrayBuffer.of((byte[])plusOne[0]);
        StaticArrayBuffer rb = StaticArrayBuffer.of((byte[])plusOne[1]);
        Preconditions.checkArgument((lb.length() == tokenLength ? 1 : 0) != 0, (Object)lb.length());
        Preconditions.checkArgument((rb.length() == tokenLength ? 1 : 0) != 0, (Object)rb.length());
        return new KeyRange((StaticBuffer)lb, (StaticBuffer)rb);
    }

    private static class FilterResultColumns<E>
    implements Predicate<E> {
        private int count = 0;
        private final int limit;
        private final StaticBuffer lastColumn;
        private final StaticArrayEntry.GetColVal<E, ByteBuffer> getter;

        private FilterResultColumns(StaticBuffer lastColumn, int limit, StaticArrayEntry.GetColVal<E, ByteBuffer> getter) {
            this.limit = limit;
            this.lastColumn = lastColumn;
            this.getter = getter;
        }

        public boolean apply(@Nullable E e) {
            assert (e != null);
            if (this.count >= this.limit || BufferUtil.equals((StaticBuffer)this.lastColumn, (ByteBuffer)((ByteBuffer)this.getter.getColumn(e)))) {
                return false;
            }
            ++this.count;
            return true;
        }
    }
}

