/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.granite.generator.as3.reflect.JavaAbstractType;
import org.granite.generator.as3.reflect.JavaImport;
import org.granite.generator.as3.reflect.JavaInterface;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.service.annotations.IgnoredMethod;
import org.granite.messaging.service.annotations.RemoteDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaRemoteDestination
extends JavaAbstractType {
    protected final Set<JavaImport> imports = new HashSet<JavaImport>();
    protected final JavaType superclass;
    protected final List<JavaMethod> methods;
    protected final String destinationName;
    protected final String channelId;

    public JavaRemoteDestination(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        RemoteDestination rd;
        this.superclass = provider.getJavaTypeSuperclass(type);
        this.methods = Collections.unmodifiableList(this.initMethods());
        if (this.superclass != null) {
            this.addToImports(provider.getJavaImport(this.superclass.getType()));
        }
        if ((rd = type.getAnnotation(RemoteDestination.class)) != null) {
            this.destinationName = rd.id();
            this.channelId = rd.channel();
        } else {
            this.destinationName = null;
            this.channelId = null;
        }
    }

    public Set<JavaImport> getImports() {
        return this.imports;
    }

    protected void addToImports(JavaImport javaImport) {
        if (javaImport != null) {
            this.imports.add(javaImport);
        }
    }

    public boolean hasSuperclass() {
        return this.superclass != null;
    }

    public JavaType getSuperclass() {
        return this.superclass;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.type.isAnnotationPresent(annotation);
    }

    protected List<JavaMethod> initMethods() {
        ArrayList<JavaMethod> methodMap = new ArrayList<JavaMethod>();
        Method[] methods = null;
        methods = this.type.isInterface() ? this.type.getMethods() : this.type.getDeclaredMethods();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.isAnnotationPresent(IgnoredMethod.class)) {
                Class<?>[] classArray = method.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> clazz = classArray[n4];
                    if (clazz.isMemberClass() && !clazz.isEnum()) {
                        throw new UnsupportedOperationException("Inner classes are not supported (except enums): " + clazz);
                    }
                    this.addToImports(this.provider.getJavaImport(clazz));
                    ++n4;
                }
                methodMap.add(new JavaMethod(method, JavaMethod.MethodType.OTHER, this.provider));
            }
            ++n2;
        }
        return methodMap;
    }

    public JavaInterface convertToJavaInterface() {
        return new JavaInterface(this.getProvider(), this.getType(), this.getUrl());
    }
}

