/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wicket.test;

import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketServlet;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.IPropertiesFactoryContext;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.PropertiesFactory;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.settings.ResourceSettings;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerResourceStreamLocator;
import org.geoserver.web.GeoServerStringResourceLoader;
import org.geoserver.wicket.test.IComponentFactory;
import org.geoserver.wicket.test.TestHomePage;

public class WicketTestApplication
extends WebApplication {
    static String wtapath = WicketTestApplication.class.getPackage().getName().replaceAll("\\.", "/");
    static String gsapath = GeoServerApplication.class.getPackage().getName().replaceAll("\\.", "/");

    protected void init() {
        this.getResourceSettings().setResourceStreamLocator((IResourceStreamLocator)new GeoServerResourceStreamLocator());
        this.getResourceSettings().getStringResourceLoaders().add(new GeoServerStringResourceLoader());
        this.getResourceSettings().getStringResourceLoaders().add(new ComponentStringResourceLoader());
        this.getResourceSettings().getStringResourceLoaders().add(new ClassStringResourceLoader(((Object)((Object)this)).getClass()));
        this.getResourceSettings().setPropertiesFactory((IPropertiesFactory)new PropertiesFactory((IPropertiesFactoryContext)new ResourceSettings((Application)this)){

            public Properties load(Class<?> clazz, String path) {
                if (clazz == WicketTestApplication.class && path.startsWith(wtapath)) {
                    String newPath = path.replace(wtapath, gsapath);
                    return super.load(GeoServerApplication.class, newPath);
                }
                return super.load(clazz, path);
            }
        });
    }

    public Class<? extends Page> getHomePage() {
        return TestHomePage.class;
    }

    public static void start(IComponentFactory factory) {
        WicketTestApplication.start(factory, "/", 8080);
    }

    public static void start(IComponentFactory factory, String contextPath, int port) {
        if (factory == null) {
            throw new NullPointerException("You must provide a non null component factory");
        }
        TestHomePage.componentFactory = factory;
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setIdleTimeout(3600000L);
        connector.setSoLingerTime(-1);
        connector.setPort(port);
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)server, contextPath, 1);
        ServletHolder wicket = new ServletHolder(WicketServlet.class);
        wicket.setInitParameter("applicationClassName", WicketTestApplication.class.getName());
        root.addServlet(wicket, "/*");
        try {
            System.out.println(">>> STARTING EMBEDDED JETTY SERVER, PRESS ANY KEY TO STOP");
            server.start();
            while (System.in.available() == 0) {
                Thread.sleep(1000L);
            }
            server.stop();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    static {
        wtapath = wtapath + "/" + WicketTestApplication.class.getSimpleName();
        gsapath = gsapath + "/" + GeoServerApplication.class.getSimpleName();
    }
}

