/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.event.UserGroupLoadedEvent;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.RoleCalculator;
import org.geoserver.security.impl.Util;
import org.geoserver.security.jdbc.AbstractJDBCService;
import org.geoserver.security.jdbc.JDBCUserGroupStore;
import org.geoserver.security.jdbc.config.JDBCSecurityServiceConfig;
import org.geoserver.security.jdbc.config.JDBCUserGroupServiceConfig;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.geotools.util.logging.Logging;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class JDBCUserGroupService
extends AbstractJDBCService
implements GeoServerUserGroupService {
    static final String DEFAULT_DML_FILE = "usersdml.xml";
    static final String DEFAULT_DDL_FILE = "usersddl.xml";
    protected SortedSet<GeoServerUser> emptyUsers;
    protected SortedSet<GeoServerUserGroup> emptyGroups;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.jdbc");
    protected Set<UserGroupLoadedListener> listeners = Collections.synchronizedSet(new HashSet());
    protected String passwordEncoderName;
    protected String passwordValidatorName;

    public JDBCUserGroupService() throws IOException {
        this.emptyUsers = Collections.unmodifiableSortedSet(new TreeSet());
        this.emptyGroups = Collections.unmodifiableSortedSet(new TreeSet());
    }

    public String getPasswordEncoderName() {
        return this.passwordEncoderName;
    }

    public String getPasswordValidatorName() {
        return this.passwordValidatorName;
    }

    public boolean canCreateStore() {
        return true;
    }

    public GeoServerUserGroupStore createStore() throws IOException {
        JDBCUserGroupStore store = new JDBCUserGroupStore();
        store.initializeFromService(this);
        return store;
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.name = config.getName();
        this.passwordEncoderName = ((SecurityUserGroupServiceConfig)config).getPasswordEncoderName();
        this.passwordValidatorName = ((SecurityUserGroupServiceConfig)config).getPasswordPolicyName();
        this.initializeDSFromConfig(config);
        if (config instanceof JDBCUserGroupServiceConfig) {
            String alias;
            KeyStoreProvider prov;
            GeoServerPasswordEncoder enc;
            JDBCUserGroupServiceConfig jdbcConfig = (JDBCUserGroupServiceConfig)config;
            String fileNameDML = jdbcConfig.getPropertyFileNameDML();
            Resource file = this.checkORCreateJDBCPropertyFile(fileNameDML, this.getConfigRoot(), DEFAULT_DML_FILE);
            this.dmlProps = Util.loadUniversal((InputStream)file.in());
            String fileNameDDL = jdbcConfig.getPropertyFileNameDDL();
            if (fileNameDDL != null && fileNameDDL.length() > 0) {
                file = this.checkORCreateJDBCPropertyFile(fileNameDDL, this.getConfigRoot(), DEFAULT_DDL_FILE);
                this.ddlProps = Util.loadUniversal((InputStream)file.in());
                this.createTablesIfRequired((JDBCSecurityServiceConfig)config);
            }
            if ((enc = this.getSecurityManager().loadPasswordEncoder(this.passwordEncoderName)).getEncodingType() == PasswordEncodingType.ENCRYPT && !(prov = this.getSecurityManager().getKeyStoreProvider()).containsAlias(alias = prov.aliasForGroupService(this.name))) {
                prov.setUserGroupKey(this.name, this.getSecurityManager().getRandomPassworddProvider().getRandomPasswordWithDefaultLength());
                prov.storeKeyStore();
            }
            enc.initializeFor((GeoServerUserGroupService)this);
            this.passwordValidatorName = jdbcConfig.getPasswordPolicyName();
        }
    }

    @Override
    protected String[] getOrderedNamesForCreate() {
        return new String[]{"users.create", "userprops.create", "groups.create", "groupmembers.create", "groupmembers.indexcreate", "userprops.indexcreate1", "userprops.indexcreate2"};
    }

    @Override
    protected String[] getOrderedNamesForDrop() {
        return new String[]{"groupmembers.drop", "groups.drop", "userprops.drop", "users.drop"};
    }

    public GeoServerUser getUserByUsername(String username) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        GeoServerUser u = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("users.keyed", con);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (rs.next()) {
                String password = rs.getString(1);
                String enabledString = rs.getString(2);
                boolean isEnabled = this.convertFromString(enabledString);
                u = this.createUserObject(username, password, isEnabled);
                ps2 = this.getDMLStatement("userprops.selectForUser", con);
                ps2.setString(1, username);
                rs2 = ps2.executeQuery();
                while (rs2.next()) {
                    String propName = rs2.getString(1);
                    Object propValue = rs2.getObject(2);
                    u.getProperties().put(propName, propValue == null ? "" : propValue);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(null, ps2, rs2);
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(null, ps2, rs2);
        this.closeFinally(con, ps, rs);
        return u;
    }

    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        GeoServerUserGroup g = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groups.keyed", con);
            ps.setString(1, groupname);
            rs = ps.executeQuery();
            if (rs.next()) {
                String enabledString = rs.getString(1);
                boolean isEnabled = this.convertFromString(enabledString);
                g = this.createGroupObject(groupname, isEnabled);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return g;
    }

    public SortedSet<GeoServerUser> getUsers() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, GeoServerUser> map = new HashMap<String, GeoServerUser>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("users.all", con);
            rs = ps.executeQuery();
            while (rs.next()) {
                String username = rs.getString(1);
                String password = rs.getString(2);
                String enabledString = rs.getString(3);
                boolean isEnabled = this.convertFromString(enabledString);
                GeoServerUser u = this.createUserObject(username, password, isEnabled);
                map.put(username, u);
            }
            ps.close();
            rs.close();
            ps = this.getDMLStatement("userprops.all", con);
            rs = ps.executeQuery();
            while (rs.next()) {
                String useName = rs.getString(1);
                String propName = rs.getString(2);
                String propValue = rs.getString(3);
                GeoServerUser u = (GeoServerUser)map.get(useName);
                if (u == null) continue;
                u.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        TreeSet users = new TreeSet();
        users.addAll(map.values());
        return Collections.unmodifiableSortedSet(users);
    }

    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<GeoServerUserGroup> tmp = new ArrayList<GeoServerUserGroup>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groups.all", con);
            rs = ps.executeQuery();
            while (rs.next()) {
                String groupname = rs.getString(1);
                String enabledString = rs.getString(2);
                boolean isEnabled = this.convertFromString(enabledString);
                GeoServerUserGroup g = this.createGroupObject(groupname, isEnabled);
                tmp.add(g);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        TreeSet<GeoServerUserGroup> groups = new TreeSet<GeoServerUserGroup>();
        groups.addAll(tmp);
        return Collections.unmodifiableSortedSet(groups);
    }

    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        GeoServerUser user = new GeoServerUser(username);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }

    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        GeoServerUserGroup group = new GeoServerUserGroup(groupname);
        group.setEnabled(isEnabled);
        return group;
    }

    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<GeoServerUserGroup> tmp = new ArrayList<GeoServerUserGroup>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groupmembers.groupsForUser", con);
            ps.setString(1, user.getUsername());
            rs = ps.executeQuery();
            while (rs.next()) {
                String groupname = rs.getString(1);
                String enabledString = rs.getString(2);
                boolean isEnabled = this.convertFromString(enabledString);
                GeoServerUserGroup g = this.createGroupObject(groupname, isEnabled);
                tmp.add(g);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        TreeSet<GeoServerUserGroup> groups = new TreeSet<GeoServerUserGroup>();
        groups.addAll(tmp);
        return Collections.unmodifiableSortedSet(groups);
    }

    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        HashMap<String, GeoServerUser> map = new HashMap<String, GeoServerUser>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groupmembers.usersForGroup", con);
            ps.setString(1, group.getGroupname());
            rs = ps.executeQuery();
            while (rs.next()) {
                String username = rs.getString(1);
                String password = rs.getString(2);
                String enabledString = rs.getString(3);
                boolean isEnabled = this.convertFromString(enabledString);
                GeoServerUser u = this.createUserObject(username, password, isEnabled);
                map.put(username, u);
            }
            rs.close();
            ps.close();
            ps = this.getDMLStatement("userprops.userPropsForGroup", con);
            ps.setString(1, group.getGroupname());
            rs = ps.executeQuery();
            while (rs.next()) {
                String userName = rs.getString(1);
                String propName = rs.getString(2);
                Object propValue = rs.getObject(3);
                GeoServerUser u = (GeoServerUser)map.get(userName);
                if (u == null) continue;
                u.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(null, ps2, rs2);
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(null, ps2, rs2);
        this.closeFinally(con, ps, rs);
        TreeSet users = new TreeSet();
        users.addAll(map.values());
        return Collections.unmodifiableSortedSet(users);
    }

    public int getUserCount() throws IOException {
        int count;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("users.count", con);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IOException("SQL query did not return a count");
            }
            count = rs.getInt(1);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return count;
    }

    public int getGroupCount() throws IOException {
        int count;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("groups.count", con);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IOException("SQL query did not return a count");
            }
            count = rs.getInt(1);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return count;
    }

    public void load() throws IOException {
    }

    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireUserGroupLoadedEvent() {
        UserGroupLoadedEvent event = new UserGroupLoadedEvent((GeoServerUserGroupService)this);
        for (UserGroupLoadedListener listener : this.listeners) {
            listener.usersAndGroupsChanged(event);
        }
    }

    public Resource getConfigRoot() throws IOException {
        return this.getSecurityManager().get("security/usergroup").get(this.getName());
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        GeoServerUser user = null;
        try {
            user = this.getUserByUsername(username);
            if (user == null) {
                throw new UsernameNotFoundException(this.userNotFoundMessage(username));
            }
            RoleCalculator calculator = new RoleCalculator((GeoServerUserGroupService)this, this.getSecurityManager().getActiveRoleService());
            user.setAuthorities((Set)calculator.calculateRoles(user));
        }
        catch (IOException e) {
            throw new UsernameNotFoundException(this.userNotFoundMessage(username), (Throwable)e);
        }
        return user;
    }

    protected String userNotFoundMessage(String username) {
        return "User  " + username + " not found in usergroupservice: " + this.getName();
    }

    public SortedSet<GeoServerUser> getUsersHavingProperty(String propname) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return this.emptyUsers;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, GeoServerUser> map = new HashMap<String, GeoServerUser>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("user.usersHavingProperty", con);
            ps.setString(1, propname);
            rs = ps.executeQuery();
            while (rs.next()) {
                String username = rs.getString(1);
                String password = rs.getString(2);
                String enabledString = rs.getString(3);
                boolean isEnabled = this.convertFromString(enabledString);
                GeoServerUser u = this.createUserObject(username, password, isEnabled);
                map.put(username, u);
            }
            ps.close();
            rs.close();
            ps = this.getDMLStatement("userprops.usersHavingProperty", con);
            ps.setString(1, propname);
            rs = ps.executeQuery();
            while (rs.next()) {
                String useName = rs.getString(1);
                String propName = rs.getString(2);
                String propValue = rs.getString(3);
                GeoServerUser u = (GeoServerUser)map.get(useName);
                if (u == null) continue;
                u.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        TreeSet users = new TreeSet();
        users.addAll(map.values());
        return Collections.unmodifiableSortedSet(users);
    }

    public int getUserCountHavingProperty(String propname) throws IOException {
        int count;
        if (!StringUtils.hasLength((String)propname)) {
            return 0;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("userprops.userCountHavingProperty", con);
            ps.setString(1, propname);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IOException("SQL query did not return a count");
            }
            count = rs.getInt(1);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return count;
    }

    public SortedSet<GeoServerUser> getUsersNotHavingProperty(String propname) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return this.emptyUsers;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, GeoServerUser> map = new HashMap<String, GeoServerUser>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("user.usersNotHavingProperty", con);
            ps.setString(1, propname);
            rs = ps.executeQuery();
            while (rs.next()) {
                String username = rs.getString(1);
                String password = rs.getString(2);
                String enabledString = rs.getString(3);
                boolean isEnabled = this.convertFromString(enabledString);
                GeoServerUser u = this.createUserObject(username, password, isEnabled);
                map.put(username, u);
            }
            ps.close();
            rs.close();
            ps = this.getDMLStatement("userprops.usersNotHavingProperty", con);
            ps.setString(1, propname);
            rs = ps.executeQuery();
            while (rs.next()) {
                String useName = rs.getString(1);
                String propName = rs.getString(2);
                String propValue = rs.getString(3);
                GeoServerUser u = (GeoServerUser)map.get(useName);
                if (u == null) continue;
                u.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        TreeSet users = new TreeSet();
        users.addAll(map.values());
        return Collections.unmodifiableSortedSet(users);
    }

    public int getUserCountNotHavingProperty(String propname) throws IOException {
        int count;
        if (!StringUtils.hasLength((String)propname)) {
            return this.getUserCount();
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("userprops.userCountNotHavingProperty", con);
            ps.setString(1, propname);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IOException("SQL query did not return a count");
            }
            count = rs.getInt(1);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return count;
    }

    public SortedSet<GeoServerUser> getUsersHavingPropertyValue(String propname, String propvalue) throws IOException {
        if (!StringUtils.hasLength((String)propname)) {
            return this.emptyUsers;
        }
        if (!StringUtils.hasLength((String)propvalue)) {
            return this.emptyUsers;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, GeoServerUser> map = new HashMap<String, GeoServerUser>();
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("user.usersHavingPropertyValue", con);
            ps.setString(1, propname);
            ps.setString(2, propvalue);
            rs = ps.executeQuery();
            while (rs.next()) {
                String username = rs.getString(1);
                String password = rs.getString(2);
                String enabledString = rs.getString(3);
                boolean isEnabled = this.convertFromString(enabledString);
                GeoServerUser u = this.createUserObject(username, password, isEnabled);
                map.put(username, u);
            }
            ps.close();
            rs.close();
            ps = this.getDMLStatement("userprops.usersHavingPropertyValue", con);
            ps.setString(1, propname);
            ps.setString(2, propvalue);
            rs = ps.executeQuery();
            while (rs.next()) {
                String useName = rs.getString(1);
                String propName = rs.getString(2);
                String propValue = rs.getString(3);
                GeoServerUser u = (GeoServerUser)map.get(useName);
                if (u == null) continue;
                u.getProperties().put(propName, propValue == null ? "" : propValue);
            }
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        TreeSet users = new TreeSet();
        users.addAll(map.values());
        return Collections.unmodifiableSortedSet(users);
    }

    public int getUserCountHavingPropertyValue(String propname, String propvalue) throws IOException {
        int count;
        if (!StringUtils.hasLength((String)propname)) {
            return 0;
        }
        if (!StringUtils.hasLength((String)propvalue)) {
            return 0;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("userprops.userCountHavingPropertyValue", con);
            ps.setString(1, propname);
            ps.setString(2, propvalue);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IOException("SQL query did not return a count");
            }
            count = rs.getInt(1);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, rs);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, rs);
        return count;
    }
}

