/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSCascadeTestSupport;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.ows.HTTPResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class WMSCascadeTest
extends WMSCascadeTestSupport {
    private final boolean aphEnabled;

    @Parameterized.Parameters(name="{index} APH enabled: {0}")
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({true}, {false});
    }

    public WMSCascadeTest(boolean aphEnabled) {
        this.aphEnabled = aphEnabled;
    }

    @Before
    public void setupAdvancedProjectionHandling() {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.valueOf(this.aphEnabled));
        wms.setFeaturesReprojectionDisabled(false);
        gs.save((ServiceInfo)wms);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        URL pngImage = WMSTestSupport.class.getResource("world.png");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?service=WMS&version=1.3.0&request=GetMap&layers=world4326&styles&bbox=-110.0,-200.0,110.0,200.0&crs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=190&height=100"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        this.wms11Client.expectGet(new URL(this.wms11BaseURL + "?service=WMS&version=1.1.1&request=GetMap&layers=world4326&styles&bbox=-200.0,-110.0,200.0,110.0&srs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=190&height=100"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        URL featureInfo = WMSTestSupport.class.getResource("wms-features.xml");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?SERVICE=WMS&INFO_FORMAT=application/vnd.ogc.gml&LAYERS=world4326&CRS=EPSG:4326&FEATURE_COUNT=50&FORMAT=image%2Fpng&HEIGHT=101&TRANSPARENT=TRUE&J=-609621&REQUEST=GetFeatureInfo&I=-875268&WIDTH=101&BBOX=-103.829117187,44.3898919295,-103.804563429,44.4069939679&STYLES=&QUERY_LAYERS=world4326&VERSION=1.3.0"), (HTTPResponse)new MockHttpResponse(featureInfo, "application/vnd.ogc.gml", new String[0]));
    }

    @Test
    public void testCascadeGetMapOnto13() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-90,-180,90,180&styles=&layers=world4326_130&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:4326");
        this.checkImage(response, "image/png", 180, 90);
    }

    @Test
    public void testCascadeGetMapOnto11() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-90,-180,90,180&styles=&layers=world4326_110&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:4326");
        this.checkImage(response, "image/png", 180, 90);
    }

    @Test
    public void testCascadeCapabilitiesClientNoGetFeatureInfo() throws Exception {
        Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.3.0&service=wms");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("link", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        SimpleNamespaceContext newNsCtxt = new SimpleNamespaceContext(namespaces);
        this.xpath.setNamespaceContext((NamespaceContext)newNsCtxt);
        this.xpath.evaluate("//wms:Layer[name='world4326_110_NFI']", dom);
    }

    @Test
    public void testGetFeatureInfoReprojection() throws Exception {
        String url = "wms?SERVICE=WMS&VERSION=1.3.0&REQUEST=GetFeatureInfo&FORMAT=image/png&TRANSPARENT=true&QUERY_LAYERS=world4326_130&STYLES&LAYERS=world4326_130&INFO_FORMAT=text/xml; subtype=gml/3.1.1&FEATURE_COUNT=50&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=-103.829117187,44.3898919295,-103.804563429,44.4069939679";
        Document result = this.getAsDOM(url);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("gs", "http://geoserver.org");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        String srs = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/@srsName", result);
        Assert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)srs.contains("4326"), (Matcher)CoreMatchers.is((Object)true));
        String rawCoordinates = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/gml:pos/text()", result);
        Assert.assertThat((Object)rawCoordinates, (Matcher)CoreMatchers.notNullValue());
        String[] coordinates = rawCoordinates.split(" ");
        Assert.assertThat((Object)coordinates.length, (Matcher)CoreMatchers.is((Object)2));
        WMSCascadeTest.checkNumberSimilar(coordinates[0], 44.39832008, 1.0E-4);
        WMSCascadeTest.checkNumberSimilar(coordinates[1], -103.81711048, 1.0E-4);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setFeaturesReprojectionDisabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        result = this.getAsDOM(url);
        srs = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/@srsName", result);
        Assert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)srs.contains("3857"), (Matcher)CoreMatchers.is((Object)true));
        rawCoordinates = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/gml:pos/text()", result);
        Assert.assertThat((Object)rawCoordinates, (Matcher)CoreMatchers.notNullValue());
        coordinates = rawCoordinates.split(" ");
        Assert.assertThat((Object)coordinates.length, (Matcher)CoreMatchers.is((Object)2));
        WMSCascadeTest.checkNumberSimilar(coordinates[0], -1.1556867874E7, 1.0E-4);
        WMSCascadeTest.checkNumberSimilar(coordinates[1], 5527291.47718493, 1.0E-4);
    }
}

