/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class DimensionsVectorCapabilitiesTest
extends WMSDimensionsTestSupport {
    @Test
    public void testNoDimension() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='sf:TimeElevation'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
    }

    @Test
    public void testDefaultElevationUnits() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:5030", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"m", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
    }

    @Test
    public void testEmptyDataSet() throws Exception {
        for (DimensionPresentation p : DimensionPresentation.values()) {
            this.setupVectorDimension(this.V_TIME_ELEVATION_EMPTY.getLocalPart(), "time", "time", p, null, null, null);
            this.checkEmptyTimeDimensionAndExtent();
        }
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(this.V_TIME_ELEVATION_EMPTY.getLocalPart());
        info.getMetadata().remove((Object)"time");
        this.getCatalog().save((ResourceInfo)info);
        for (DimensionPresentation p : DimensionPresentation.values()) {
            this.setupVectorDimension(this.V_TIME_ELEVATION_EMPTY.getLocalPart(), "elevation", "elevation", p, null, "foot", "ft");
            this.checkEmptyElevationDimensionAndExtent();
        }
    }

    void checkEmptyElevationDimensionAndExtent() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    void checkEmptyTimeDimensionAndExtent() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationList() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,1.0,2.0,3.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationContinuous() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/3.0/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationDiscrerteNoResolution() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.DISCRETE_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/3.0/1.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationDiscrerteManualResolution() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.DISCRETE_INTERVAL, 2.0, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/3.0/2.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeList() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wms:Layer/wms:Dimension/@nearestValue", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z,2011-05-02T00:00:00.000Z,2011-05-03T00:00:00.000Z,2011-05-04T00:00:00.000Z", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testNearestMatch() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wms:Layer/wms:Dimension/@nearestValue", (Document)dom);
    }

    @Test
    public void testTimeContinuous() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z/2011-05-04T00:00:00.000Z/PT1S", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeResolution() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.DISCRETE_INTERVAL, new Double(8.64E7), null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z/2011-05-04T00:00:00.000Z/P1D", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeElevation() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension[@name='elevation']/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension[@name='elevation']/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension[@name='time']/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension[@name='elevation'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension[@name='elevation']/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,1.0,2.0,3.0", (String)"//wms:Layer/wms:Dimension[@name='elevation']", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension[@name='time'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension[@name='time']/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z,2011-05-02T00:00:00.000Z,2011-05-03T00:00:00.000Z,2011-05-04T00:00:00.000Z", (String)"//wms:Layer/wms:Dimension[@name='time']", (Document)dom);
    }

    @Test
    public void testDefaultTimeRangeFixed() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("P1M/PRESENT");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "time", defaultValueSetting, new String[0]);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"P1M/PRESENT", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
    }

    @Test
    public void testDefaultElevationRangeFixed() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("-100/0");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "elevation", defaultValueSetting, new String[0]);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-100/0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
    }
}

