/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSCascadeTestSupport;
import org.geoserver.wms.WMSInfo;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class WMSCascadeTest
extends WMSCascadeTestSupport {
    private final boolean aphEnabled;

    @Parameterized.Parameters(name="{index} APH enabled: {0}")
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({true}, {false});
    }

    public WMSCascadeTest(boolean aphEnabled) {
        this.aphEnabled = aphEnabled;
    }

    @Before
    public void setupAdvancedProjectionHandling() {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.valueOf(this.aphEnabled));
        gs.save((ServiceInfo)wms);
    }

    @Test
    public void testCascadeGetMapOnto130() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-180,-90,180,90&styles=&layers=world4326_130&Format=image/png&request=GetMap&width=180&height=90&srs=EPSG:4326");
        this.checkImage(response, "image/png", 180, 90);
    }

    @Test
    public void testCascadeGetMapOnto110() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-180,-90,180,90&styles=&layers=world4326_110&Format=image/png&request=GetMap&width=180&height=90&srs=EPSG:4326");
        this.checkImage(response, "image/png", 180, 90);
    }

    @Test
    public void testCascadeCapabilitiesClientNoGetFeatureInfo() throws Exception {
        Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.1.0&service=wms");
        this.xpath.evaluate("//Layer[name='world4326_110_NFI']", dom);
    }
}

