/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapTest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.ImageAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetMapIntegrationTest
extends WMSTestSupport {
    private static final QName ONE_BIT = new QName(MockData.SF_URI, "onebit", MockData.SF_PREFIX);
    private static final QName MOSAIC_HOLES = new QName(MockData.SF_URI, "mosaic_holes", MockData.SF_PREFIX);
    private static final QName MOSAIC = new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX);
    private static final QName MASKED = new QName(MockData.SF_URI, "masked", MockData.SF_PREFIX);
    public static QName GIANT_POLYGON = new QName(MockData.CITE_URI, "giantPolygon", MockData.CITE_PREFIX);
    public static QName LARGE_POLYGON = new QName(MockData.CITE_URI, "slightlyLessGiantPolygon", MockData.CITE_PREFIX);
    String bbox = "-130,24,-66,50";
    String styles = "states";
    String layers = "sf:states";
    public static final String STATES_SLD = "<StyledLayerDescriptor version=\"1.0.0\"><UserLayer><Name>sf:states</Name><UserStyle><Name>UserSelection</Name><FeatureTypeStyle><Rule><Filter xmlns:gml=\"http://www.opengis.net/gml\"><PropertyIsEqualTo><PropertyName>STATE_ABBR</PropertyName><Literal>IL</Literal></PropertyIsEqualTo></Filter><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#FF0000</CssParameter></Fill></PolygonSymbolizer></Rule><Rule><LineSymbolizer><Stroke/></LineSymbolizer></Rule></FeatureTypeStyle></UserStyle></UserLayer></StyledLayerDescriptor>";
    public static final String STATES_SLD11 = "<StyledLayerDescriptor version=\"1.1.0\">  <UserLayer>   <Name>sf:states</Name>   <UserStyle>    <Name>UserSelection</Name>    <se:FeatureTypeStyle xmlns:se=\"http://www.opengis.net/se\">     <se:Rule>      <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\">       <ogc:PropertyIsEqualTo>        <ogc:PropertyName>STATE_ABBR</ogc:PropertyName>        <ogc:Literal>IL</ogc:Literal>       </ogc:PropertyIsEqualTo>      </ogc:Filter>      <se:PolygonSymbolizer>       <se:Fill>        <se:SvgParameter name=\"fill\">#FF0000</se:SvgParameter>       </se:Fill>      </se:PolygonSymbolizer>     </se:Rule>     <se:Rule>      <se:LineSymbolizer>       <se:Stroke/>      </se:LineSymbolizer>     </se:Rule>    </se:FeatureTypeStyle>   </UserStyle>  </UserLayer> </StyledLayerDescriptor>";
    public static final String STATES_GETMAP = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n <ogc:GetMap service=\"WMS\"  version=\"1.1.1\" \n         xmlns:gml=\"http://www.opengis.net/gml\"\n         xmlns:ogc=\"http://www.opengis.net/ows\"\n         xmlns:sld=\"http://www.opengis.net/sld\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://www.opengis.net/ows GetMap.xsd http://www.opengis.net/gml geometry.xsd http://www.opengis.net/sld StyledLayerDescriptor.xsd \">\n         <sld:StyledLayerDescriptor>\n                 <sld:NamedLayer>\n                         <sld:Name>sf:states</sld:Name>\n                         <sld:NamedStyle>\n                                 <sld:Name>Default</sld:Name>\n                         </sld:NamedStyle>\n                 </sld:NamedLayer>\n         </sld:StyledLayerDescriptor>\n         <ogc:BoundingBox srsName=\"4326\">\n                 <gml:coord>\n                         <gml:X>-130</gml:X>\n                         <gml:Y>24</gml:Y>\n                 </gml:coord>\n                 <gml:coord>\n                         <gml:X>-66</gml:X>\n                         <gml:Y>50</gml:Y>\n                 </gml:coord>\n         </ogc:BoundingBox>\n         <ogc:Output>\n                 <ogc:Format>image/png</ogc:Format>\n                 <ogc:Size>\n                         <ogc:Width>550</ogc:Width>\n                         <ogc:Height>250</ogc:Height>\n                 </ogc:Size>\n         </ogc:Output>\n </ogc:GetMap>\n ";

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs11RasterLayers();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("Population", "Population.sld", GetMapIntegrationTest.class, catalog);
        testData.addStyle("jiffleBandSelect", "jiffleBandSelect.sld", GetMapIntegrationTest.class, catalog);
        testData.addVectorLayer(new QName(MockData.SF_URI, "states", MockData.SF_PREFIX), Collections.EMPTY_MAP, "states.properties", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("parametric", "parametric.sld", org.geoserver.wms.map.GetMapIntegrationTest.class, catalog);
        testData.addStyle("translucent", "translucent.sld", GetMapIntegrationTest.class, catalog);
        testData.addStyle("raster", "raster.sld", SystemTestData.class, catalog);
        testData.addStyle("demTranslucent", "demTranslucent.sld", GetMapIntegrationTest.class, catalog);
        HashMap<SystemTestData.LayerProperty, String> properties = new HashMap<SystemTestData.LayerProperty, String>();
        properties.put(SystemTestData.LayerProperty.STYLE, "raster");
        testData.addRasterLayer(MOSAIC_HOLES, "mosaic_holes.zip", null, properties, GetMapIntegrationTest.class, catalog);
        testData.addRasterLayer(ONE_BIT, "onebit.zip", null, properties, GetMapIntegrationTest.class, catalog);
        testData.addRasterLayer(MOSAIC, "mosaic.zip", null, properties, GetMapIntegrationTest.class, catalog);
        testData.addRasterLayer(MASKED, "masked.tif", null, properties, GetMapIntegrationTest.class, catalog);
        testData.addVectorLayer(GIANT_POLYGON, Collections.EMPTY_MAP, "giantPolygon.properties", SystemTestData.class, this.getCatalog());
        testData.addVectorLayer(LARGE_POLYGON, Collections.EMPTY_MAP, "slightlyLessGiantPolygon.properties", GetMapTest.class, this.getCatalog());
        this.addCoverageViewLayer();
        this.setupOpaqueGroup(catalog);
    }

    private void addCoverageViewLayer() throws Exception {
        CoverageView.InputCoverageBand ib0 = new CoverageView.InputCoverageBand("mosaic", "2");
        CoverageView.CoverageBand b0 = new CoverageView.CoverageBand(Collections.singletonList(ib0), "mosaic@2", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib1 = new CoverageView.InputCoverageBand("mosaic", "1");
        CoverageView.CoverageBand b1 = new CoverageView.CoverageBand(Collections.singletonList(ib1), "mosaic@1", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib2 = new CoverageView.InputCoverageBand("mosaic", "0");
        CoverageView.CoverageBand b2 = new CoverageView.CoverageBand(Collections.singletonList(ib2), "mosaic@0", 2, CoverageView.CompositionType.BAND_SELECT);
        ArrayList<CoverageView.CoverageBand> coverageBands = new ArrayList<CoverageView.CoverageBand>(3);
        coverageBands.add(b0);
        coverageBands.add(b1);
        coverageBands.add(b2);
        CoverageView coverageView = new CoverageView("mosaic_shuffle", coverageBands);
        Catalog cat = this.getCatalog();
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("mosaic");
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfoView = coverageView.createCoverageInfo("mosaic_shuffle", storeInfo, builder);
        coverageInfoView.getParameters().put("USE_JAI_IMAGEREAD", "false");
        cat.add((ResourceInfo)coverageInfoView);
        LayerInfo layerInfoView = builder.buildLayer(coverageInfoView);
        cat.add(layerInfoView);
    }

    protected String getDefaultLogConfiguration() {
        return "/DEFAULT_LOGGING.properties";
    }

    @Test
    public void testImage() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        this.checkImage(response);
    }

    @Test
    public void testAllowedMimeTypes() throws Exception {
        WMSInfo wms = this.getWMS().getServiceInfo();
        RenderedImageMapOutputFormat format = new RenderedImageMapOutputFormat(this.getWMS());
        wms.getGetMapMimeTypes().add(format.getMimeType());
        wms.setGetMapMimeTypeCheckingEnabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        this.checkImage(response);
        String result = this.getAsString("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=" + "text/html; subtype=openlayers" + "&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertTrue((result.indexOf("ForbiddenFormat") > 0 ? 1 : 0) != 0);
        wms.setGetMapMimeTypeCheckingEnabled(false);
        wms.getGetMapMimeTypes().clear();
        this.getGeoServer().save((ServiceInfo)wms);
        result = this.getAsString("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=" + "text/html; subtype=openlayers" + "&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertTrue((result.indexOf("OpenLayers") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLayoutLegendNPE() throws Exception {
        FeatureTypeInfo states = this.getCatalog().getFeatureTypeByName("states");
        states.setTitle(null);
        this.getCatalog().save((ResourceInfo)states);
        File layouts = this.getDataDirectory().findOrCreateDir(new String[]{"layouts"});
        URL layout = GetMapIntegrationTest.class.getResource("test-layout.xml");
        FileUtils.copyURLToFile((URL)layout, (File)new File(layouts, "test-layout.xml"));
        BufferedImage image = this.getAsImage("wms?bbox=" + this.bbox + "&styles=Population&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&format_options=layout:test-layout", "image/png");
        this.assertPixel(image, 12, 16, Color.RED);
        this.assertPixel(image, 12, 32, Color.GREEN);
        this.assertPixel(image, 12, 52, Color.BLUE);
    }

    @Test
    public void testLayoutLegendStyleTitle() throws Exception {
        FeatureTypeInfo states = this.getCatalog().getFeatureTypeByName("states");
        states.setTitle(null);
        this.getCatalog().save((ResourceInfo)states);
        File layouts = this.getDataDirectory().findOrCreateDir(new String[]{"layouts"});
        URL layout = GetMapIntegrationTest.class.getResource("test-layout-sldtitle.xml");
        FileUtils.copyURLToFile((URL)layout, (File)new File(layouts, "test-layout-sldtitle.xml"));
        BufferedImage image = this.getAsImage("wms?bbox=" + this.bbox + "&styles=Population&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&format_options=layout:test-layout-sldtitle", "image/png");
        this.assertPixel(image, 12, 36, Color.RED);
        this.assertPixel(image, 12, 52, Color.GREEN);
        this.assertPixel(image, 12, 72, Color.BLUE);
    }

    @Test
    public void testLayoutTranslucent() throws Exception {
        File layouts = this.getDataDirectory().findOrCreateDir(new String[]{"layouts"});
        URL layout = GetMapIntegrationTest.class.getResource("test-layout.xml");
        FileUtils.copyURLToFile((URL)layout, (File)new File(layouts, "test-layout.xml"));
        BufferedImage image = this.getAsImage("wms?bbox=" + this.bbox + "&styles=translucent&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&format_options=layout:test-layout&transparent=true", "image/png");
        this.assertPixel(image, 56, 211, Color.WHITE);
        Assert.assertTrue((this.getPixelColor(image, 52, 221).equals(Color.BLACK) || this.getPixelColor(image, 52, 222).equals(Color.BLACK) ? 1 : 0) != 0);
    }

    @Test
    public void testGeotiffMime() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/geotiff&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/geotiff", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=sf-states.tif", (Object)response.getHeader("Content-Disposition"));
    }

    @Test
    public void testLargerThanWorld() throws Exception {
        org.apache.log4j.Logger l4jLogger = this.getLog4JLogger(GetMap.class, "LOGGER");
        l4jLogger.addAppender((Appender)new AppenderSkeleton(){

            public boolean requiresLayout() {
                return false;
            }

            public void close() {
            }

            protected void append(LoggingEvent event) {
                if (event.getMessage() != null && event.getMessage().toString().startsWith("Failed to compute the scale denominator")) {
                    Assert.fail((String)"The error message is still there!");
                }
            }
        });
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-9.6450076761637E7,-3.9566251818225E7,9.6450076761637E7,3.9566251818225E7&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:900913");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=sf-states.png", (Object)response.getHeader("Content-Disposition"));
    }

    private org.apache.log4j.Logger getLog4JLogger(Class targetClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = targetClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        Logger jlogger = (Logger)field.get(null);
        Field l4jField = jlogger.getClass().getDeclaredField("logger");
        l4jField.setAccessible(true);
        org.apache.log4j.Logger l4jLogger = (org.apache.log4j.Logger)l4jField.get(jlogger);
        return l4jLogger;
    }

    @Test
    public void testPng8Opaque() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=sf-states.png", (Object)response.getHeader("Content-Disposition"));
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        IndexColorModel cm = (IndexColorModel)bi.getColorModel();
        Assert.assertEquals((long)1L, (long)cm.getTransparency());
        Assert.assertEquals((long)-1L, (long)cm.getTransparentPixel());
    }

    @Test
    public void testPng8ForceBitmask() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true&format_options=quantizer:octree");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=sf-states.png", (Object)response.getHeader("Content-Disposition"));
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        IndexColorModel cm = (IndexColorModel)bi.getColorModel();
        Assert.assertEquals((long)2L, (long)cm.getTransparency());
        Assert.assertTrue((cm.getTransparentPixel() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPng8Translucent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=sf-states.png", (Object)response.getHeader("Content-Disposition"));
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        IndexColorModel cm = (IndexColorModel)bi.getColorModel();
        Assert.assertEquals((long)3L, (long)cm.getTransparency());
    }

    @Test
    public void testDefaultContentDisposition() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=sf-states.png", (Object)response.getHeader("Content-Disposition"));
    }

    @Test
    public void testForcedContentDisposition() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&content-disposition=attachment");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)"attachment; filename=sf-states.png", (Object)response.getHeader("Content-Disposition"));
    }

    @Test
    public void testForcedFilename() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&filename=dude.png");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=dude.png", (Object)response.getHeader("Content-Disposition"));
    }

    @Test
    public void testForcedContentDispositionFilename() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&content-disposition=attachment&filename=dude.png");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)"attachment; filename=dude.png", (Object)response.getHeader("Content-Disposition"));
    }

    @Test
    public void testSldBody() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_BODY=" + STATES_SLD.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testStyleBody() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&STYLE_BODY=" + STATES_SLD.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testSldBody11() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_BODY=" + STATES_SLD11.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testStyleBody11() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&STYLE_BODY=" + STATES_SLD11.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testSldBodyNoVersion() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_BODY=" + STATES_SLD.replace(" version=\"1.1.0\"", "").replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testStyleBodyNoVersion() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&STYLE_BODY=" + STATES_SLD.replace(" version=\"1.1.0\"", "").replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testSldBodyPost() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wms?bbox=" + this.bbox + "&format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326", STATES_SLD);
        this.checkImage(response);
    }

    @Test
    public void testSldBodyPost11() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wms?bbox=" + this.bbox + "&format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326", STATES_SLD11);
        this.checkImage(response);
    }

    @Test
    public void testXmlPost() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wms?", STATES_GETMAP);
        this.checkImage(response);
    }

    @Test
    public void testRemoteOWSGet() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=getmap&service=wms&version=1.1.1&format=image/png&layers=topp:states," + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=Population," + MockData.BASIC_POLYGONS.getLocalPart() + "&remote_ows_type=WFS&remote_ows_url=" + "http://demo.opengeo.org/geoserver/wfs?" + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testRemoteOWSUserStyleGet() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        URL url = GetMapIntegrationTest.class.getResource("remoteOws.sld");
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=getmap&service=wms&version=1.1.1&format=image/png&sld=" + url.toString() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Document doc = this.getAsDOM("cite/wms?request=getmap&service=wms&layers=PrimitiveGeoFeature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90", true);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
        MockHttpServletResponse response = this.getAsServletResponse("cite/wms?request=getmap&service=wms&layers=Lakes&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testLayerQualified() throws Exception {
        Document doc = this.getAsDOM("cite/Ponds/wms?request=getmap&service=wms&layers=Forests&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90", true);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
        MockHttpServletResponse response = this.getAsServletResponse("cite/Ponds/wms?request=getmap&service=wms&layers=Ponds&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testGroupWorkspaceQualified() throws Exception {
        String url = "wms?request=getmap&service=wms&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
        MockHttpServletResponse response = this.getAsServletResponse(url);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        response = this.getAsServletResponse("cite/" + url);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testEnvDefault() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=parametric&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] rgba = new int[3];
        image.getData().getPixel(250, 125, rgba);
    }

    @Test
    public void testEnvRed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=parametric&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&env=color:0xFF0000");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] rgba = new int[3];
        image.getData().getPixel(250, 125, rgba);
    }

    @Test
    public void testMosaicHoles() throws Exception {
        String url = "wms?LAYERS=sf%3Amosaic_holes&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&SRS=EPSG%3A4326&BBOX=6.40284375,36.385494140625,12.189662109375,42.444494140625&WIDTH=489&HEIGHT=512&transparent=true";
        BufferedImage bi = this.getAsImage(url, "image/png");
        int[] pixel = new int[4];
        bi.getRaster().getPixel(0, 250, pixel);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 0, 0, 255}, pixel));
        CoverageInfo ci = this.getCatalog().getCoverageByName("sf:mosaic_holes");
        Map params = ci.getParameters();
        params.put(ImageMosaicFormat.INPUT_TRANSPARENT_COLOR.getName().getCode(), "#000000");
        params.put(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName().getCode(), "#000000");
        this.getCatalog().save((ResourceInfo)ci);
        bi = this.getAsImage(url, "image/png");
        bi.getRaster().getPixel(0, 250, pixel);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{255, 255, 255, 0}, pixel));
    }

    @Test
    public void testTransparentPaletteOpaqueOutput() throws Exception {
        String url = "wms?LAYERS=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=145,-43,146,-41&WIDTH=100&HEIGHT=200&bgcolor=0xFF0000";
        BufferedImage bi = this.getAsImage(url, "image/png");
        ColorModel cm = bi.getColorModel();
        Assert.assertTrue((boolean)(cm instanceof IndexColorModel));
        Assert.assertEquals((long)1L, (long)cm.getTransparency());
        int[] pixel = new int[1];
        bi.getRaster().getPixel(4, 196, pixel);
        int[] color = new int[3];
        cm.getComponents(pixel[0], color, 0);
        Assert.assertEquals((long)255L, (long)color[0]);
        Assert.assertEquals((long)0L, (long)color[1]);
        Assert.assertEquals((long)0L, (long)color[2]);
        bi.getRaster().getPixel(56, 49, pixel);
        cm.getComponents(pixel[0], color, 0);
        Assert.assertEquals((long)0L, (long)color[0]);
        Assert.assertEquals((long)255L, (long)color[1]);
        Assert.assertEquals((long)0L, (long)color[2]);
    }

    @Test
    public void testCoverageViewMap() throws Exception {
        String url = "wms?LAYERS=mosaic&&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=7,37,11,41&WIDTH=100&HEIGHT=200&bgcolor=0xFF0000";
        BufferedImage bi = this.getAsImage(url, "image/png");
        int[] pixel = new int[3];
        bi.getRaster().getPixel(50, 100, pixel);
        int R_PIXEL = 45;
        int G_PIXEL = 46;
        int B_PIXEL = 69;
        Assert.assertEquals((long)45L, (long)pixel[0]);
        Assert.assertEquals((long)46L, (long)pixel[1]);
        Assert.assertEquals((long)69L, (long)pixel[2]);
        url = "wms?LAYERS=mosaic_shuffle&&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=7,37,11,41&WIDTH=100&HEIGHT=200&bgcolor=0xFF0000";
        bi = this.getAsImage(url, "image/png");
        bi.getRaster().getPixel(50, 100, pixel);
        Assert.assertEquals((long)69L, (long)pixel[0]);
        Assert.assertEquals((long)46L, (long)pixel[1]);
        Assert.assertEquals((long)45L, (long)pixel[2]);
    }

    @Test
    public void testTransparentPaletteTransparentOutput() throws Exception {
        String url = "wms?LAYERS=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=145,-43,146,-41&WIDTH=100&HEIGHT=200&transparent=true";
        BufferedImage bi = this.getAsImage(url, "image/png");
        ColorModel cm = bi.getColorModel();
        Assert.assertTrue((boolean)(cm instanceof IndexColorModel));
        Assert.assertEquals((long)3L, (long)cm.getTransparency());
        int[] pixel = new int[1];
        bi.getRaster().getPixel(4, 196, pixel);
        int[] color = new int[4];
        cm.getComponents(pixel[0], color, 0);
        Assert.assertEquals((long)0L, (long)color[3]);
        bi.getRaster().getPixel(56, 49, pixel);
        cm.getComponents(pixel[0], color, 0);
        Assert.assertEquals((long)0L, (long)color[0]);
        Assert.assertEquals((long)255L, (long)color[1]);
        Assert.assertEquals((long)0L, (long)color[2]);
        Assert.assertEquals((long)255L, (long)color[3]);
    }

    @Test
    public void testTransparentPaletteTransparentOutputPng8() throws Exception {
        String url = "wms?LAYERS=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&FORMAT=image%2Fpng8&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=145,-43,146,-41&WIDTH=100&HEIGHT=200&transparent=true";
        BufferedImage bi = this.getAsImage(url, "image/png; mode=8bit");
        ColorModel cm = bi.getColorModel();
        Assert.assertTrue((boolean)(cm instanceof IndexColorModel));
        Assert.assertEquals((long)3L, (long)cm.getTransparency());
        int[] pixel = new int[1];
        bi.getRaster().getPixel(4, 196, pixel);
        int[] color = new int[4];
        cm.getComponents(pixel[0], color, 0);
        Assert.assertEquals((long)0L, (long)color[3]);
        bi.getRaster().getPixel(56, 49, pixel);
        cm.getComponents(pixel[0], color, 0);
        Assert.assertEquals((long)0L, (long)color[0]);
        Assert.assertEquals((long)255L, (long)color[1]);
        Assert.assertEquals((long)0L, (long)color[2]);
        Assert.assertEquals((long)255L, (long)color[3]);
    }

    @Test
    public void testLayoutLegendStyleTitleDPI() throws Exception {
        FeatureTypeInfo states = this.getCatalog().getFeatureTypeByName("states");
        states.setTitle(null);
        this.getCatalog().save((ResourceInfo)states);
        File layouts = this.getDataDirectory().findOrCreateDir(new String[]{"layouts"});
        URL layout = GetMapIntegrationTest.class.getResource("test-layout-sldtitle.xml");
        FileUtils.copyURLToFile((URL)layout, (File)new File(layouts, "test-layout-sldtitle.xml"));
        int dpi = 180;
        int width = 1100;
        int height = 500;
        BufferedImage image = this.getAsImage("wms?bbox=" + this.bbox + "&styles=Population&layers=" + this.layers + "&Format=image/png&request=GetMap&width=" + width + "&height=" + height + "&srs=EPSG:4326&format_options=layout:test-layout-sldtitle;dpi:" + dpi, "image/png");
        this.assertPixel(image, 15, 67, Color.RED);
        this.assertPixel(image, 15, 107, Color.GREEN);
        this.assertPixel(image, 15, 147, Color.BLUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupSingle() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.SINGLE, null);
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            BufferedImage image = this.getAsImage(url, "image/png");
            this.assertPixel(image, 150, 160, Color.WHITE);
            this.assertPixel(image, 180, 16, COLOR_PLACES_GRAY);
            this.assertPixel(image, 90, 200, COLOR_LAKES_BLUE);
        }
        finally {
            catalog.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupNamed() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            BufferedImage image = this.getAsImage(url, "image/png");
            this.assertPixel(image, 150, 160, Color.WHITE);
            this.assertPixel(image, 180, 16, COLOR_PLACES_GRAY);
            this.assertPixel(image, 90, 200, COLOR_LAKES_BLUE);
        }
        finally {
            catalog.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupContainer() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.CONTAINER, null);
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            MockHttpServletResponse resp = this.getAsServletResponse(url);
            Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)resp.getContentType());
            Document dom = this.getAsDOM(url);
            Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
            Element serviceException = (Element)dom.getDocumentElement().getElementsByTagName("ServiceException").item(0);
            Assert.assertEquals((Object)"LayerNotDefined", (Object)serviceException.getAttribute("code"));
            Assert.assertEquals((Object)"layers", (Object)serviceException.getAttribute("locator"));
            Assert.assertEquals((Object)("Could not find layer " + group.getName()), (Object)serviceException.getTextContent().trim());
        }
        finally {
            catalog.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupModeEo() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.EO, catalog.getLayerByName(this.getLayerId(MockData.LAKES)));
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            BufferedImage image = this.getAsImage(url, "image/png");
            this.assertPixel(image, 150, 160, Color.WHITE);
            this.assertPixel(image, 180, 16, Color.WHITE);
            this.assertPixel(image, 90, 200, COLOR_LAKES_BLUE);
        }
        finally {
            catalog.remove(group);
        }
    }

    @Test
    public void testOneBit() throws Exception {
        String url = "wms?LAYERS=" + this.getLayerId(ONE_BIT) + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=10&HEIGHT=10&BBOX=0,0,10,10";
        this.getAsImage(url, "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSldExternalEntities() throws Exception {
        URL sldUrl = TestData.class.getResource("externalEntities.sld");
        String url = "wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&sld=" + sldUrl.toString();
        WMS wms = new WMS(this.getGeoServer());
        GeoServerInfo geoserverInfo = wms.getGeoServer().getGlobal();
        try {
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(true));
            this.getGeoServer().save(geoserverInfo);
            String response = this.getAsString(url);
            Assert.assertTrue((response.indexOf("Error while getting SLD.") > -1 ? 1 : 0) != 0);
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(false));
            this.getGeoServer().save(geoserverInfo);
            response = this.getAsString(url);
            Assert.assertTrue((response.indexOf("Entity resolution disallowed") > -1 ? 1 : 0) != 0);
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
            response = this.getAsString(url);
            Assert.assertTrue((response.indexOf("Entity resolution disallowed") > -1 ? 1 : 0) != 0);
        }
        finally {
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
        }
    }

    @Test
    public void testRssMime() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=reflect&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&format=rss");
        Assert.assertEquals((Object)"application/rss+xml", (Object)response.getContentType());
    }

    @Test
    public void testPolarStereographic() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.1&request=GetMap&layers=sf:states&bbox=-10700000,-10700000,14700000,14700000,EPSG:5041&width=200&height=200&srs=EPSG:5041&format=image%2Fpng");
        this.checkImage(response, "image/png", 200, 200);
        String testName = "testPolarStereographic";
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        this.assertNotBlank(testName, image);
        this.assertNotBlank(testName, image.getSubimage(0, 0, 100, 100));
        Assert.assertEquals((long)0L, (long)this.countNonBlankPixels(testName, image.getSubimage(0, 0, 200, 50), BG_COLOR));
        Assert.assertEquals((long)0L, (long)this.countNonBlankPixels(testName, image.getSubimage(100, 0, 100, 200), BG_COLOR));
        Assert.assertEquals((long)0L, (long)this.countNonBlankPixels(testName, image.getSubimage(0, 130, 200, 70), BG_COLOR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapWrapping() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        Boolean original = (Boolean)wms.getMetadata().get(WMS.MAP_WRAPPING_KEY, Boolean.class);
        try {
            wms.getMetadata().put(WMS.MAP_WRAPPING_KEY, (Serializable)Boolean.TRUE);
            gs.save((ServiceInfo)wms);
            String layer = this.getLayerId(GIANT_POLYGON);
            String request = "wms?version=1.1.1&bbox=170,-10,190,10&format=image/png&request=GetMap&layers=" + layer + "&styles=polygon&width=100&height=100&srs=EPSG:4326";
            String wrapDisabledOptionRequest = request + "&format_options=mapWrapping:false";
            String wrapEnabledOptionRequest = request + "&format_options=mapWrapping:true";
            BufferedImage image = this.getAsImage(request, "image/png");
            this.assertPixel(image, 75, 0, new Color(170, 170, 170));
            image = this.getAsImage(wrapDisabledOptionRequest, "image/png");
            this.assertPixel(image, 75, 0, Color.WHITE);
            image = this.getAsImage(wrapEnabledOptionRequest, "image/png");
            this.assertPixel(image, 75, 0, new Color(170, 170, 170));
            wms.getMetadata().put(WMS.MAP_WRAPPING_KEY, (Serializable)Boolean.FALSE);
            gs.save((ServiceInfo)wms);
            image = this.getAsImage(request, "image/png");
            this.assertPixel(image, 75, 0, Color.WHITE);
            image = this.getAsImage(wrapDisabledOptionRequest, "image/png");
            this.assertPixel(image, 75, 0, Color.WHITE);
            image = this.getAsImage(wrapEnabledOptionRequest, "image/png");
            this.assertPixel(image, 75, 0, Color.WHITE);
        }
        finally {
            wms.getMetadata().put(WMS.MAP_WRAPPING_KEY, (Serializable)original);
            gs.save((ServiceInfo)wms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdvancedProjectionHandling() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        Boolean original = (Boolean)wms.getMetadata().get(WMS.ADVANCED_PROJECTION_KEY, Boolean.class);
        try {
            wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.TRUE);
            gs.save((ServiceInfo)wms);
            String layer = this.getLayerId(LARGE_POLYGON);
            String request = "wms?version=1.1.1&bbox=-18643898.1832,0,18084728.7111,20029262&format=image/png&request=GetMap&layers=" + layer + "&styles=polygon&width=400&height=400&srs=EPSG:3832";
            String disabledRequest = request + "&format_options=advancedProjectionHandling:false";
            String enabledRequest = request + "&format_options=advancedProjectionHandling:true";
            BufferedImage image = this.getAsImage(request, "image/png");
            this.assertPixel(image, 200, 200, Color.WHITE);
            image = this.getAsImage(disabledRequest, "image/png");
            this.assertPixel(image, 200, 200, new Color(170, 170, 170));
            image = this.getAsImage(enabledRequest, "image/png");
            this.assertPixel(image, 200, 200, Color.WHITE);
            wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.FALSE);
            gs.save((ServiceInfo)wms);
            image = this.getAsImage(request, "image/png");
            this.assertPixel(image, 200, 200, new Color(170, 170, 170));
            image = this.getAsImage(disabledRequest, "image/png");
            this.assertPixel(image, 200, 200, new Color(170, 170, 170));
            image = this.getAsImage(enabledRequest, "image/png");
            this.assertPixel(image, 200, 200, new Color(170, 170, 170));
        }
        finally {
            wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)original);
            gs.save((ServiceInfo)wms);
        }
    }

    @Test
    public void testJpegPngTransparent() throws Exception {
        String request = "wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image%2Fvnd.jpeg-png&TRANSPARENT=true&STYLES&LAYERS=cite%3ABasicPolygons&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-2.4%2C1.4%2C0.4%2C4.2";
        BufferedImage image = this.getAsImage(request, "image/png");
        this.assertNotBlank("testJpegPngTransparent", image);
    }

    @Test
    public void testJpegPng8Transparent() throws Exception {
        String request = "wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image%2Fvnd.jpeg-png8&TRANSPARENT=true&STYLES&LAYERS=cite%3ABasicPolygons&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-2.4%2C1.4%2C0.4%2C4.2";
        MockHttpServletResponse resp = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"image/png", (Object)resp.getContentType());
        Assert.assertEquals((Object)"inline; filename=cite-BasicPolygons.png", (Object)resp.getHeader("Content-Disposition"));
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(resp));
        this.assertNotBlank("testJpegPngTransparent", image);
        Assert.assertThat((Object)image.getColorModel(), (Matcher)CoreMatchers.instanceOf(IndexColorModel.class));
    }

    @Test
    public void testJpegPngOpaque() throws Exception {
        String request = "wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image%2Fvnd.jpeg-png&TRANSPARENT=true&STYLES&LAYERS=cite%3ABasicPolygons&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-0.4%2C3.6%2C1%2C5";
        MockHttpServletResponse resp = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"image/jpeg", (Object)resp.getContentType());
        Assert.assertEquals((Object)"inline; filename=cite-BasicPolygons.jpg", (Object)resp.getHeader("Content-Disposition"));
        ByteArrayInputStream is = this.getBinaryInputStream(resp);
        BufferedImage image = ImageIO.read(is);
        this.assertNotBlank("testJpegPngOpaque", image);
    }

    @Test
    public void testJpegPng8Opaque() throws Exception {
        String request = "wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image%2Fvnd.jpeg-png8&TRANSPARENT=true&STYLES&LAYERS=cite%3ABasicPolygons&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-0.4%2C3.6%2C1%2C5";
        BufferedImage image = this.getAsImage(request, "image/jpeg");
        this.assertNotBlank("testJpegPngOpaque", image);
    }

    @Test
    public void testJpegPngEmpty() throws Exception {
        String request = "wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image%2Fvnd.jpeg-png&TRANSPARENT=true&STYLES&LAYERS=cite%3ABasicPolygons&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-1.9%2C1.8%2C-1.3%2C2.5";
        BufferedImage image = this.getAsImage(request, "image/png");
        this.assertBlank("testJpegPngEmpty", image, new Color(255, 255, 255, 0));
    }

    @Test
    public void testFeatureIdMultipleLayers() throws Exception {
        String lakes = this.getLayerId(MockData.LAKES);
        String places = this.getLayerId(MockData.NAMED_PLACES);
        String urlSingle = "wms?LAYERS=" + lakes + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
        BufferedImage imageLakes = this.getAsImage(urlSingle, "image/png");
        String url = "wms?LAYERS=" + lakes + "," + places + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010&featureId=Lakes.1107531835962";
        BufferedImage imageLakesPlaces = this.getAsImage(url, "image/png");
        ImageAssert.assertEquals((RenderedImage)imageLakes, (RenderedImage)imageLakesPlaces, (int)0);
    }

    @Test
    public void testGetMapOpaqueGroup() throws Exception {
        String url = "wms?LAYERS=opaqueGroup&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-0.0043,-0.0025,0.0043,0.0025";
        BufferedImage imageGroup = this.getAsImage(url, "image/png");
        ImageAssert.assertEquals((File)new File("./src/test/resources/org/geoserver/wms/wms_1_1_1/opaqueGroup.png"), (RenderedImage)imageGroup, (int)300);
    }

    @Test
    public void testGetMapLayersInOpaqueGroup() throws Exception {
        LayerGroupInfo group = this.getCatalog().getLayerGroupByName("opaqueGroup");
        for (PublishedInfo pi : group.layers()) {
            String url = "wms?LAYERS=" + pi.prefixedName() + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-0.0043,-0.0025,0.0043,0.0025";
            Document dom = this.getAsDOM(url);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/ServiceExceptionReport)", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"layers", (String)"//ServiceException/@locator", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
        }
    }

    @Test
    public void testReprojectRGBTransparent() throws Exception {
        BufferedImage image = this.getAsImage("wms/reflect?layers=" + this.getLayerId(MockData.TASMANIA_BM) + "&SRS=EPSG:32753&format=image/png&transparent=true", "image/png");
        Assert.assertTrue((boolean)image.getColorModel().hasAlpha());
        Assert.assertEquals((long)4L, (long)image.getSampleModel().getNumBands());
        this.assertPixelIsTransparent(image, 0, 0);
        this.assertPixelIsTransparent(image, image.getWidth() - 1, 0);
        this.assertPixelIsTransparent(image, image.getWidth() - 1, image.getHeight() - 1);
        this.assertPixelIsTransparent(image, 0, image.getHeight() - 1);
    }

    @Test
    public void testReprojectRGBWithBgColor() throws Exception {
        BufferedImage image = this.getAsImage("wms/reflect?layers=" + this.getLayerId(MockData.TASMANIA_BM) + "&SRS=EPSG:32753&format=image/png&bgcolor=#FF0000", "image/png");
        Assert.assertFalse((boolean)image.getColorModel().hasAlpha());
        Assert.assertEquals((long)3L, (long)image.getSampleModel().getNumBands());
        this.assertPixel(image, 0, 0, Color.RED);
        this.assertPixel(image, image.getWidth() - 1, 0, Color.RED);
        this.assertPixel(image, image.getWidth() - 1, image.getHeight() - 1, Color.RED);
        this.assertPixel(image, 0, image.getHeight() - 1, Color.RED);
    }

    @Test
    public void testReprojectedDemWithTransparency() throws Exception {
        BufferedImage image = this.getAsImage("wms/reflect?layers=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&SRS=EPSG:32753&format=image/png&transparent=true", "image/png");
        Assert.assertTrue((boolean)image.getColorModel().hasAlpha());
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        this.assertPixelIsTransparent(image, 0, 0);
        this.assertPixelIsTransparent(image, image.getWidth() - 1, 0);
        this.assertPixelIsTransparent(image, image.getWidth() - 1, image.getHeight() - 1);
        this.assertPixelIsTransparent(image, 0, image.getHeight() - 1);
    }

    @Test
    public void testDemWithBgColor() throws Exception {
        BufferedImage image = this.getAsImage("wms/reflect?layers=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&SRS=EPSG:32753&format=image/png&bgcolor=#404040", "image/png");
        Assert.assertFalse((boolean)image.getColorModel().hasAlpha());
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        this.assertPixel(image, 0, 0, Color.DARK_GRAY);
        this.assertPixel(image, image.getWidth() - 1, 0, Color.DARK_GRAY);
        this.assertPixel(image, image.getWidth() - 1, image.getHeight() - 1, Color.DARK_GRAY);
        this.assertPixel(image, 0, image.getHeight() - 1, Color.DARK_GRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaskedNoAPH() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        Serializable oldValue = wms.getMetadata().get((Object)WMS.ADVANCED_PROJECTION_KEY);
        try {
            wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.valueOf(false));
            gs.save((ServiceInfo)wms);
            BufferedImage image = this.getAsImage("wms/reflect?layers=" + this.getLayerId(MASKED) + "&SRS=AUTO%3A97002%2C9001%2C-1%2C40&BBOX=694182%2C-4631295%2C695092%2C-4630379&format=image/png&transparent=true", "image/png");
            Assert.assertTrue((boolean)image.getColorModel().hasAlpha());
            Assert.assertThat((Object)image.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
            double[] maximums = new ImageWorker((RenderedImage)image).getMaximums();
            Assert.assertEquals((double)0.0, (double)maximums[maximums.length - 1], (double)0.0);
        }
        finally {
            wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, oldValue);
            gs.save((ServiceInfo)wms);
        }
    }

    @Test
    public void testRTAndBandSelection() throws Exception {
        String url = "wms?LAYERS=mosaic_shuffle&styles=jiffleBandSelect&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=7,37,11,41&WIDTH=100&HEIGHT=200&bgcolor=0xFF0000";
        BufferedImage jiffleBandSelected = this.getAsImage(url, "image/png");
        ImageAssert.assertEquals((File)new File("./src/test/resources/org/geoserver/wms/wms_1_1_1/jiffleBandSelected.png"), (RenderedImage)jiffleBandSelected, (int)300);
    }
}

