/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.capabilities.Capabilities_1_3_0_Transformer;
import org.geoserver.wms.capabilities.GetCapabilitiesTransformer;
import org.geotools.referencing.CRS;
import org.geotools.xml.transform.TransformerBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CapabilitiesTest
extends WMSTestSupport {
    private static final String BASE_URL = "http://localhost/geoserver";

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        DataStoreInfo info = catalog.getDataStoreByName(MockData.SF_PREFIX);
        info.setEnabled(false);
        catalog.save((StoreInfo)info);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        testData.addStyle(ws, "Lakes", "Lakes.sld", SystemTestData.class, catalog);
        testData.addStyle(ws, "tiger_roads", "tiger_roads.sld", SystemTestData.class, catalog);
        StyleInfo lakesStyle = catalog.getStyleByName(ws, "Lakes");
        LayerInfo lakesLayer = catalog.getLayerByName(MockData.LAKES.getLocalPart());
        lakesLayer.setDefaultStyle(lakesStyle);
        StyleInfo tigerRoadsStyle = catalog.getStyleByName(ws, "tiger_roads");
        lakesLayer.getStyles().add(tigerRoadsStyle);
        catalog.save(lakesLayer);
        this.setupOpaqueGroup(catalog);
    }

    @Test
    public void testCapabilities() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)e.getLocalName());
    }

    @Test
    public void testCapabilitiesNoWGS84DD() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathNotExists((String)"//SRS[text() = 'EPSG:WGS84(DD)']", (Document)dom);
    }

    @Test
    public void testCapabilitiesFormat() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=getCapabilities&version=1.1.1");
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/vnd.ogc.wms_xml"));
        response = this.getAsServletResponse("wms?request=getCapabilities&version=1.1.1&format=text/xml");
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"text/xml"));
        response = this.getAsServletResponse("wms?request=getCapabilities&version=1.1.1&format=invalid");
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/vnd.ogc.se_xml"));
        response = this.getAsServletResponse("wms?request=getCapabilities&version=1.1.1&format=");
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/vnd.ogc.wms_xml"));
    }

    @Test
    public void testGetCapabilities() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=getCapabilities&version=1.1.1");
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/vnd.ogc.wms_xml"));
        ByteArrayInputStream content = new ByteArrayInputStream(response.getContentAsByteArray());
        Document document = this.dom(content, true);
        for (String mimeType : GetCapabilitiesTransformer.WMS_CAPS_AVAIL_MIME) {
            XMLAssert.assertXpathExists((String)String.format("//GetCapabilities[Format='%s']", mimeType), (Document)document);
        }
    }

    @Test
    public void testGetCapsContainsNoDisabledTypes() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Name[text()='sf:PrimitiveGeoFeature'])", (Document)doc);
    }

    @Test
    public void testFilteredCapabilitiesCite() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&namespace=cite"), true);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//Layer/Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//Layer/Name[not(starts-with(., cite))]", dom).getLength());
    }

    @Test
    public void testLayerCount() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), true);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        NodeList nodeLayers = xpath.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/Layer", dom);
        Assert.assertEquals((long)this.getRawTopLayerCount(), (long)nodeLayers.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAdvertisedLayer() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        try {
            Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), true);
            XMLAssert.assertXpathExists((String)("//Layer[Name='" + layerId + "']"), (Document)dom);
            layer.setAdvertised(false);
            this.getCatalog().save(layer);
            dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), true);
            XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + layerId + "']"), (Document)dom);
        }
        finally {
            layer.setAdvertised(true);
            this.getCatalog().save(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAdvertisedLayerInLayerSpecificService() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        String context = layerId.replace(":", "/");
        String localName = MockData.BUILDINGS.getLocalPart();
        try {
            Document dom = this.dom(this.get(context + "/wms?request=getCapabilities&version=1.1.1"), true);
            XMLAssert.assertXpathExists((String)("//Layer[Name='" + localName + "']"), (Document)dom);
            layer.setAdvertised(false);
            this.getCatalog().save(layer);
            dom = this.dom(this.get(context + "/wms?request=getCapabilities&version=1.1.1"), true);
            XMLAssert.assertXpathExists((String)("//Layer[Name='" + localName + "']"), (Document)dom);
        }
        finally {
            layer.setAdvertised(true);
            this.getCatalog().save(layer);
        }
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Document dom = this.dom(this.get("cite/wms?request=getCapabilities&version=1.1.1"), true);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//Layer/Name[starts-with(., 'cite')]", dom).getLength());
        Assert.assertTrue((xpath.getMatchingNodes("//Layer/Name[not(starts-with(., 'cite'))]", dom).getLength() > 0 ? 1 : 0) != 0);
        NodeList nodes = xpath.getMatchingNodes("//Layer//OnlineResource", dom);
        Assert.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            String attribute = e.getAttribute("xlink:href");
            Assert.assertTrue((boolean)attribute.contains("geoserver/cite/wms"));
        }
    }

    @Test
    public void testLayerQualified() throws Exception {
        Document dom = this.dom(this.get("cite/Forests/wms?request=getCapabilities&version=1.1.1"), true);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//Layer/Name[starts-with(., 'cite:Forests')]", dom).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//Layer[Name = 'Forests']", dom).getLength());
        NodeList nodes = xpath.getMatchingNodes("//Layer//OnlineResource", dom);
        Assert.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            Assert.assertTrue((boolean)e.getAttribute("xlink:href").contains("geoserver/cite/Forests/wms"));
        }
    }

    @Test
    public void testAttribution() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Attribution)", (Document)doc);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        AttributionInfo attr = points.getAttribution();
        attr.setTitle("Point Provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        attr = points.getAttribution();
        attr.setHref("http://example.com/points/provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/OnlineResource)", (Document)doc);
        attr = points.getAttribution();
        attr.setLogoURL("http://example.com/points/logo");
        attr.setLogoType("image/logo");
        attr.setLogoHeight(50);
        attr.setLogoWidth(50);
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/LogoURL)", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroup() throws Exception {
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo lg = this.getCatalog().getFactory().createLayerGroup();
        lg.setName("MyLayerGroup");
        lg.getLayers().add(points);
        lg.getStyles().add(null);
        builder.calculateLayerGroupBounds(lg, CRS.decode((String)"EPSG:4326"));
        lg.setAttribution(this.getCatalog().getFactory().createAttribution());
        lg.getAttribution().setTitle("My Attribution");
        MetadataLinkInfo info = this.getCatalog().getFactory().createMetadataLink();
        info.setType("text/html");
        info.setMetadataType("FGDC");
        info.setContent("http://my/metadata/link");
        lg.getMetadataLinks().add(info);
        this.getCatalog().add(lg);
        this.addKeywordsToLayerGroup("MyLayerGroup");
        try {
            Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='MyLayerGroup']/Attribution)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"My Attribution", (String)"//Layer[Name='MyLayerGroup']/Attribution/Title", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='MyLayerGroup']/MetadataURL)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"http://my/metadata/link", (String)"//Layer[Name='MyLayerGroup']/MetadataURL/OnlineResource/@xlink:href", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//Layer[Name='MyLayerGroup']/KeywordList/Keyword)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='MyLayerGroup']/KeywordList[Keyword='keyword1'])", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='MyLayerGroup']/KeywordList[Keyword='keyword2'])", (Document)doc);
        }
        finally {
            this.getCatalog().remove(lg);
        }
    }

    @Test
    public void testAlternateStyles() throws Exception {
        StyleInfo pointStyle = this.getCatalog().getStyleByName("point");
        LayerInfo layer = this.getCatalog().getLayerByName("Fifteen");
        layer.getStyles().add(pointStyle);
        this.getCatalog().save(layer);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='cdf:Fifteen'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//Layer[Name='cdf:Fifteen']/Style)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String href = xpath.evaluate("//Layer[Name='cdf:Fifteen']/Style[Name='Default']/LegendURL/OnlineResource/@xlink:href", doc);
        Assert.assertTrue((boolean)href.contains("GetLegendGraphic"));
        Assert.assertTrue((boolean)href.contains("layer=cdf%3AFifteen"));
        Assert.assertFalse((boolean)href.contains("style"));
        href = xpath.evaluate("//Layer[Name='cdf:Fifteen']/Style[Name='point']/LegendURL/OnlineResource/@xlink:href", doc);
        Assert.assertTrue((boolean)href.contains("GetLegendGraphic"));
        Assert.assertTrue((boolean)href.contains("layer=cdf%3AFifteen"));
        Assert.assertTrue((boolean)href.contains("style=point"));
    }

    @Test
    public void testServiceMetadata() throws Exception {
        WMSInfo service = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        service.setTitle("test title");
        service.setAbstract("test abstract");
        service.setAccessConstraints("test accessConstraints");
        service.setFees("test fees");
        service.getKeywords().clear();
        service.getKeywords().add(new Keyword("test keyword 1"));
        service.getKeywords().add(new Keyword("test keyword 2"));
        service.setMaintainer("test maintainer");
        service.setOnlineResource("http://example.com/geoserver");
        GeoServerInfo global = this.getGeoServer().getGlobal();
        ContactInfo contact = global.getContact();
        contact.setAddress("__address");
        contact.setAddressCity("__city");
        contact.setAddressCountry("__country");
        contact.setAddressPostalCode("__ZIP");
        contact.setAddressState("__state");
        contact.setAddressType("__type");
        contact.setContactEmail("e@mail");
        contact.setContactOrganization("__org");
        contact.setContactFacsimile("__fax");
        contact.setContactPerson("__me");
        contact.setContactPosition("__position");
        contact.setContactVoice("__phone");
        this.getGeoServer().save(global);
        this.getGeoServer().save((ServiceInfo)service);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        String base = "WMT_MS_Capabilities/Service/";
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WMS", (String)(base + "Name"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test title", (String)(base + "Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test abstract", (String)(base + "Abstract"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 1", (String)(base + "KeywordList/Keyword[1]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 2", (String)(base + "KeywordList/Keyword[2]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://example.com/geoserver", (String)(base + "OnlineResource/@xlink:href"), (Document)doc);
        String cinfo = base + "ContactInformation/";
        XMLAssert.assertXpathEvaluatesTo((String)"__me", (String)(cinfo + "ContactPersonPrimary/ContactPerson"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__org", (String)(cinfo + "ContactPersonPrimary/ContactOrganization"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__position", (String)(cinfo + "ContactPosition"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__type", (String)(cinfo + "ContactAddress/AddressType"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__address", (String)(cinfo + "ContactAddress/Address"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__city", (String)(cinfo + "ContactAddress/City"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__state", (String)(cinfo + "ContactAddress/StateOrProvince"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__ZIP", (String)(cinfo + "ContactAddress/PostCode"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__country", (String)(cinfo + "ContactAddress/Country"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__phone", (String)(cinfo + "ContactVoiceTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__fax", (String)(cinfo + "ContactFacsimileTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"e@mail", (String)(cinfo + "ContactElectronicMailAddress"), (Document)doc);
    }

    @Test
    public void testNoFeesOrContraints() throws Exception {
        WMSInfo service = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        service.setAccessConstraints(null);
        service.setFees(null);
        this.getGeoServer().save((ServiceInfo)service);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        String base = "WMT_MS_Capabilities/Service/";
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WMS", (String)(base + "Name"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"none", (String)(base + "Fees"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"none", (String)(base + "AccessConstraints"), (Document)doc);
    }

    @Test
    public void testQueryable() throws Exception {
        LayerInfo lines = this.getCatalog().getLayerByName(MockData.LINES.getLocalPart());
        lines.setQueryable(true);
        this.getCatalog().save(lines);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        points.setQueryable(false);
        this.getCatalog().save(points);
        String linesName = MockData.LINES.getPrefix() + ":" + MockData.LINES.getLocalPart();
        String pointsName = MockData.POINTS.getPrefix() + ":" + MockData.POINTS.getLocalPart();
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("//Layer[Name='" + linesName + "']/@queryable"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("//Layer[Name='" + pointsName + "']/@queryable"), (Document)doc);
    }

    @Test
    public void testOpaque() throws Exception {
        LayerInfo lines = this.getCatalog().getLayerByName(MockData.LINES.getLocalPart());
        lines.setOpaque(true);
        this.getCatalog().save(lines);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        points.setOpaque(false);
        this.getCatalog().save(points);
        String linesName = MockData.LINES.getPrefix() + ":" + MockData.LINES.getLocalPart();
        String pointsName = MockData.POINTS.getPrefix() + ":" + MockData.POINTS.getLocalPart();
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("//Layer[Name='" + linesName + "']/@opaque"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("//Layer[Name='" + pointsName + "']/@opaque"), (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptions() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((boolean)xpath.evaluate("//Exception/Format[1]", doc).equals("application/vnd.ogc.se_xml"));
        Assert.assertTrue((boolean)xpath.evaluate("//Exception/Format[2]", doc).equals("application/vnd.ogc.se_inimage"));
        Assert.assertTrue((boolean)xpath.evaluate("//Exception/Format[3]", doc).equals("application/vnd.ogc.se_blank"));
        Assert.assertTrue((boolean)xpath.evaluate("//Exception/Format[4]", doc).equals("application/json"));
        Assert.assertTrue((xpath.getMatchingNodes("//Exception/Format", doc).getLength() >= 4 ? 1 : 0) != 0);
        boolean jsonpOriginal = JSONType.isJsonpEnabled();
        try {
            JSONType.setJsonpEnabled((boolean)true);
            doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
            Assert.assertTrue((boolean)xpath.evaluate("//Exception/Format[5]", doc).equals("text/javascript"));
            Assert.assertTrue((xpath.getMatchingNodes("//Exception/Format", doc).getLength() == 5 ? 1 : 0) != 0);
            JSONType.setJsonpEnabled((boolean)false);
            doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
            Assert.assertTrue((xpath.getMatchingNodes("//Exception/Format", doc).getLength() == 4 ? 1 : 0) != 0);
        }
        finally {
            JSONType.setJsonpEnabled((boolean)jsonpOriginal);
        }
    }

    @Test
    public void testDataLinks() throws Exception {
        String layerName = MockData.POINTS.getPrefix() + ":" + MockData.POINTS.getLocalPart();
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        DataLinkInfo mdlink = this.getCatalog().getFactory().createDataLink();
        mdlink.setContent("http://geoserver.org");
        mdlink.setType("text/xml");
        ResourceInfo resource = layer.getResource();
        resource.getDataLinks().add(mdlink);
        this.getCatalog().save(resource);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        String xpath = "//Layer[Name='" + layerName + "']/DataURL/Format";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml", (String)xpath, (Document)doc);
        xpath = "//Layer[Name='" + layerName + "']/DataURL/OnlineResource/@xlink:type";
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)xpath, (Document)doc);
        xpath = "//Layer[Name='" + layerName + "']/DataURL/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org", (String)xpath, (Document)doc);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        String proxyBaseUrl = global.getSettings().getProxyBaseUrl();
        mdlink.setContent("/metadata");
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata"), (String)xpath, (Document)doc);
        String query = "key=value";
        mdlink.setContent("/metadata?" + query);
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata?" + query), (String)xpath, (Document)doc);
        mdlink.setContent("http://localhost/metadata?" + query);
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)("http://localhost/metadata?" + query), (String)xpath, (Document)doc);
    }

    @Test
    public void testStyleWorkspaceQualified() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"cite:Lakes", (String)"//Layer[Name='cite:Lakes']/Style[1]/Name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"cite:tiger_roads", (String)"//Layer[Name='cite:Lakes']/Style[2]/Name", (Document)doc);
    }

    @Test
    public void testStyleElementsValidity() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathExists((String)"//Layer[Name='cite:Lakes']/Style[1]/Name", (Document)doc);
        XMLAssert.assertXpathExists((String)"//Layer[Name='cite:Lakes']/Style[1]/Title", (Document)doc);
        XMLAssert.assertXpathExists((String)"//Layer[Name='cite:Lakes']/Style[1]/LegendURL", (Document)doc);
        XMLAssert.assertXpathExists((String)"//Layer[Name='cite:Lakes']/Style[2]/Name", (Document)doc);
        XMLAssert.assertXpathExists((String)"//Layer[Name='cite:Lakes']/Style[2]/Title", (Document)doc);
        XMLAssert.assertXpathExists((String)"//Layer[Name='cite:Lakes']/Style[2]/LegendURL", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateLayerGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        lakes.setAdvertised(false);
        catalog.save(lakes);
        try {
            Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Title='containerGroup']/Layer[Name='nature'])", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='nature'])", (Document)doc);
        }
        finally {
            lakes.setAdvertised(true);
            catalog.save(lakes);
        }
    }

    @Test
    public void testOpaqueGroup() throws Exception {
        Document dom = this.dom(this.get("wms?request=GetCapabilities&version=1.1.0"), true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='opaqueGroup'])", (Document)dom);
        for (LayerInfo l : this.getCatalog().getLayerGroupByName("opaqueGroup").layers()) {
            XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + l.prefixedName() + "']"), (Document)dom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedGroupInOpaqueGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo container = catalog.getLayerGroupByName("containerGroup");
        LayerGroupInfo opaque = catalog.getLayerGroupByName("opaqueGroup");
        opaque.getLayers().add(container);
        opaque.getStyles().add(null);
        catalog.save(opaque);
        try {
            Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.1.0");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='opaqueGroup'])", (Document)dom);
            for (PublishedInfo p : this.getCatalog().getLayerGroupByName("opaqueGroup").getLayers()) {
                XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + p.prefixedName() + "']"), (Document)dom);
            }
            List nestedLayers = new LayerGroupHelper(container).allLayers();
            int expectedLayerCount = this.getRawTopLayerCount() - nestedLayers.size() - 1;
            XpathEngine xpath = XMLUnit.newXpathEngine();
            NodeList nodeLayers = xpath.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/Layer", dom);
            Assert.assertEquals((long)expectedLayerCount, (long)nodeLayers.getLength());
        }
        finally {
            opaque.getLayers().remove(container);
            opaque.getStyles().remove(opaque.getStyles().size() - 1);
            catalog.save(opaque);
        }
    }

    @Test
    public void testRootLayer() throws Exception {
        Document dom = this.findCapabilities(false);
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        DOMSource domSource = new DOMSource(dom);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        Assert.assertEquals((Object)writer.toString().contains(info.getRootLayerTitle()), (Object)true);
    }

    private Document findCapabilities(Boolean scaleHintUnitsPerDiaPixel) throws Exception {
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        info.setRootLayerTitle("test the title");
        MetadataMap mm = info.getMetadata();
        mm.put("scalehintMapunitsPixel", (Serializable)scaleHintUnitsPerDiaPixel);
        info.getGeoServer().save((ServiceInfo)info);
        Capabilities_1_3_0_Transformer tr = new Capabilities_1_3_0_Transformer(wms, BASE_URL, wms.getAllowedMapFormats(), new HashSet());
        GetCapabilitiesRequest req = new GetCapabilitiesRequest();
        req.setBaseUrl(BASE_URL);
        req.setVersion(WMS.VERSION_1_3_0.toString());
        Document dom = WMSTestSupport.transform(req, (TransformerBase)tr);
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)WMS.VERSION_1_3_0.toString(), (Object)root.getAttribute("version"));
        return dom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAdvertisedQueriableWithinGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        this.setAdvertised(catalog, MockData.LAKES, false);
        this.setAdvertised(catalog, MockData.NAMED_PLACES, false);
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.SINGLE, null);
            Document dom = this.dom(this.get("wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//Layer[Name='lakes_and_places']/@queryable", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
            this.setAdvertised(catalog, MockData.LAKES, true);
            this.setAdvertised(catalog, MockData.NAMED_PLACES, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAdvertisedNonQueriableWithinGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        this.setAdvertised(catalog, MockData.LAKES, false);
        this.setQueryable(catalog, MockData.LAKES, false);
        this.setAdvertised(catalog, MockData.NAMED_PLACES, false);
        this.setQueryable(catalog, MockData.NAMED_PLACES, false);
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.SINGLE, null);
            Document dom = this.dom(this.get("wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//Layer[Name='lakes_and_places']/@queryable", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
            this.setAdvertised(catalog, MockData.LAKES, true);
            this.setQueryable(catalog, MockData.LAKES, true);
            this.setAdvertised(catalog, MockData.NAMED_PLACES, true);
            this.setQueryable(catalog, MockData.NAMED_PLACES, true);
        }
    }

    private void setAdvertised(Catalog catalog, QName name, boolean advertised) {
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(name));
        lakes.setAdvertised(advertised);
        catalog.save(lakes);
    }

    private void setQueryable(Catalog catalog, QName name, boolean queryable) {
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(name));
        lakes.setQueryable(queryable);
        catalog.save(lakes);
    }
}

