/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.svg;

import java.net.HttpURLConnection;
import java.net.URL;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;

public class SVGTest
extends WMSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle("multifts", "./polyMultiFts.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testBasicSvgGenerator() throws Exception {
        this.getWMS().setSvgRenderer("Simple");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureid=BasicPolygons.1107531493643");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("svg").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("g").getLength());
    }

    @Test
    public void testBasicSvgGeneratorMultipleFts() throws Exception {
        this.getWMS().setSvgRenderer("Simple");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=multifts&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureid=BasicPolygons.1107531493643");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("svg").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("g").getLength());
    }

    @Test
    public void testBatikSvgGenerator() throws Exception {
        Assume.assumeTrue((boolean)this.isw3OrgReachable());
        this.getWMS().setSvgRenderer("Batik");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureid=BasicPolygons.1107531493643");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("svg").getLength());
        Assert.assertTrue((doc.getElementsByTagName("g").getLength() > 1 ? 1 : 0) != 0);
    }

    private boolean isw3OrgReachable() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("http://www.w3.org").openConnection();
            connection.setConnectTimeout(5000);
            connection.connect();
            connection.disconnect();
            return true;
        }
        catch (Exception e) {
            System.out.println("Unable to contact http://www.w3.org - " + e.getMessage());
            return false;
        }
    }

    @Test
    public void testBatikMultipleFts() throws Exception {
        Assume.assumeTrue((boolean)this.isw3OrgReachable());
        this.getWMS().setSvgRenderer("Batik");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=multifts&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureid=BasicPolygons.1107531493643");
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("svg").getLength());
        Assert.assertTrue((doc.getElementsByTagName("g").getLength() > 1 ? 1 : 0) != 0);
    }
}

