/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSPartialMapException;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.DelayedFeatureCollection;
import org.geoserver.wms.map.IdentityCoverageFunction;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.image.util.ImageUtilities;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.ChannelSelection;

public class RenderedImageMapOutputFormatTest
extends WMSTestSupport {
    public static QName TAZ_BYTE = new QName(MockData.WCS_URI, "tazbyte", MockData.WCS_PREFIX);
    private static final Logger LOGGER = Logging.getLogger((String)RenderedImageMapOutputFormatTest.class.getPackage().getName());
    private RenderedImageMapOutputFormat rasterMapProducer;
    private String mapFormat = "image/gif";
    private static final ThreadLocal<Boolean> usedCustomLabelCache = new ThreadLocal();

    @Before
    public void setRasterMapProducer() throws Exception {
        Logging.getLogger((String)"org.geotools.rendering").setLevel(Level.OFF);
        this.rasterMapProducer = this.getProducerInstance();
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.MULTIBAND, this.getCatalog());
    }

    protected RenderedImageMapOutputFormat getProducerInstance() {
        return new DummyRasterMapProducer(this.getWMS());
    }

    @After
    public void unsetRasterMapProducer() throws Exception {
        this.rasterMapProducer = null;
    }

    public String getMapFormat() {
        return this.mapFormat;
    }

    @Test
    public void testSimpleGetMapQuery() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("testSimpleGetMapQuery", image);
    }

    @Test
    public void testDirectVsNonDirectRasterRender() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(SystemTestData.MULTIBAND.getPrefix(), SystemTestData.MULTIBAND.getLocalPart());
        ReferencedEnvelope env = ci.boundingBox();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new Envelope(-116.90673461649858, -114.30988665660261, 32.070937282184026, 33.8903284734844), (CoordinateReferenceSystem)crs);
        request.setBbox((Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        StyleBuilder builder = new StyleBuilder();
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        CachedGridReaderLayer l = new CachedGridReaderLayer(reader, builder.createStyle((Symbolizer)builder.createRasterSymbolizer()));
        map.addLayer((Layer)l);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/direct-raster-expected.tif"), (RenderedImage)imageMap.getImage(), (int)0);
        imageMap.dispose();
    }

    @Test
    public void testTimeoutOption() throws Exception {
        Catalog catalog = this.getCatalog();
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        SimpleFeatureSource fs = (SimpleFeatureSource)catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        SimpleFeatureCollection features = fs.getFeatures();
        DelayedFeatureCollection delayedCollection = new DelayedFeatureCollection(features, 50L);
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)delayedCollection, basicStyle));
        LOGGER.info("about to create map ctx for " + map.layers().size() + " layers with bounds " + env);
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(1000);
        map.setMapHeight(1000);
        map.setRequest(request);
        request.setFormat(this.getMapFormat());
        HashMap<String, Integer> formatOptions = new HashMap<String, Integer>();
        formatOptions.put("timeout", 1);
        request.setFormatOptions(formatOptions);
        try {
            RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
            Assert.fail((String)"Timeout was not reached");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("This request used more time than allowed"));
        }
        HashMap<String, String> rawKvp = new HashMap<String, String>();
        rawKvp.put("EXCEPTIONS", "PARTIALMAP");
        request.setRawKvp(rawKvp);
        try {
            RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
            Assert.fail((String)"Timeout was not reached");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)(e instanceof WMSPartialMapException));
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("This request used more time than allowed"));
            RenderedImageMap partialMap = (RenderedImageMap)((WMSPartialMapException)e).getMap();
            Assert.assertNotNull((Object)partialMap);
            Assert.assertNotNull((Object)partialMap.getImage());
        }
    }

    @Test
    public void testDefaultStyle() throws Exception {
        List typeInfos = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo info : typeInfos) {
            if (!info.getQualifiedName().getNamespaceURI().equals(MockData.CITE_URI) || info.getFeatureType().getGeometryDescriptor() == null) continue;
            this.testDefaultStyle(info.getFeatureSource(null, null));
        }
    }

    @Test
    public void testBlueLake() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addToMap(map, MockData.FORESTS);
        this.addToMap(map, MockData.LAKES);
        this.addToMap(map, MockData.STREAMS);
        this.addToMap(map, MockData.NAMED_PLACES);
        this.addToMap(map, MockData.ROAD_SEGMENTS);
        this.addToMap(map, MockData.PONDS);
        this.addToMap(map, MockData.BUILDINGS);
        this.addToMap(map, MockData.DIVIDED_ROUTES);
        this.addToMap(map, MockData.BRIDGES);
        this.addToMap(map, MockData.MAP_NEATLINE);
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("testBlueLake", image);
    }

    @Test
    public void testCustomLabelCache() throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addToMap(map, MockData.FORESTS);
        this.addToMap(map, MockData.LAKES);
        this.addToMap(map, MockData.STREAMS);
        this.addToMap(map, MockData.NAMED_PLACES);
        this.addToMap(map, MockData.ROAD_SEGMENTS);
        this.addToMap(map, MockData.PONDS);
        this.addToMap(map, MockData.BUILDINGS);
        this.addToMap(map, MockData.DIVIDED_ROUTES);
        this.addToMap(map, MockData.BRIDGES);
        this.addToMap(map, MockData.MAP_NEATLINE);
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setFormat(this.getMapFormat());
        this.rasterMapProducer.setLabelCache((Function)new Function<WMSMapContent, LabelCache>(){

            @Override
            public LabelCache apply(WMSMapContent mapContent) {
                return new CustomLabelCache();
            }
        });
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        Assert.assertTrue((boolean)usedCustomLabelCache.get());
        this.assertNotBlank("testBlueLake", image);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
        testData.addRasterLayer(TAZ_BYTE, "tazbyte.tiff", null, this.getCatalog());
    }

    @Test
    public void testInterpolations() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo coverageInfo = catalog.getCoverageByName(MockData.TASMANIA_DEM.getNamespaceURI(), MockData.TASMANIA_DEM.getLocalPart());
        ReferencedEnvelope env = coverageInfo.boundingBox();
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setInterpolations(Arrays.asList(Interpolation.getInstance((int)0)));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)imageMap.getImage();
        BufferedImage imageNearest = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsNearest", imageNearest);
        request = new GetMapRequest();
        map = new WMSMapContent();
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setInterpolations(Arrays.asList(Interpolation.getInstance((int)2)));
        request.setFormat(this.getMapFormat());
        imageMap = this.rasterMapProducer.produceMap(map);
        op = (RenderedOp)imageMap.getImage();
        BufferedImage imageBicubic = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsBicubic", imageBicubic);
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 160, 160).getRGB(), (long)this.getPixelColor(imageBicubic, 160, 160).getRGB());
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 300, 450).getRGB(), (long)this.getPixelColor(imageBicubic, 300, 450).getRGB());
    }

    @Test
    public void testInterpolationFromLayerConfig() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo layerInfo = catalog.getLayerByName(MockData.TASMANIA_DEM.getLocalPart());
        MapLayerInfo mapLayer = new MapLayerInfo(layerInfo);
        Assert.assertNull((Object)layerInfo.getDefaultWMSInterpolationMethod());
        ReferencedEnvelope env = layerInfo.getResource().boundingBox();
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Nearest);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Nearest, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        WMSMapContent map = this.createWMSMap((Envelope)env);
        map.setRequest(request);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)imageMap.getImage();
        BufferedImage imageNearest = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsNearest", imageNearest);
        request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Bicubic);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Bicubic, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        map = this.createWMSMap((Envelope)env);
        map.setRequest(request);
        imageMap = this.rasterMapProducer.produceMap(map);
        op = (RenderedOp)imageMap.getImage();
        BufferedImage imageBicubic = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsBicubic", imageBicubic);
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 160, 160).getRGB(), (long)this.getPixelColor(imageBicubic, 160, 160).getRGB());
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 300, 450).getRGB(), (long)this.getPixelColor(imageBicubic, 300, 450).getRGB());
        request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer, mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Bicubic);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Bicubic, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        map = this.createWMSMap((Envelope)env);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        imageMap = this.rasterMapProducer.produceMap(map);
        this.checkByLayerInterpolation(imageMap, Interpolation.getInstance((int)2));
        request = new GetMapRequest();
        request.setInterpolations(Arrays.asList(Interpolation.getInstance((int)2)));
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer, mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Bilinear);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Bilinear, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertEquals((Object)WMSInfo.WMSInterpolation.Nearest, (Object)this.getWMS().getServiceInfo().getInterpolation());
        map = this.createWMSMap((Envelope)env);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        imageMap = this.rasterMapProducer.produceMap(map);
        this.checkByLayerInterpolation(imageMap, Interpolation.getInstance((int)2));
        request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(null);
        Assert.assertEquals(null, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        Assert.assertEquals((Object)WMSInfo.WMSInterpolation.Nearest, (Object)this.getWMS().getServiceInfo().getInterpolation());
        map = this.createWMSMap((Envelope)env);
        map.setRequest(request);
        imageMap = this.rasterMapProducer.produceMap(map);
        op = (RenderedOp)imageMap.getImage();
        BufferedImage imageServiceDefault = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationServiceDefault", imageServiceDefault);
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 200, 200).getRGB(), (long)this.getPixelColor(imageServiceDefault, 200, 200).getRGB());
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 300, 300).getRGB(), (long)this.getPixelColor(imageServiceDefault, 300, 300).getRGB());
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 250, 250).getRGB(), (long)this.getPixelColor(imageServiceDefault, 250, 250).getRGB());
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 150, 150).getRGB(), (long)this.getPixelColor(imageServiceDefault, 150, 150).getRGB());
    }

    private void checkByLayerInterpolation(RenderedImageMap imageMap, Interpolation expected) {
        Layer layer = (Layer)imageMap.getMapContext().layers().get(0);
        Interpolation actual = (Interpolation)layer.getUserData().get("byLayerInterpolation");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private WMSMapContent createWMSMap(Envelope bounds) throws Exception {
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(bounds.getHeight() * (double)w / bounds.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        map.getViewport().setBounds(new ReferencedEnvelope(bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        return map;
    }

    private void addRasterToMap(WMSMapContent map, QName typeName) throws IOException, FactoryRegistryException, TransformException, SchemaException {
        CoverageInfo coverageInfo = this.getCatalog().getCoverageByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        List layers = this.getCatalog().getLayers((ResourceInfo)coverageInfo);
        StyleInfo defaultStyle = ((LayerInfo)layers.get(0)).getDefaultStyle();
        Style style = defaultStyle.getStyle();
        SimpleFeatureCollection fc = FeatureUtilities.wrapGridCoverageReader((GridCoverage2DReader)((GridCoverage2DReader)coverageInfo.getGridCoverageReader(null, null)), (GeneralParameterValue[])new GeneralParameterValue[0]);
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)fc, style));
    }

    private void addToMap(WMSMapContent map, QName typeName) throws IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        List layers = this.getCatalog().getLayers((ResourceInfo)ftInfo);
        StyleInfo defaultStyle = ((LayerInfo)layers.get(0)).getDefaultStyle();
        Style style = defaultStyle.getStyle();
        map.addLayer((Layer)new FeatureLayer(ftInfo.getFeatureSource(null, null), style));
    }

    private void testDefaultStyle(FeatureSource fSource) throws Exception {
        Catalog catalog = this.getCatalog();
        Style style = catalog.getStyleByName("Default").getStyle();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        env.expandToInclude((Envelope)fSource.getBounds());
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        WMSMapContent map = new WMSMapContent();
        GetMapRequest request = new GetMapRequest();
        map.setRequest(request);
        map.addLayer((Layer)new FeatureLayer(fSource, style));
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(false);
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage image = imageMap.getImage();
        imageMap.dispose();
        Assert.assertNotNull((Object)image);
        String typeName = fSource.getSchema().getName().getLocalPart();
        this.assertNotBlank("testDefaultStyle " + typeName, (BufferedImage)image);
    }

    @Test
    public void testRenderingErrorsHandling() throws Exception {
        Assert.assertNotNull((Object)this.forceRenderingError((Exception)((Object)new TransformException("fake transform exception"))));
        Assert.assertNotNull((Object)this.forceRenderingError(new NoninvertibleTransformException("fake non invertible exception")));
        Assert.assertNotNull((Object)this.forceRenderingError((Exception)new IllegalAttributeException("non illegal attribute exception")));
        Assert.assertNotNull((Object)this.forceRenderingError((Exception)((Object)new FactoryException("fake factory exception"))));
        try {
            this.forceRenderingError(new RuntimeException("fake runtime exception"));
            Assert.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IOException("fake IO exception"));
            Assert.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IllegalArgumentException("fake IAE exception"));
            Assert.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testStyleUsingChannelsFromCoverageView() throws Exception {
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new Envelope(-116.90673461649858, -114.30988665660261, 32.070937282184026, 33.8903284734844), (CoordinateReferenceSystem)crs);
        request.setBbox((Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        StyleBuilder styleBuilder = new StyleBuilder();
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(SystemTestData.MULTIBAND.getPrefix(), SystemTestData.MULTIBAND.getLocalPart());
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        CachedGridReaderLayer sl = new CachedGridReaderLayer(reader, styleBuilder.createStyle((Symbolizer)styleBuilder.createRasterSymbolizer()));
        map.addLayer((Layer)sl);
        RenderedImageMap srcImageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage srcImage = srcImageMap.getImage();
        CoverageView.InputCoverageBand ib0 = new CoverageView.InputCoverageBand("multiband", "2");
        CoverageView.CoverageBand b0 = new CoverageView.CoverageBand(Collections.singletonList(ib0), "multiband@2", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib1 = new CoverageView.InputCoverageBand("multiband", "1");
        CoverageView.CoverageBand b1 = new CoverageView.CoverageBand(Collections.singletonList(ib1), "multiband@1", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib2 = new CoverageView.InputCoverageBand("multiband", "0");
        CoverageView.CoverageBand b2 = new CoverageView.CoverageBand(Collections.singletonList(ib2), "multiband@0", 2, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib3 = new CoverageView.InputCoverageBand("multiband", "0");
        CoverageView.CoverageBand b3 = new CoverageView.CoverageBand(Collections.singletonList(ib3), "multiband@0", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib4 = new CoverageView.InputCoverageBand("multiband", "1");
        CoverageView.CoverageBand b4 = new CoverageView.CoverageBand(Collections.singletonList(ib4), "multiband@1", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib5 = new CoverageView.InputCoverageBand("multiband", "2");
        CoverageView.CoverageBand b5 = new CoverageView.CoverageBand(Collections.singletonList(ib5), "multiband@2", 2, CoverageView.CompositionType.BAND_SELECT);
        ArrayList<CoverageView.CoverageBand> coverageBands = new ArrayList<CoverageView.CoverageBand>(1);
        coverageBands.add(b0);
        coverageBands.add(b1);
        coverageBands.add(b2);
        coverageBands.add(b3);
        coverageBands.add(b4);
        coverageBands.add(b5);
        CoverageView multiBandCoverageView = new CoverageView("multiband_select", coverageBands);
        CoverageStoreInfo storeInfo = catalog.getCoverageStoreByName("multiband");
        CatalogBuilder builder = new CatalogBuilder(catalog);
        CoverageInfo coverageInfo = multiBandCoverageView.createCoverageInfo("multiband_select", storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        catalog.add((ResourceInfo)coverageInfo);
        LayerInfo layerInfoView = builder.buildLayer(coverageInfo);
        catalog.add(layerInfoView);
        ReferencedEnvelope env = ci.boundingBox();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        RasterSymbolizer symbolizer = styleBuilder.createRasterSymbolizer();
        ChannelSelectionImpl cs = new ChannelSelectionImpl();
        SelectedChannelTypeImpl red = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl green = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl blue = new SelectedChannelTypeImpl();
        red.setChannelName("3");
        green.setChannelName("2");
        blue.setChannelName("1");
        cs.setRGBChannels(new SelectedChannelType[]{red, green, blue});
        symbolizer.setChannelSelection((ChannelSelection)cs);
        reader = (GridCoverage2DReader)coverageInfo.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        CachedGridReaderLayer dl = new CachedGridReaderLayer(reader, styleBuilder.createStyle((Symbolizer)symbolizer));
        map.removeLayer((Layer)sl);
        map.addLayer((Layer)dl);
        RenderedImageMap dstImageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage destImage = dstImageMap.getImage();
        int dWidth = destImage.getWidth();
        int dHeight = destImage.getHeight();
        int[] destImageRowBand0 = new int[dWidth * dHeight];
        int[] destImageRowBand1 = new int[destImageRowBand0.length];
        int[] destImageRowBand2 = new int[destImageRowBand0.length];
        destImage.getData().getSamples(0, 0, dWidth, dHeight, 0, destImageRowBand0);
        destImage.getData().getSamples(0, 0, dWidth, dHeight, 1, destImageRowBand1);
        destImage.getData().getSamples(0, 0, dWidth, dHeight, 2, destImageRowBand2);
        int sWidth = srcImage.getWidth();
        int sHeight = srcImage.getHeight();
        int[] srcImageRowBand0 = new int[sWidth * sHeight];
        int[] srcImageRowBand2 = new int[srcImageRowBand0.length];
        srcImage.getData().getSamples(0, 0, sWidth, sHeight, 0, srcImageRowBand0);
        Assert.assertTrue((boolean)Arrays.equals(destImageRowBand0, srcImageRowBand0));
        Assert.assertFalse((boolean)Arrays.equals(destImageRowBand0, srcImageRowBand2));
        srcImageMap.dispose();
        dstImageMap.dispose();
        map.dispose();
    }

    @Test
    public void testBandSelectionToNormalCoverage() throws Exception {
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new Envelope(-116.90673461649858, -114.30988665660261, 32.070937282184026, 33.8903284734844), (CoordinateReferenceSystem)crs);
        request.setBbox((Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        StyleBuilder styleBuilder = new StyleBuilder();
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(SystemTestData.MULTIBAND.getPrefix(), SystemTestData.MULTIBAND.getLocalPart());
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        ReferencedEnvelope env = ci.boundingBox();
        int[] bandIndices = new int[]{1, 2, 0, 2, 1};
        Parameter bandIndicesParam = (Parameter)AbstractGridFormat.BANDS.createValue();
        bandIndicesParam.setValue((Object)bandIndices);
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        paramList.add(bandIndicesParam);
        GeneralParameterValue[] readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
        CachedGridReaderLayer sl = new CachedGridReaderLayer(reader, styleBuilder.createStyle((Symbolizer)styleBuilder.createRasterSymbolizer()), readParams);
        map.addLayer((Layer)sl);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/direct-raster-expected.tif"), (RenderedImage)imageMap.getImage(), (int)0);
        imageMap.dispose();
    }

    @Test
    public void testGetMapOnByteNodataGrayScale() throws Exception {
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new Envelope(145.0, 146.0, -43.0, -41.0), (CoordinateReferenceSystem)crs);
        request.setBbox((Envelope)bbox);
        request.setHeight(768);
        request.setWidth(384);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        request.setTransparent(true);
        WMSMapContent map = new WMSMapContent(request);
        map.setMapHeight(768);
        map.setMapWidth(384);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.getViewport().setBounds(bbox);
        this.addRasterToMap(map, TAZ_BYTE);
        map.getViewport().setBounds(bbox);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)imageMap.getImage();
        BufferedImage image = op.getAsBufferedImage();
        imageMap.dispose();
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(40, 400, 0));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(40, 400, 1));
    }

    private RenderedImage forceRenderingError(final Exception renderExceptionToThrow) throws Exception {
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.setMapWidth(100);
        map.setMapHeight(100);
        map.setRequest(request);
        ReferencedEnvelope bounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.getViewport().setBounds(bounds);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(CiteTestData.STREAMS.getNamespaceURI(), CiteTestData.STREAMS.getLocalPart());
        SimpleFeatureSource featureSource = (SimpleFeatureSource)ftInfo.getFeatureSource(null, null);
        DecoratingFeatureSource source = new DecoratingFeatureSource((FeatureSource)featureSource){

            public SimpleFeatureCollection getFeatures(Query query) throws IOException {
                throw new RuntimeException(renderExceptionToThrow);
            }
        };
        StyleInfo someStyle = this.getCatalog().getStyleByName("line");
        map.addLayer((Layer)new FeatureLayer((FeatureSource)source, someStyle.getStyle()));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMosaicExpansion() throws Exception {
        File red1 = URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("red_footprint_test/red1.tif"));
        File source = red1.getParentFile();
        File testDataDir = this.getResourceLoader().getBaseDirectory();
        File directory1 = new File(testDataDir, "redHarvest1");
        File directory2 = new File(testDataDir, "redHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("red[^3].*"), null)) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory2, file.getName())));
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        ImageMosaicReader reader = new ImageMosaicReader((Object)directory1, null);
        ImageMosaicReader reader2 = new ImageMosaicReader((Object)directory1, null);
        try {
            for (File file : directory2.listFiles()) {
                Assert.assertTrue((boolean)file.renameTo(new File(directory1, file.getName())));
            }
            reader.harvest(null, (Object)directory1, null);
            ReferencedEnvelope renderEnvelope = new ReferencedEnvelope(991000.0, 992000.0, 216000.0, 217000.0, reader2.getCoordinateReferenceSystem());
            Rectangle rasterArea = new Rectangle(0, 0, 10, 10);
            GetMapRequest request = new GetMapRequest();
            request.setBbox((Envelope)renderEnvelope);
            request.setSRS("EPSG:6539");
            request.setFormat("image/png");
            WMSMapContent map = new WMSMapContent(request);
            map.setMapWidth(10);
            map.setMapHeight(10);
            map.setBgColor(Color.BLACK);
            map.setTransparent(false);
            map.getViewport().setBounds(renderEnvelope);
            StyleBuilder builder = new StyleBuilder();
            Style style = builder.createStyle((Symbolizer)builder.createRasterSymbolizer());
            CachedGridReaderLayer l = new CachedGridReaderLayer((GridCoverage2DReader)reader2, style);
            map.addLayer((Layer)l);
            RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
            File reference = new File("src/test/resources/org/geoserver/wms/map/red10.png");
            ImageAssert.assertEquals((File)reference, (RenderedImage)imageMap.getImage(), (int)0);
            ((FeatureTypeStyle)style.featureTypeStyles().get(0)).setTransformation((Expression)new IdentityCoverageFunction());
            RenderedImageMap imageMap2 = this.rasterMapProducer.produceMap(map);
            ImageAssert.assertEquals((File)reference, (RenderedImage)imageMap2.getImage(), (int)0);
            imageMap.dispose();
        }
        finally {
            reader.dispose();
            reader2.dispose();
        }
    }

    @Test
    public void testGetMapUntiledBigSize() throws Exception {
        int mapWidth = 8192;
        int mapHeight = 8192;
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new Envelope(145.0, 146.0, -43.0, -41.0), (CoordinateReferenceSystem)crs);
        request.setBbox((Envelope)bbox);
        request.setHeight(8192);
        request.setWidth(8192);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        request.setTransparent(true);
        WMSMapContent map = new WMSMapContent(request);
        map.setMapHeight(8192);
        map.setMapWidth(8192);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.getViewport().setBounds(bbox);
        this.addRasterToMap(map, TAZ_BYTE);
        map.getViewport().setBounds(bbox);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)imageMap.getImage();
        Point[] tileIndices = op.getTileIndices(new Rectangle(0, 0, 8192, 8192));
        Assert.assertTrue((tileIndices.length > 1 ? 1 : 0) != 0);
        Raster tile = op.getTile(0, 0);
        Assert.assertNotNull((Object)tile);
        Assert.assertTrue((tile.getWidth() < 8192 ? 1 : 0) != 0);
        Assert.assertTrue((tile.getHeight() < 8192 ? 1 : 0) != 0);
        ImageUtilities.disposePlanarImageChain((PlanarImage)op);
        imageMap.dispose();
    }

    static class DummyRasterMapProducer
    extends RenderedImageMapOutputFormat {
        public DummyRasterMapProducer(WMS wms) {
            super("image/gif", new String[]{"image/gif"}, wms);
        }
    }

    public static class CustomLabelCache
    implements LabelCache {
        public void clear() {
        }

        public void clear(String arg0) {
        }

        public void disableLayer(String arg0) {
        }

        public void enableLayer(String arg0) {
        }

        public void end(Graphics2D arg0, Rectangle arg1) {
            usedCustomLabelCache.set(true);
        }

        public void endLayer(String arg0, Graphics2D arg1, Rectangle arg2) {
        }

        public List orderedLabels() {
            return null;
        }

        public void put(Rectangle2D arg0) {
        }

        public void put(String arg0, TextSymbolizer arg1, Feature arg2, LiteShape2 arg3, NumberRange<Double> arg4) {
        }

        public void start() {
        }

        public void startLayer(String arg0) {
        }

        public void stop() {
        }
    }
}

