/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Point;
import java.awt.geom.Point2D;
import org.geoserver.wms.map.QuickTileCache;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class QuickTileCacheTest {
    QuickTileCache cache = new QuickTileCache();

    @Test
    public void testMetaCoordinates() {
        Point orig = new Point(0, 0);
        Assert.assertEquals((Object)orig, (Object)this.cache.getMetaTileCoordinates(orig));
        Point t10 = new Point(1, 0);
        Assert.assertEquals((Object)orig, (Object)this.cache.getMetaTileCoordinates(t10));
        Point t01 = new Point(1, 0);
        Assert.assertEquals((Object)orig, (Object)this.cache.getMetaTileCoordinates(t01));
        Point t33 = new Point(3, 3);
        Assert.assertEquals((Object)new Point(3, 3), (Object)this.cache.getMetaTileCoordinates(t33));
        Point tm1m1 = new Point(-1, -1);
        Assert.assertEquals((Object)new Point(-3, -3), (Object)this.cache.getMetaTileCoordinates(tm1m1));
        Point tm3m3 = new Point(-3, -3);
        Assert.assertEquals((Object)new Point(-3, -3), (Object)this.cache.getMetaTileCoordinates(tm3m3));
        Point tm4m4 = new Point(-4, -4);
        Assert.assertEquals((Object)new Point(-6, -6), (Object)this.cache.getMetaTileCoordinates(tm4m4));
        Point t4m4 = new Point(4, -4);
        Assert.assertEquals((Object)new Point(3, -6), (Object)this.cache.getMetaTileCoordinates(t4m4));
        Point tm44 = new Point(-4, 4);
        Assert.assertEquals((Object)new Point(-6, 3), (Object)this.cache.getMetaTileCoordinates(tm44));
    }

    @Test
    public void testTileCoordinatesNaturalOrigin() {
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Envelope env = new Envelope(30.0, 60.0, 30.0, 60.0);
        Point tc = this.cache.getTileCoordinates(env, (Point2D)origin);
        Assert.assertEquals((Object)new Point(1, 1), (Object)tc);
        env = new Envelope(-30.0, 0.0, -30.0, 0.0);
        tc = this.cache.getTileCoordinates(env, (Point2D)origin);
        Assert.assertEquals((Object)new Point(-1, -1), (Object)tc);
    }

    @Test
    public void testInnerTileOffsets() {
        Envelope meta = new Envelope(1215736.8585492, 1215744.0245205, 5455471.361398601, 5455478.5273699);
        Envelope box1 = new Envelope(1215736.8585492, 1215739.2472063, 5455476.1387128, 5455478.5273699);
        Envelope box2 = new Envelope(1215739.2472063, 1215741.6358635, 5455476.1387128, 5455478.5273699);
        Assert.assertEquals((Object)new Point(0, 2), (Object)this.cache.getTileOffsetsInMeta(box1, meta));
        Assert.assertEquals((Object)new Point(1, 2), (Object)this.cache.getTileOffsetsInMeta(box2, meta));
    }
}

