/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.QuickTileCache;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MetaTileOutputFormatTest {
    QuickTileCache.MapKey mapKey = new QuickTileCache.MapKey("abcd", 0.01, (Point2D)new Point2D.Double(0.0, 0.0));
    QuickTileCache.MetaTileKey key = new QuickTileCache.MetaTileKey(this.mapKey, new Point(0, 0), new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D));
    RasterCleaner cleaner = new RasterCleaner();

    @After
    public void cleanup() {
        this.cleaner.finished(null);
    }

    @Test
    public void testReleaseOnBufferedImage() throws Exception {
        BufferedImage bi = new BufferedImage(768, 768, 6);
        MetatileMapOutputFormat.split((QuickTileCache.MetaTileKey)this.key, (RenderedImage)bi);
        Assert.assertEquals((long)1L, (long)this.cleaner.getImages().size());
    }

    @Test
    public void testReleaseOnPlanarImage() throws Exception {
        BufferedImage bi = new BufferedImage(256, 256, 6);
        RenderedImage planar = new ImageWorker((RenderedImage)bi).scale(3.0, 3.0, 0.0, 0.0, Interpolation.getInstance((int)0)).getRenderedImage();
        MetatileMapOutputFormat.split((QuickTileCache.MetaTileKey)this.key, (RenderedImage)planar);
        Assert.assertEquals((long)1L, (long)this.cleaner.getImages().size());
    }

    @Test
    public void testPlanarImageTranslatedChild() throws Exception {
        ComponentSampleModel sm = new ComponentSampleModel(0, 128, 128, 1, 128, new int[]{0});
        TiledImage source = new TiledImage(0, 0, 512, 512, 0, 0, (SampleModel)sm, PlanarImage.createColorModel((SampleModel)sm));
        Raster[] tiles = source.getTiles();
        Assert.assertEquals((long)16L, (long)tiles.length);
        MetatileMapOutputFormat.split((QuickTileCache.MetaTileKey)this.key, (RenderedImage)source);
    }
}

