/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.Cell;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.RasterLayerLegendHelper;
import org.geotools.styling.ColorMap;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RasterLegendBuilderTest {
    GetLegendGraphicRequest request;

    @Before
    public void setup() {
        this.request = new GetLegendGraphicRequest();
    }

    @Test
    public void testRuleTextRampOneElements() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null}, new double[]{10.0}, new Color[]{Color.RED}, 1);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)1L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)"", (Object)firstRow.getRuleManager().text);
    }

    @Test
    public void testRuleTextRampTwoElements() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null, null}, new double[]{10.0, 100.0}, new Color[]{Color.RED, Color.BLUE}, 1);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)2L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)"10.0 >= x", (Object)firstRow.getRuleManager().text);
        Cell.ColorMapEntryLegendBuilder lastRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)"100.0 <= x", (Object)lastRow.getRuleManager().text);
    }

    @Test
    public void testRuleTextRampThreeElements() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null, null, null}, new double[]{10.0, 50.0, 100.0}, new Color[]{Color.RED, Color.WHITE, Color.BLUE}, 1);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)3L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)"10.0 >= x", (Object)firstRow.getRuleManager().text);
        Cell.ColorMapEntryLegendBuilder midRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)"50.0 = x", (Object)midRow.getRuleManager().text);
        Cell.ColorMapEntryLegendBuilder lastRow = (Cell.ColorMapEntryLegendBuilder)rows.get(2);
        Assert.assertEquals((Object)"100.0 <= x", (Object)lastRow.getRuleManager().text);
    }

    @Test
    public void testRuleTextIntervalOneElements() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null}, new double[]{10.0}, new Color[]{Color.RED}, 2);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)1L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)"x < 10.0", (Object)firstRow.getRuleManager().text);
    }

    @Test
    public void testRuleTextIntervalsTwoElements() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null, null}, new double[]{10.0, 100.0}, new Color[]{Color.RED, Color.BLUE}, 2);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)2L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)"x < 10.0", (Object)firstRow.getRuleManager().text);
        Cell.ColorMapEntryLegendBuilder lastRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)"10.0 <= x < 100.0", (Object)lastRow.getRuleManager().text);
    }

    @Test
    public void testRuleTextIntervalsThreeElements() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null, null, null}, new double[]{10.0, 50.0, 100.0}, new Color[]{Color.RED, Color.WHITE, Color.BLUE}, 2);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)3L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)"x < 10.0", (Object)firstRow.getRuleManager().text);
        Cell.ColorMapEntryLegendBuilder midRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)"10.0 <= x < 50.0", (Object)midRow.getRuleManager().text);
        Cell.ColorMapEntryLegendBuilder lastRow = (Cell.ColorMapEntryLegendBuilder)rows.get(2);
        Assert.assertEquals((Object)"50.0 <= x < 100.0", (Object)lastRow.getRuleManager().text);
    }

    @Test
    public void testInfiniteOnIntervals() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null, null, null}, new double[]{Double.NEGATIVE_INFINITY, 50.0, Double.POSITIVE_INFINITY}, new Color[]{Color.RED, Color.WHITE, Color.BLUE}, 2);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)2L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)"x < 50.0", (Object)firstRow.getRuleManager().text);
        Cell.ColorMapEntryLegendBuilder midRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)"50.0 <= x", (Object)midRow.getRuleManager().text);
    }

    @Test
    public void testLegendBorderColour() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cmap = sb.createColorMap(new String[]{null, null, null}, new double[]{Double.NEGATIVE_INFINITY, 50.0, Double.POSITIVE_INFINITY}, new Color[]{Color.RED, Color.WHITE, Color.BLUE}, 2);
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer(cmap, 1.0));
        Color colourToTest = LegendUtils.DEFAULT_BORDER_COLOR;
        RasterLayerLegendHelper helper = new RasterLayerLegendHelper(this.request, style, null);
        ArrayList rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)2L, (long)rows.size());
        Cell.ColorMapEntryLegendBuilder firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)colourToTest, (Object)firstRow.getColorManager().borderColor);
        Assert.assertEquals((Object)colourToTest, (Object)firstRow.getRuleManager().borderColor);
        Cell.ColorMapEntryLegendBuilder midRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)colourToTest, (Object)midRow.getColorManager().borderColor);
        Assert.assertEquals((Object)colourToTest, (Object)midRow.getRuleManager().borderColor);
        HashMap<String, String> legendOptions = new HashMap<String, String>();
        colourToTest = Color.red;
        legendOptions.put("BORDERCOLOR", SLD.toHTMLColor((Color)colourToTest));
        this.request.setLegendOptions(legendOptions);
        helper = new RasterLayerLegendHelper(this.request, style, null);
        rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)2L, (long)rows.size());
        firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)colourToTest, (Object)firstRow.getColorManager().borderColor);
        Assert.assertEquals((Object)colourToTest, (Object)firstRow.getRuleManager().borderColor);
        midRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)colourToTest, (Object)midRow.getColorManager().borderColor);
        Assert.assertEquals((Object)colourToTest, (Object)midRow.getRuleManager().borderColor);
        colourToTest = Color.blue;
        legendOptions.clear();
        legendOptions.put("borderColor", SLD.toHTMLColor((Color)colourToTest));
        this.request.setLegendOptions(legendOptions);
        helper = new RasterLayerLegendHelper(this.request, style, null);
        rows = new ArrayList(helper.getcMapLegendCreator().getBodyRows());
        Assert.assertEquals((long)2L, (long)rows.size());
        firstRow = (Cell.ColorMapEntryLegendBuilder)rows.get(0);
        Assert.assertEquals((Object)colourToTest, (Object)firstRow.getColorManager().borderColor);
        Assert.assertEquals((Object)colourToTest, (Object)firstRow.getRuleManager().borderColor);
        midRow = (Cell.ColorMapEntryLegendBuilder)rows.get(1);
        Assert.assertEquals((Object)colourToTest, (Object)midRow.getColorManager().borderColor);
        Assert.assertEquals((Object)colourToTest, (Object)midRow.getRuleManager().borderColor);
    }
}

