/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.jai.PlanarImage;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.GetLegendGraphic;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.BaseLegendTest;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.image.util.ImageUtilities;
import org.geotools.styling.Style;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverage;

public class LegendLayoutTest
extends BaseLegendTest {
    @Before
    public void setLegendProducer() throws Exception {
        this.legendProducer = new BufferedImageLegendGraphicBuilder();
        this.service = new GetLegendGraphic(this.getWMS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRampHorizontalRaster() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall_ramp").getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(multipleRulesStyle);
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            HashMap<String, String> legendOptions = new HashMap<String, String>();
            req.setLegendOptions(legendOptions);
            this.legendProducer.buildLegendGraphic(req);
            BufferedImage vImage = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
            legendOptions = new HashMap();
            legendOptions.put("layout", "horizontal");
            req.setLegendOptions(legendOptions);
            BufferedImage hImage = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
            Assert.assertEquals((long)vImage.getHeight(), (long)hImage.getWidth());
            Assert.assertEquals((long)vImage.getWidth(), (long)hImage.getHeight());
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassesHorizontalRaster() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall_classes_nolabels").getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(multipleRulesStyle);
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            HashMap<String, String> legendOptions = new HashMap<String, String>();
            legendOptions.put("layout", "horizontal");
            legendOptions.put("mx", "0");
            legendOptions.put("my", "0");
            legendOptions.put("dx", "0");
            legendOptions.put("dy", "0");
            legendOptions.put("forceRule", "false");
            req.setLegendOptions(legendOptions);
            BufferedImage image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
            Assert.assertEquals((long)30L, (long)image.getHeight());
            this.assertPixel(image, 9, 15, new Color(115, 38, 0));
            this.assertPixel(image, 230, 15, new Color(38, 115, 0));
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassesRasterColumnsLimits() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall_classes_nolabels").getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(multipleRulesStyle);
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            HashMap<String, String> legendOptions = new HashMap<String, String>();
            legendOptions.put("layout", "vertical");
            legendOptions.put("columnheight", "85");
            legendOptions.put("columns", "1");
            legendOptions.put("mx", "0");
            legendOptions.put("my", "0");
            legendOptions.put("dx", "0");
            legendOptions.put("dy", "0");
            legendOptions.put("forceRule", "false");
            req.setLegendOptions(legendOptions);
            BufferedImage image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
            Assert.assertEquals((long)90L, (long)image.getHeight());
            this.assertPixel(image, 9, 13, new Color(115, 38, 0));
            this.assertPixel(image, 9, 43, new Color(168, 0, 0));
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassesRasterRowsLimits() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall_classes_nolabels").getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(multipleRulesStyle);
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            HashMap<String, String> legendOptions = new HashMap<String, String>();
            legendOptions.put("layout", "horizontal");
            legendOptions.put("rowwidth", "100");
            legendOptions.put("rows", "2");
            legendOptions.put("mx", "0");
            legendOptions.put("my", "0");
            legendOptions.put("dx", "0");
            legendOptions.put("dy", "0");
            legendOptions.put("forceRule", "false");
            req.setLegendOptions(legendOptions);
            BufferedImage image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
            Assert.assertEquals((long)60L, (long)image.getHeight());
            this.assertPixel(image, 9, 13, new Color(115, 38, 0));
            this.assertPixel(image, 110, 43, new Color(38, 115, 0));
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    @Test
    public void testVectorLayersHorizontal() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle());
        int HEIGHT_HINT = 20;
        req.setHeight(20);
        HashMap<String, String> legendOptions = new HashMap<String, String>();
        legendOptions.put("layout", "horizontal");
        legendOptions.put("forceLabels", "off");
        req.setLegendOptions(legendOptions);
        this.legendProducer.buildLegendGraphic(req);
        BufferedImage image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)20L, (long)image.getHeight());
        this.assertPixel(image, 10, 10, new Color(192, 160, 0));
        this.assertPixel(image, 50, 10, new Color(224, 64, 0));
    }

    @Test
    public void testLayerGroupTitles() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo lakesFt = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureTypeInfo placesFt = this.getCatalog().getFeatureTypeByName(MockData.NAMED_PLACES.getNamespaceURI(), MockData.NAMED_PLACES.getLocalPart());
        FeatureTypeInfo roadsFt = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        StyleInfo lakesStyle = this.getCatalog().getStyleByName(MockData.LAKES.getLocalPart());
        StyleInfo placesStyle = this.getCatalog().getStyleByName(MockData.NAMED_PLACES.getLocalPart());
        StyleInfo roadsStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayers(Arrays.asList(lakesFt.getFeatureType(), placesFt.getFeatureType(), roadsFt.getFeatureType()));
        req.setStyles(Arrays.asList(lakesStyle.getStyle(), placesStyle.getStyle(), roadsStyle.getStyle()));
        int HEIGHT_HINT = 20;
        req.setHeight(20);
        HashMap<String, String> legendOptions = new HashMap<String, String>();
        legendOptions.put("forceTitles", "on");
        legendOptions.put("fontName", "Bitstream Vera Sans");
        req.setLegendOptions(legendOptions);
        BufferedImage image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertTrue((String)("Expected height >= 162 but was " + image.getHeight()), (162 <= image.getHeight() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected height <= 168 but was " + image.getHeight()), (168 >= image.getHeight() ? 1 : 0) != 0);
        this.assertPixel(image, 10, 24, new Color(64, 64, 192));
        this.assertPixel(image, 10, 58, new Color(170, 170, 170));
        this.assertPixel(image, 10, 112, new Color(192, 160, 0));
        legendOptions.put("forceTitles", "off");
        req.setLegendOptions(legendOptions);
        image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)120L, (long)image.getHeight());
        this.assertPixel(image, 10, 10, new Color(64, 64, 192));
        this.assertPixel(image, 10, 30, new Color(170, 170, 170));
        this.assertPixel(image, 10, 70, new Color(192, 160, 0));
    }

    @Test
    public void testLayerGroupLabels() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo lakesFt = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureTypeInfo placesFt = this.getCatalog().getFeatureTypeByName(MockData.NAMED_PLACES.getNamespaceURI(), MockData.NAMED_PLACES.getLocalPart());
        FeatureTypeInfo roadsFt = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        StyleInfo lakesStyle = this.getCatalog().getStyleByName(MockData.LAKES.getLocalPart());
        StyleInfo placesStyle = this.getCatalog().getStyleByName(MockData.NAMED_PLACES.getLocalPart());
        StyleInfo roadsStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayers(Arrays.asList(lakesFt.getFeatureType(), placesFt.getFeatureType(), roadsFt.getFeatureType()));
        req.setStyles(Arrays.asList(lakesStyle.getStyle(), placesStyle.getStyle(), roadsStyle.getStyle()));
        int HEIGHT_HINT = 20;
        req.setHeight(20);
        HashMap<String, String> legendOptions = new HashMap<String, String>();
        legendOptions.put("forceTitles", "off");
        legendOptions.put("forceLabels", "on");
        req.setLegendOptions(legendOptions);
        BufferedImage image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)120L, (long)image.getHeight());
        Assert.assertTrue((String)("Expected witdh > 40 but was " + image.getWidth()), (40 < image.getWidth() ? 1 : 0) != 0);
        this.assertPixel(image, 10, 10, new Color(64, 64, 192));
        this.assertPixel(image, 10, 30, new Color(170, 170, 170));
        this.assertPixel(image, 10, 70, new Color(192, 160, 0));
        legendOptions.put("forceTitles", "off");
        legendOptions.put("forceLabels", "off");
        req.setLegendOptions(legendOptions);
        image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)120L, (long)image.getHeight());
        Assert.assertEquals((long)24L, (long)image.getWidth());
        this.assertPixel(image, 10, 10, new Color(64, 64, 192));
        this.assertPixel(image, 10, 30, new Color(170, 170, 170));
        this.assertPixel(image, 10, 70, new Color(192, 160, 0));
    }

    @Test
    public void testLayerGroupLayout() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo lakesFt = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureTypeInfo placesFt = this.getCatalog().getFeatureTypeByName(MockData.NAMED_PLACES.getNamespaceURI(), MockData.NAMED_PLACES.getLocalPart());
        FeatureTypeInfo roadsFt = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        StyleInfo lakesStyle = this.getCatalog().getStyleByName(MockData.LAKES.getLocalPart());
        StyleInfo placesStyle = this.getCatalog().getStyleByName(MockData.NAMED_PLACES.getLocalPart());
        StyleInfo roadsStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayers(Arrays.asList(lakesFt.getFeatureType(), placesFt.getFeatureType(), roadsFt.getFeatureType()));
        req.setStyles(Arrays.asList(lakesStyle.getStyle(), placesStyle.getStyle(), roadsStyle.getStyle()));
        int HEIGHT_HINT = 20;
        req.setHeight(20);
        HashMap<String, String> legendOptions = new HashMap<String, String>();
        legendOptions.put("forceTitles", "off");
        legendOptions.put("forceLabels", "off");
        legendOptions.put("layout", "VERTICAL");
        legendOptions.put("grouplayout", "VERTICAL");
        req.setLegendOptions(legendOptions);
        BufferedImage image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)120L, (long)image.getHeight());
        Assert.assertEquals((long)24L, (long)image.getWidth());
        this.assertPixel(image, 10, 10, new Color(64, 64, 192));
        this.assertPixel(image, 10, 30, new Color(170, 170, 170));
        this.assertPixel(image, 10, 70, new Color(192, 160, 0));
        legendOptions.put("forceTitles", "off");
        legendOptions.put("forceLabels", "off");
        legendOptions.put("layout", "HORIZONTAL");
        legendOptions.put("grouplayout", "VERTICAL");
        req.setLegendOptions(legendOptions);
        image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)60L, (long)image.getHeight());
        Assert.assertEquals((long)64L, (long)image.getWidth());
        this.assertPixel(image, 10, 10, new Color(64, 64, 192));
        this.assertPixel(image, 10, 30, new Color(170, 170, 170));
        this.assertPixel(image, 10, 50, new Color(192, 160, 0));
        legendOptions.put("forceTitles", "off");
        legendOptions.put("forceLabels", "off");
        legendOptions.put("layout", "VERTICAL");
        legendOptions.put("grouplayout", "HORIZONTAL");
        req.setLegendOptions(legendOptions);
        image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)60L, (long)image.getHeight());
        Assert.assertEquals((long)66L, (long)image.getWidth());
        this.assertPixel(image, 10, 10, new Color(64, 64, 192));
        this.assertPixel(image, 30, 10, new Color(170, 170, 170));
        this.assertPixel(image, 50, 10, new Color(192, 160, 0));
        legendOptions.put("forceTitles", "off");
        legendOptions.put("forceLabels", "off");
        legendOptions.put("layout", "HORIZONTAL");
        legendOptions.put("grouplayout", "HORIZONTAL");
        req.setLegendOptions(legendOptions);
        image = (BufferedImage)this.legendProducer.buildLegendGraphic(req);
        Assert.assertEquals((long)20L, (long)image.getHeight());
        Assert.assertEquals((long)126L, (long)image.getWidth());
        this.assertPixel(image, 10, 10, new Color(64, 64, 192));
        this.assertPixel(image, 30, 10, new Color(170, 170, 170));
        this.assertPixel(image, 70, 10, new Color(192, 160, 0));
    }
}

