/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.TransformerException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.GetLegendGraphic;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.legendgraphic.BaseLegendTest;
import org.geoserver.wms.legendgraphic.JSONLegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.styling.SLDParser;
import org.geotools.xml.styling.SLDTransformer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JSONLegendGraphicOutputFormatTest
extends BaseLegendTest<JSONLegendGraphicBuilder> {
    static final String JSONFormat = "application/json";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("tricky_point", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("arealandmarks", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("fixedArrows", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("dynamicArrows", ((Object)((Object)this)).getClass(), catalog);
    }

    @Before
    public void setLegendProducer() throws Exception {
        this.legendProducer = new JSONLegendGraphicBuilder();
        this.service = new GetLegendGraphic(this.getWMS());
    }

    @Test
    public void testUserSpecifiedRule() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        Rule rule = (Rule)((FeatureTypeStyle)multipleRulesStyle.featureTypeStyles().get(0)).rules().get(0);
        LOGGER.info("testing single rule " + rule.getName() + " from style " + multipleRulesStyle.getName());
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        GetLegendGraphicRequest req = this.getRequest(ftInfo.getFeatureType(), multipleRulesStyle);
        req.setRule(rule.getName());
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        JSONArray rules = result.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)rule.getDescription().getTitle().toString(), (Object)rules.getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
    }

    @Test
    public void testRainfall() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall").getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        GetLegendGraphicRequest req = this.getRequest(feature.getSchema(), multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testNoLayerProvidedAndNonStrictRequest() throws Exception {
        Style style = this.getCatalog().getStyleByName("rainfall").getStyle();
        Assert.assertNotNull((Object)style);
        GetLegendGraphicRequest req = this.getRequest(null, style);
        req.setStrict(false);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((long)1L, (long)resp.getJSONArray("Legend").size());
    }

    @Test
    public void testMultipleLayers() throws Exception {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        Style style = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        GetLegendGraphicRequest req = this.getRequest(ftInfo.getFeatureType(), style);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(resp);
        GetLegendGraphicRequest getLegendGraphicRequest = req;
        getLegendGraphicRequest.getClass();
        GetLegendGraphicRequest.LegendRequest legend = new GetLegendGraphicRequest.LegendRequest(getLegendGraphicRequest, ftInfo.getFeatureType(), req.getWms());
        legend.setStyle(style);
        req.getLegends().add(legend);
        resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(resp);
    }

    @Test
    public void testMultipleLayersWithDifferentStyles() throws Exception {
        GetLegendGraphicRequest req = this.getRequest(null, null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        layers.add(ftInfo.getFeatureType());
        req.setLayers(layers);
        ArrayList<Style> styles = new ArrayList<Style>();
        Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        styles.add(style1);
        Style style2 = this.getCatalog().getStyleByName(MockData.LAKES.getLocalPart()).getStyle();
        styles.add(style2);
        req.setStyles(styles);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertEquals((long)2L, (long)legend.size());
    }

    @Test
    public void testMultipleLayersWithVectorAndCoverage() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setFeatureType(JSONFormat);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        layers.add(feature.getSchema());
        req.setLayers(layers);
        ArrayList<Style> styles = new ArrayList<Style>();
        Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        styles.add(style1);
        Style style2 = this.getCatalog().getStyleByName("rainfall").getStyle();
        styles.add(style2);
        req.setStyles(styles);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((Object)"RoadSegments", (Object)resp.getJSONArray("Legend").getJSONObject(0).get("layerName"));
        Assert.assertEquals((Object)"GridCoverage", (Object)resp.getJSONArray("Legend").getJSONObject(1).get("layerName"));
    }

    @Test
    public void testMultipleLayersWithVectorAndInvisibleCoverage() throws Exception {
        GetLegendGraphicRequest req = this.getRequest(null, null);
        req.setScale(1000.0);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        layers.add(feature.getSchema());
        req.setLayers(layers);
        ArrayList<Style> styles = new ArrayList<Style>();
        Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        styles.add(style1);
        styles.add(this.readSLD("InvisibleRaster.sld"));
        req.setStyles(styles);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        JSONArray legends = resp.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)legends.size());
        Assert.assertEquals((Object)"RoadSegments", (Object)legends.getJSONObject(0).get("layerName"));
    }

    @Test
    public void testMultipleLayersWithVectorAndInvisibleVector() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setScale(1000.0);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        layers.add(ftInfo.getFeatureType());
        req.setLayers(layers);
        ArrayList<Style> styles = new ArrayList<Style>();
        StyleInfo roadStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart());
        styles.add(roadStyle.getStyle());
        styles.add(this.readSLD("InvisibleLine.sld"));
        req.setStyles(styles);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        JSONArray legends = resp.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)legends.size());
        Assert.assertEquals((Object)"RoadSegments", (Object)legends.getJSONObject(0).get("layerName"));
    }

    @Test
    public void testMixedGeometry() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("MIXEDGEOMETRY");
        builder.setNamespaceURI("test");
        builder.setDefaultGeometry("GEOMETRY");
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        builder.setCRS(crs);
        GeometryFactory geometryFactory = new GeometryFactory();
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl("ID"), String.class, false, false, Collections.EMPTY_LIST, null, null);
        builder.add((AttributeDescriptor)new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("ID"), 0, 1, false, null));
        GeometryTypeImpl gt = new GeometryTypeImpl((Name)new NameImpl("GEOMETRY"), Geometry.class, crs, false, false, Collections.EMPTY_LIST, null, null);
        builder.add((AttributeDescriptor)new GeometryDescriptorImpl((GeometryType)gt, (Name)new NameImpl("GEOMETRY"), 0, 1, false, null));
        SimpleFeatureType fType = builder.buildFeatureType();
        ArrayList<SimpleFeatureType> layers = new ArrayList<SimpleFeatureType>();
        layers.add(fType);
        req.setLayers(layers);
        ArrayList<Style> styles = new ArrayList<Style>();
        styles.add(this.readSLD("MixedGeometry.sld"));
        req.setStyles(styles);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        JSONArray legends = resp.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)legends.size());
        JSONObject legend = legends.getJSONObject(0);
        Assert.assertEquals((Object)"MIXEDGEOMETRY", (Object)legend.get("layerName"));
        JSONArray rules = legend.getJSONArray("rules");
        Assert.assertTrue((boolean)rules.getJSONObject(0).getJSONArray("symbolizers").getJSONObject(0).containsKey((Object)"Line"));
        Assert.assertTrue((boolean)rules.getJSONObject(1).getJSONArray("symbolizers").getJSONObject(0).containsKey((Object)"Polygon"));
        Assert.assertTrue((boolean)rules.getJSONObject(2).getJSONArray("symbolizers").getJSONObject(0).containsKey((Object)"Point"));
    }

    @Test
    public void testSymbolContainedInIconUsingExpression() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("SymbolExpression.sld");
        req.setStyle(style);
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"[\"id\"]", "40"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.get("size").toString());
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testProportionalSymbolSize() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbols.sld"));
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"40", "20", "10", "1"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.get("size").toString());
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testProportionalSymbolsLine() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbolsLine.sld"));
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"30", "15"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Line");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.getJSONObject("graphic-stroke").getString("size"));
        }
    }

    @Test
    public void testProportionalSymbolSizeUOM() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("ProportionalSymbolsUOM.sld");
        req.setStyle(style);
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"40", "20", "10", "1"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.get("size").toString());
            Assert.assertEquals((Object)"m", (Object)pointSymb.get("uom"));
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testProportionalSymbolSizePartialUOM() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setScale(RendererUtilities.calculatePixelsPerMeterRatio((double)10.0, (Map)Collections.EMPTY_MAP));
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("ProportionalSymbolsPartialUOM.sld");
        this.printStyle(style);
        req.setStyle(style);
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        String[] expectedSizes = new String[]{"40.0", "40.0"};
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            this.assertNotEmpty(rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[i], (Object)pointSymb.get("size"));
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testInternationalizedLabels() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("forceLabels", "on");
        req.setLegendOptions(options);
        req.setFormat(JSONFormat);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("Internationalized.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((Object)"title", (Object)result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
        req.setLocale(Locale.ITALIAN);
        result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((Object)"titolomoltolungo", (Object)result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
        req.setLocale(Locale.ENGLISH);
        result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((Object)"anothertitle", (Object)result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
    }

    @Test
    public void testRenderingTransformationRasterVector() throws Exception {
        Style transformStyle = this.readSLD("RenderingTransformRasterVector.sld");
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName(MockData.TASMANIA_DEM.getNamespaceURI(), MockData.TASMANIA_DEM.getLocalPart());
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(transformStyle);
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
    }

    @Test
    public void testColorMapWithCql() throws Exception {
        Style style = this.readSLD("ColorMapWithCql.sld");
        Assert.assertNotNull((Object)style.featureTypeStyles());
        Assert.assertEquals((long)1L, (long)style.featureTypeStyles().size());
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Assert.assertNotNull((Object)fts.rules());
        Assert.assertEquals((long)1L, (long)fts.rules().size());
        Rule rule = (Rule)fts.rules().get(0);
        Assert.assertNotNull((Object)rule.symbolizers());
        Assert.assertEquals((long)1L, (long)rule.symbolizers().size());
        Assert.assertTrue((boolean)(rule.symbolizers().get(0) instanceof RasterSymbolizer));
        RasterSymbolizer symbolizer = (RasterSymbolizer)rule.symbolizers().get(0);
        Assert.assertNotNull((Object)symbolizer.getColorMap());
        Assert.assertEquals((long)3L, (long)symbolizer.getColorMap().getColorMapEntries().length);
        ColorMapEntry[] entries = symbolizer.getColorMap().getColorMapEntries();
        Color color = LegendUtils.color((ColorMapEntry)entries[0]);
        int red = color.getRed();
        Assert.assertEquals((long)255L, (long)red);
        int green = color.getGreen();
        Assert.assertEquals((long)0L, (long)green);
        int blue = color.getBlue();
        Assert.assertEquals((long)0L, (long)blue);
        double quantity = LegendUtils.getQuantity((ColorMapEntry)entries[1]);
        Assert.assertEquals((double)20.0, (double)quantity, (double)0.0);
        double opacity = LegendUtils.getOpacity((ColorMapEntry)entries[2]);
        Assert.assertEquals((double)0.5, (double)opacity, (double)0.0);
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(style);
        req.setLegendOptions(new HashMap());
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray lx = result.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)lx.size());
        JSONObject rasterSymb = lx.getJSONObject(0).getJSONArray("rules").getJSONObject(0).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Raster");
        JSONArray colorMap = rasterSymb.getJSONObject("colormap").getJSONArray("entries");
        Assert.assertEquals((Object)"['${strConcat(''#FF'',''0000'')}']", (Object)colorMap.getJSONObject(0).get("color"));
        Assert.assertEquals((Object)"[\"${15+5}\"]", (Object)colorMap.getJSONObject(1).getString("quantity"));
        Assert.assertEquals((Object)"[\"${0.25*2}\"]", (Object)colorMap.getJSONObject(2).getString("opacity"));
    }

    @Test
    public void testRenderingTransformationVectorRaster() throws Exception {
        Style transformStyle = this.readSLD("RenderingTransformVectorRaster.sld");
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.NAMED_PLACES.getNamespaceURI(), MockData.NAMED_PLACES.getLocalPart());
        Assert.assertNotNull((Object)ftInfo);
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(transformStyle);
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
    }

    @Test
    public void testExternalGraphic() throws Exception {
        Style externalGraphicStyle = this.readSLD("ExternalGraphicDemo.sld");
        Assert.assertNotNull((Object)externalGraphicStyle);
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        this.printStyle(externalGraphicStyle);
        req.setStyle(externalGraphicStyle);
        req.setScale(1.0);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        this.print((JSON)result);
        JSONArray lx = result.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)lx.size());
        JSONObject pointSymb = lx.getJSONObject(0).getJSONArray("rules").getJSONObject(0).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Point");
        Assert.assertEquals((Object)"14.0", (Object)pointSymb.get("size"));
        Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        Assert.assertEquals((Object)"image/png", (Object)lx.getJSONObject(0).getJSONArray("rules").getJSONObject(1).getJSONObject("LegendGraphic").get("external-graphic-type"));
    }

    @Test
    public void testThickPolygonBorder() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("ThickBorder.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        this.print((JSON)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        Assert.assertFalse((boolean)legend.isEmpty());
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb1 = symbolizers.getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb1);
        Assert.assertEquals((Object)"#FF0000", (Object)polySymb1.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb1.get("stroke"));
        Assert.assertEquals((Object)"4", (Object)polySymb1.get("stroke-width"));
        JSONObject polySymb2 = rules.getJSONObject(1).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb2);
        Assert.assertEquals((Object)"#00FF00", (Object)polySymb2.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb2.get("stroke"));
        Assert.assertEquals((Object)"1", (Object)polySymb2.get("stroke-width"));
    }

    @Test
    public void testSimplePoint() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("point.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
    }

    @Test
    public void testHospitalPoint() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("hospital.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Hospital?0.0.0=", (Object)pointSymb.getString("url"));
        pointSymb = symbolizers.getJSONObject(1).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Hospital?0.0.1=", (Object)pointSymb.getString("url"));
    }

    @Test
    public void testTrickyGraphic() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("tricky_point");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/styles/img/landmarks/shop_supermarket.p.16.png", (Object)pointSymb.getString("url"));
        symbolizers = rules.getJSONObject(2).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/tricky_point?0.2.0=", (Object)pointSymb.getString("url"));
        pointSymb = symbolizers.getJSONObject(1).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/tricky_point?0.2.1=", (Object)pointSymb.getString("url"));
    }

    @Test
    public void testGraphicFillLinks() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOLYGONS.getNamespaceURI(), MockData.MPOLYGONS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("arealandmarks");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)2L, (long)rules.size());
        JSONObject r1 = rules.getJSONObject(0);
        Assert.assertEquals((Object)"park", (Object)r1.getString("name"));
        Assert.assertEquals((Object)"[MTFCC = 'K2180']", (Object)r1.getString("filter"));
        JSONArray symbolizers1 = r1.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers1.size());
        JSONObject s1 = symbolizers1.getJSONObject(0);
        JSONObject gf1 = s1.getJSONObject("Polygon").getJSONObject("graphic-fill");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/styles/img/landmarks/area/forest.png", (Object)gf1.getString("url"));
        JSONObject r2 = rules.getJSONObject(1);
        Assert.assertEquals((Object)"nationalpark", (Object)r2.getString("name"));
        Assert.assertEquals((Object)"[MTFCC = 'K2181']", (Object)r2.getString("filter"));
        JSONArray symbolizers2 = r2.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers2.size());
        JSONObject s2 = symbolizers2.getJSONObject(0);
        JSONObject gf2 = s2.getJSONObject("Polygon").getJSONObject("graphic-fill");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/arealandmarks?0.1.0=&npg=true", (Object)gf2.getString("url"));
    }

    @Test
    public void testTextSymbolizerGraphic() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("fixedArrows");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        JSONObject r1 = rules.getJSONObject(0);
        JSONArray symbolizers1 = r1.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers1.size());
        JSONObject s1 = symbolizers1.getJSONObject(0);
        JSONObject graphic = s1.getJSONObject("Text").getJSONObject("graphic");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/fixedArrows?0.0.0=&npg=true", (Object)graphic.getString("url"));
    }

    @Test
    public void testTextSymbolizerDynamicGraphic() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("dynamicArrows");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        JSONObject r1 = rules.getJSONObject(0);
        JSONArray symbolizers1 = r1.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers1.size());
        JSONObject s1 = symbolizers1.getJSONObject(0);
        JSONObject graphic = s1.getJSONObject("Text").getJSONObject("graphic");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/dynamicArrows?0.0.0=&0.0.0.rotation=0.0&0.0.0.size=16.0&npg=true", (Object)graphic.getString("url"));
    }

    @Test
    public void testElseFilter() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("PopulationElse.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        JSONObject rule = rules.getJSONObject(2);
        Assert.assertEquals((Object)"true", (Object)rule.get("ElseFilter"));
    }

    @Test
    public void testFullPoint() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("full_point.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"[centroid(the_geom)]", (Object)pointSymb.get("geometry"));
        Assert.assertEquals((Object)"6", (Object)pointSymb.get("size"));
        Assert.assertEquals((Object)"[rotation * '-1']", (Object)pointSymb.get("rotation"));
        Assert.assertEquals((Object)"0.4", (Object)pointSymb.get("opacity"));
    }

    @Test
    public void testSimpleLine() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("line.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject lineSymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertNotNull((Object)lineSymb);
        Assert.assertEquals((Object)"#0000FF", (Object)lineSymb.get("stroke"));
        Assert.assertEquals((Object)"2", (Object)lineSymb.get("stroke-width"));
    }

    @Test
    public void testFullLine() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("full_line.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject lineSymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertFalse((boolean)lineSymb.isNullObject());
        JSONObject lineSymb1 = symbolizers.getJSONObject(1).getJSONObject("Line");
        Assert.assertFalse((boolean)lineSymb1.isNullObject());
        Assert.assertEquals((Object)"10", (Object)lineSymb.get("perpendicular-offset"));
        JSONObject graphicStroke1 = lineSymb1.getJSONObject("graphic-stroke");
        Assert.assertFalse((boolean)graphicStroke1.isNullObject());
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Default%20Styler?0.0.0=&0.0.0.rotation=0.0&npg=true", (Object)graphicStroke1.getString("url"));
        JSONObject lineSymb2 = symbolizers.getJSONObject(2).getJSONObject("Line");
        Assert.assertFalse((boolean)lineSymb2.isNullObject());
        JSONObject graphicFill2 = lineSymb2.getJSONObject("graphic-fill");
        Assert.assertFalse((boolean)graphicFill2.isNullObject());
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Default%20Styler?0.0.1=&0.0.1.rotation=0.0&npg=true", (Object)graphicFill2.getString("url"));
    }

    @Test
    public void testSimplePolygon() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("polygon.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#0099CC", (Object)polySymb.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.5", (Object)polySymb.get("stroke-width"));
    }

    @Test
    public void testFullPolygon() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("full_polygon.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#0099CC", (Object)polySymb.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.5", (Object)polySymb.get("stroke-width"));
        JSONObject polySymb2 = symbolizers.getJSONObject(1).getJSONObject("Polygon");
        Assert.assertFalse((polySymb2.isNullObject() && polySymb2.isEmpty() ? 1 : 0) != 0);
        JSONObject stroke = polySymb2.getJSONObject("graphic-stroke");
        Assert.assertFalse((stroke.isNullObject() && stroke.isEmpty() ? 1 : 0) != 0);
        JSONObject fill = polySymb2.getJSONObject("graphic-fill");
        Assert.assertFalse((fill.isNullObject() && fill.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleText() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("text.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.2", (Object)polySymb.get("stroke-width"));
        JSONObject textSymb = symbolizers.getJSONObject(1).getJSONObject("Text");
        Assert.assertFalse((boolean)textSymb.isNullObject());
        Assert.assertEquals((Object)"[STATE_ABBR]", (Object)textSymb.getString("label"));
        JSONArray fonts = textSymb.getJSONArray("fonts");
        Assert.assertEquals((long)2L, (long)fonts.size());
        Assert.assertEquals((Object)"[STATE_FONT]", (Object)fonts.getJSONObject(0).getJSONArray("font-family").get(0));
        Assert.assertEquals((Object)"Lobster", (Object)fonts.getJSONObject(0).getJSONArray("font-family").get(1));
        Assert.assertEquals((Object)"Times New Roman", (Object)fonts.getJSONObject(0).getJSONArray("font-family").get(2));
        Assert.assertEquals((Object)"Normal", (Object)fonts.getJSONObject(0).get("font-style"));
        Assert.assertEquals((Object)"normal", (Object)fonts.getJSONObject(0).get("font-weight"));
        Assert.assertEquals((Object)"14", (Object)fonts.getJSONObject(0).get("font-size"));
        Assert.assertEquals((Object)"Times New Roman", (Object)fonts.getJSONObject(1).getJSONArray("font-family").get(0));
        Assert.assertEquals((Object)"Italic", (Object)fonts.getJSONObject(1).get("font-style"));
        Assert.assertEquals((Object)"normal", (Object)fonts.getJSONObject(1).get("font-weight"));
        Assert.assertEquals((Object)"9", (Object)fonts.getJSONObject(1).get("font-size"));
        Assert.assertFalse((boolean)textSymb.getJSONObject("label-placement").isNullObject());
        Assert.assertFalse((boolean)textSymb.getJSONObject("halo").isNullObject());
        JSONObject vops = textSymb.getJSONObject("vendor-options");
        this.assertNotEmpty(vops);
        Assert.assertEquals((Object)"true", (Object)vops.get("followLine"));
    }

    @Test
    public void testComplexText() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("text_scaleSize.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.2", (Object)polySymb.get("stroke-width"));
        JSONObject textSymb = symbolizers.getJSONObject(1).getJSONObject("Text");
        Assert.assertFalse((boolean)textSymb.isNullObject());
        Assert.assertEquals((Object)"[STATE_ABBR]", (Object)textSymb.getString("label"));
        JSONArray fonts = textSymb.getJSONArray("fonts");
        Assert.assertEquals((long)2L, (long)fonts.size());
        Assert.assertEquals((Object)"9", (Object)fonts.getJSONObject(1).get("font-size"));
    }

    @Test
    public void testContrastRaster() throws Exception {
        Style multipleRulesStyle = this.readSLD("raster_brightness.sld");
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject rasterSymb = symbolizers.getJSONObject(0).getJSONObject("Raster");
        this.assertNotEmpty(rasterSymb);
        JSONObject ce = rasterSymb.getJSONObject("contrast-enhancement");
        this.assertNotEmpty(ce);
        Assert.assertEquals((Object)"0.5", (Object)ce.getString("gamma-value"));
        Assert.assertEquals((Object)"true", (Object)ce.get("normalize"));
    }

    @Test
    public void testDescreteRaster() throws Exception {
        Style multipleRulesStyle = this.readSLD("raster_discretecolors.sld");
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(WMS.get());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject rasterSymb = symbolizers.getJSONObject(0).getJSONObject("Raster");
        this.assertNotEmpty(rasterSymb);
        JSONObject ce = rasterSymb.getJSONObject("contrast-enhancement");
        Assert.assertTrue((boolean)ce.isEmpty());
        JSONObject colormap = rasterSymb.getJSONObject("colormap");
        Assert.assertEquals((Object)"intervals", (Object)colormap.get("type"));
    }

    private void assertNotEmpty(JSONObject result) {
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isNullObject());
        Assert.assertFalse((boolean)result.isEmpty());
    }

    private Style readSLD(String sldName) throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        SLDParser stylereader = new SLDParser(styleFactory, ((Object)((Object)this)).getClass().getResource(sldName));
        Style[] readStyles = stylereader.readXML();
        Style style = readStyles[0];
        return style;
    }

    private void printStyle(Style style) throws TransformerException {
        if (JSONLegendGraphicOutputFormatTest.isQuietTests()) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SLDTransformer transformer = new SLDTransformer();
        transformer.setIndentation(2);
        transformer.transform((Object)style, (OutputStream)bos);
        String styleStr = bos.toString();
        System.out.println(styleStr);
    }

    private GetLegendGraphicRequest getRequest() {
        return this.getRequest(null, null);
    }

    private GetLegendGraphicRequest getRequest(FeatureType layer, Style style) {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(WMS.get());
        req.setBaseUrl("http://local-test:8080/geoserver");
        req.setLayer(layer);
        req.setStyle(style);
        req.setFormat(JSONFormat);
        return req;
    }
}

