/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.FeatureCountProcessor;
import org.geoserver.wms.legendgraphic.GetLegendGraphicKvpReader;
import org.geoserver.wms.legendgraphic.LegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.wms_1_1_1.GetLegendGraphicTest;
import org.geoserver.wms.wms_1_1_1.GetMapIntegrationTest;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FeatureCountLegendGraphicTest
extends WMSTestSupport {
    private static final QName SF_STATES = new QName(MockData.SF_URI, "states", MockData.SF_PREFIX);
    private LegendGraphicBuilder legendProducer;
    private List<Rule[]> ruleSets = new ArrayList<Rule[]>();
    private GetLegendGraphicRequest lastRequest;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("Population", "Population.sld", GetMapIntegrationTest.class, catalog);
        testData.addStyle("PopulationElse", "PopulationElse.sld", FeatureCountLegendGraphicTest.class, catalog);
        testData.addStyle("scaleDependent", "scaleDependent.sld", GetLegendGraphicTest.class, catalog);
        testData.addVectorLayer(SF_STATES, Collections.EMPTY_MAP, "states.properties", GetMapIntegrationTest.class, catalog);
    }

    @Before
    public void setupLegendProducer() throws Exception {
        this.ruleSets.clear();
        this.legendProducer = new BufferedImageLegendGraphicBuilder(){

            public String getContentType() {
                return "image/png";
            }

            protected Rule[] updateRuleTitles(FeatureCountProcessor processor, GetLegendGraphicRequest.LegendRequest legend, Rule[] applicableRules) {
                Rule[] updatedRules = super.updateRuleTitles(processor, legend, applicableRules);
                FeatureCountLegendGraphicTest.this.ruleSets.add(updatedRules);
                return updatedRules;
            }
        };
    }

    @Test
    public void testBasicPolygonsNoCount() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&format=image/png");
        Assert.assertEquals((long)0L, (long)this.ruleSets.size());
    }

    @Test
    public void testBasicPolygonsNoLabels() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&style=&format=image/png&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=30,0,40,10&legend_options=" + "countMatched" + ":true;forceLabels:off");
        Assert.assertEquals((long)0L, (long)this.ruleSets.size());
    }

    @Test
    public void testBasicPolygonsNoFeatures() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&style=&format=image/png&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=30,0,40,10&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        Assert.assertEquals((long)1L, (long)rules.length);
        this.assertLabel("(0)", rules[0]);
    }

    @Test
    public void testBasicPolygonsTwoFeatures() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&style=&format=image/png&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-2.4,1.4,0.4,4.2&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        Assert.assertEquals((long)1L, (long)rules.length);
        this.assertLabel("(2)", rules[0]);
    }

    @Test
    public void testBasicPolygonsTwoFeaturesWms13() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.3.0&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&style=&format=image/png&CRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=1.4,-2.4,4.2,0.4&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        Assert.assertEquals((long)1L, (long)rules.length);
        this.assertLabel("(2)", rules[0]);
    }

    @Test
    public void testBasicPolygonsAllFeatures() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&style=&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-180,-90,180,90&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        Assert.assertEquals((long)1L, (long)rules.length);
        this.assertLabel("(3)", rules[0]);
    }

    @Test
    public void testStatesFull() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&width=550&height=250&srs=EPSG:4326&bbox=-130,24,-66,50&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (23)", rules[2]);
        this.assertLabel("(49)", rules[3]);
    }

    @Test
    public void testStatesElse() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=PopulationElse&width=550&height=250&srs=EPSG:4326&bbox=-130,24,-66,50&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)3L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("Others (23)", rules[2]);
    }

    @Test
    public void testStatesMissingBbox() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&width=550&height=250&srs=EPSG:4326&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (23)", rules[2]);
        this.assertLabel("(49)", rules[3]);
    }

    @Test
    public void testStatesMissingHeightWidth() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&srs=EPSG:4326&bbox=-130,24,-66,50&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (23)", rules[2]);
        this.assertLabel("(49)", rules[3]);
    }

    @Test
    public void testStatesMissingHeightWidthSrs() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&bbox=-130,24,-66,50&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (23)", rules[2]);
        this.assertLabel("(49)", rules[3]);
    }

    @Test
    public void testStatesMissingBboxSrs() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&width=550&height=250&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (23)", rules[2]);
        this.assertLabel("(49)", rules[3]);
    }

    @Test
    public void testStatesMissingHeightWidthBboxSrs() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (23)", rules[2]);
        this.assertLabel("(49)", rules[3]);
    }

    @Test
    public void testStatesMissingHeightWidthBboxSrsOnWMS13() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.3.0&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&legend_options=" + "countMatched" + ":true");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (10)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (23)", rules[2]);
        this.assertLabel("(49)", rules[3]);
    }

    @Test
    public void testStatesCqlFilter() throws Exception {
        this.runGetLegendGraphics("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&width=550&height=250&srs=EPSG:4326&bbox=-130,24,-66,50&legend_options=" + "countMatched" + ":true&CQL_FILTER=PERSONS < 2000000");
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (0)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (0)", rules[2]);
        this.assertLabel("(16)", rules[3]);
    }

    @Test
    public void testStatesMatchFirst() throws Exception {
        String requestURL = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=Population&width=550&height=250&srs=EPSG:4326&bbox=-130,24,-66,50&legend_options=" + "countMatched" + ":true&CQL_FILTER=PERSONS < 2000000";
        Map rawKvp = this.caseInsensitiveKvp(KvpUtils.parseQueryString((String)requestURL));
        Map kvp = this.parseKvp(rawKvp);
        GetLegendGraphicKvpReader reader = new GetLegendGraphicKvpReader(this.getWMS());
        GetLegendGraphicRequest request = reader.read(reader.createRequest(), kvp, rawKvp);
        GetLegendGraphicRequest.LegendRequest legend = (GetLegendGraphicRequest.LegendRequest)request.getLegends().get(0);
        Style style = legend.getStyle();
        DuplicatingStyleVisitor matchFirstCloner = new DuplicatingStyleVisitor(){

            public void visit(FeatureTypeStyle fts) {
                super.visit(fts);
                FeatureTypeStyle copy = (FeatureTypeStyle)this.pages.peek();
                copy.getOptions().put("ruleEvaluation", "first");
            }
        };
        style.accept((StyleVisitor)matchFirstCloner);
        legend.setStyle((Style)matchFirstCloner.getCopy());
        this.legendProducer.buildLegendGraphic(request);
        this.lastRequest = request;
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)4L, (long)rules.length);
        this.assertLabel("2M - 4M (0)", rules[0]);
        this.assertLabel("< 2M (16)", rules[1]);
        this.assertLabel("> 4M (0)", rules[2]);
        this.assertLabel("(0)", rules[3]);
    }

    @Test
    public void testCountOnGroup() throws Exception {
        String url = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=nature&width=100&height=100&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&legend_options=countMatched:true";
        this.runGetLegendGraphics(url);
        for (Rule[] rules : this.ruleSets) {
            this.logLabels(rules);
        }
        Assert.assertEquals((long)2L, (long)this.ruleSets.size());
        Assert.assertEquals((long)1L, (long)this.ruleSets.get(0).length);
        Assert.assertEquals((long)1L, (long)this.ruleSets.get(1).length);
        this.assertLabel("title (1)", this.ruleSets.get(0)[0]);
        this.assertLabel("title (1)", this.ruleSets.get(1)[0]);
    }

    @Test
    public void testScaleDependentHittingScale() throws Exception {
        this.testScaleDependent("-109.11157608032227,36.97002410888672,-108.97974014282227,37.02667236328125", "TheRule (4)");
    }

    @Test
    public void testScaleDependentBelowMinScale() throws Exception {
        this.testScaleDependent("-109.05228853225708,36.994850635528564,-109.04404878616333,36.99839115142822", "TheRule (0)");
    }

    @Test
    public void testScaleDependentAboveMaxScale() throws Exception {
        this.testScaleDependent("-109.31121826171875,36.88041687011719,-108.78387451171875,37.10700988769531", "TheRule (0)");
    }

    public void testScaleDependent(String bboxSpecification, String expectedLabel) throws Exception {
        String requestURL = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&format=image/png&layer=" + this.getLayerId(SF_STATES) + "&style=scaleDependent&width=20&height=20&srs=EPSG:4326&bbox=" + bboxSpecification + "&legend_options=" + "countMatched" + ":true&srcwidht=768&srcheight=300";
        Map rawKvp = this.caseInsensitiveKvp(KvpUtils.parseQueryString((String)requestURL));
        Map kvp = this.parseKvp(rawKvp);
        GetLegendGraphicKvpReader reader = new GetLegendGraphicKvpReader(this.getWMS());
        GetLegendGraphicRequest request = reader.read(reader.createRequest(), kvp, rawKvp);
        this.legendProducer.buildLegendGraphic(request);
        this.lastRequest = request;
        Assert.assertEquals((long)1L, (long)this.ruleSets.size());
        Rule[] rules = this.ruleSets.get(0);
        this.logLabels(rules);
        Assert.assertEquals((long)1L, (long)rules.length);
        this.assertLabel(expectedLabel, rules[0]);
    }

    private void logLabels(Rule[] rules) {
        LOGGER.log(Level.INFO, this.lastRequest.toString());
        for (Rule rule : rules) {
            LOGGER.log(Level.INFO, LegendUtils.getRuleLabel((Rule)rule, (GetLegendGraphicRequest)this.lastRequest));
        }
    }

    private void assertLabel(String expected, Rule rule) {
        String actual = LegendUtils.getRuleLabel((Rule)rule, (GetLegendGraphicRequest)this.lastRequest);
        Assert.assertThat((Object)actual, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private GetLegendGraphicRequest runGetLegendGraphics(String requestURL) throws Exception {
        Map rawKvp = this.caseInsensitiveKvp(KvpUtils.parseQueryString((String)requestURL));
        Map kvp = this.parseKvp(rawKvp);
        GetLegendGraphicKvpReader reader = new GetLegendGraphicKvpReader(this.getWMS());
        GetLegendGraphicRequest request = reader.read(reader.createRequest(), kvp, rawKvp);
        this.legendProducer.buildLegendGraphic(request);
        this.lastRequest = request;
        return request;
    }
}

