/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import org.geoserver.wms.icons.IconPropertyInjector;
import org.geoserver.wms.icons.IconTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;

public class IconPropertyInjectorTest
extends IconTestSupport {
    static <T> T assertSingleElement(Iterable<T> elements) {
        Iterator<T> i = elements.iterator();
        Assert.assertTrue((String)"Expected one element but got none", (boolean)i.hasNext());
        T result = i.next();
        Assert.assertFalse((String)"Expected one element but got more", (boolean)i.hasNext());
        return result;
    }

    static <T, U extends T> U assertSingleElement(Iterable<T> elements, Class<U> clazz) {
        T result = IconPropertyInjectorTest.assertSingleElement(elements);
        Assert.assertThat(result, (Matcher)CoreMatchers.instanceOf(clazz));
        return (U)result;
    }

    static <T> T assumeSingleElement(Iterable<T> elements) {
        Iterator<T> i = elements.iterator();
        Assume.assumeTrue((String)"Expected one element but got none", (boolean)i.hasNext());
        T result = i.next();
        Assume.assumeFalse((String)"Expected one element but got more", (boolean)i.hasNext());
        return result;
    }

    static <T, U extends T> U assumeSingleElement(Iterable<T> elements, Class<U> clazz) {
        T result = IconPropertyInjectorTest.assertSingleElement(elements);
        Assume.assumeThat(result, (Matcher)CoreMatchers.instanceOf(clazz));
        return (U)result;
    }

    @Test
    public void testSimplePointStyle() throws Exception {
        PointSymbolizer symb = this.grayCircle();
        Style input = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symb}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.0.0", "");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assertSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assertSingleElement(fts.rules());
        PointSymbolizer symb2 = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        IconPropertyInjectorTest.assertSingleElement(symb2.getGraphic().graphicalSymbols(), Mark.class);
    }

    @Test
    public void testSimplePointStyleOff() throws Exception {
        PointSymbolizer symb = this.grayCircle();
        Style input = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symb}));
        HashMap properties = new HashMap();
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assumeSingleElement(fts.rules());
        Assert.assertThat((Object)rule.symbolizers().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testSimpleGraphicStyle() throws Exception {
        PointSymbolizer symb = this.externalGraphic("http://example.com/foo.png", "image/png");
        Style input = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symb}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.0.0", "");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assumeSingleElement(fts.rules());
        PointSymbolizer symb2 = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        ExternalGraphic eg = IconPropertyInjectorTest.assertSingleElement(symb2.getGraphic().graphicalSymbols(), ExternalGraphic.class);
        Assert.assertThat((Object)eg.getOnlineResource().getLinkage().toString(), (Matcher)CoreMatchers.is((Object)"http://example.com/foo.png"));
    }

    @Test
    public void testSubstitutedGraphicStyle() throws Exception {
        PointSymbolizer symb = this.externalGraphic("http://example.com/${PROV_ABBR}.png", "image/png");
        Style input = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symb}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.0.0", "");
        properties.put("0.0.0.url", "http://example.com/BC.png");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assumeSingleElement(fts.rules());
        PointSymbolizer symb2 = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        ExternalGraphic eg = IconPropertyInjectorTest.assertSingleElement(symb2.getGraphic().graphicalSymbols(), ExternalGraphic.class);
        Assert.assertThat((Object)eg.getOnlineResource().getLinkage().toString(), (Matcher)CoreMatchers.is((Object)"http://example.com/BC.png"));
    }

    @Test
    public void testUnneccessaryURLInjection() throws Exception {
        PointSymbolizer symb = this.externalGraphic("http://example.com/NF.png", "image/png");
        Style input = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symb}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.0.0", "");
        properties.put("0.0.0.url", "http://example.com/BC.png");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assumeSingleElement(fts.rules());
        PointSymbolizer symb2 = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        ExternalGraphic eg = IconPropertyInjectorTest.assertSingleElement(symb2.getGraphic().graphicalSymbols(), ExternalGraphic.class);
        Assert.assertThat((Object)eg.getOnlineResource().getLinkage().toString(), (Matcher)CoreMatchers.is((Object)"http://example.com/NF.png"));
    }

    @Test
    public void testRotation() throws Exception {
        PointSymbolizer symb = this.externalGraphic("http://example.com/foo.png", "image/png");
        symb.getGraphic().setRotation((Expression)filterFactory.property("heading"));
        Style input = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symb}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.0.0", "");
        properties.put("0.0.0.rotation", "45.0");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assumeSingleElement(fts.rules());
        PointSymbolizer symb2 = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        Graphic eg = symb2.getGraphic();
        Assert.assertThat((Object)eg.getRotation().evaluate(null).toString(), (Matcher)CoreMatchers.is((Object)"45.0"));
    }

    @Test
    public void testFilteredRulesPickFirstExternal() throws Exception {
        PropertyIsLessThan f1 = filterFactory.less((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PropertyIsGreaterThanOrEqualTo f2 = filterFactory.greaterOrEqual((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PointSymbolizer symb1 = this.externalGraphic("http://example.com/foo.png", "image/png");
        PointSymbolizer symb2 = this.externalGraphic("http://example.com/bar.png", "image/png");
        Style input = this.styleFromRules(this.rule((Filter)f1, new Symbolizer[]{symb1}), this.rule((Filter)f2, new Symbolizer[]{symb2}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.0.0", "");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assertSingleElement(fts.rules());
        PointSymbolizer symb = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        ExternalGraphic eg = IconPropertyInjectorTest.assertSingleElement(symb.getGraphic().graphicalSymbols(), ExternalGraphic.class);
        Assert.assertThat((Object)eg.getOnlineResource().getLinkage().toString(), (Matcher)CoreMatchers.is((Object)"http://example.com/foo.png"));
    }

    @Test
    public void testFilteredRulesPickSecondExternal() throws Exception {
        PropertyIsLessThan f1 = filterFactory.less((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PropertyIsGreaterThanOrEqualTo f2 = filterFactory.greaterOrEqual((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PointSymbolizer symb1 = this.externalGraphic("http://example.com/foo.png", "image/png");
        PointSymbolizer symb2 = this.externalGraphic("http://example.com/bar.png", "image/png");
        Style input = this.styleFromRules(this.rule((Filter)f1, new Symbolizer[]{symb1}), this.rule((Filter)f2, new Symbolizer[]{symb2}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.1.0", "");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assertSingleElement(fts.rules());
        PointSymbolizer symb = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        ExternalGraphic eg = IconPropertyInjectorTest.assertSingleElement(symb.getGraphic().graphicalSymbols(), ExternalGraphic.class);
        Assert.assertThat((Object)eg.getOnlineResource().getLinkage().toString(), (Matcher)CoreMatchers.is((Object)"http://example.com/bar.png"));
    }

    @Test
    public void testFilteredRulesPickFirstMark() throws Exception {
        PropertyIsLessThan f1 = filterFactory.less((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PropertyIsGreaterThanOrEqualTo f2 = filterFactory.greaterOrEqual((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PointSymbolizer symb1 = this.mark("arrow", Color.BLACK, Color.RED, 1.0f, 16);
        PointSymbolizer symb2 = this.mark("arrow", Color.BLACK, Color.BLUE, 1.0f, 16);
        Style input = this.styleFromRules(this.rule((Filter)f1, new Symbolizer[]{symb1}), this.rule((Filter)f2, new Symbolizer[]{symb2}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.0.0", "");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assertSingleElement(fts.rules());
        PointSymbolizer symb = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        Mark mark = IconPropertyInjectorTest.assertSingleElement(symb.getGraphic().graphicalSymbols(), Mark.class);
        Assert.assertThat((Object)mark.getFill().getColor().evaluate(null, Color.class), (Matcher)CoreMatchers.is((Object)Color.RED));
    }

    @Test
    public void testFilteredRulesPickSecondMark() throws Exception {
        PropertyIsLessThan f1 = filterFactory.less((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PropertyIsGreaterThanOrEqualTo f2 = filterFactory.greaterOrEqual((Expression)filterFactory.property("foo"), (Expression)filterFactory.literal(4));
        PointSymbolizer symb1 = this.mark("arrow", Color.BLACK, Color.RED, 1.0f, 16);
        PointSymbolizer symb2 = this.mark("arrow", Color.BLACK, Color.BLUE, 1.0f, 16);
        Style input = this.styleFromRules(this.rule((Filter)f1, new Symbolizer[]{symb1}), this.rule((Filter)f2, new Symbolizer[]{symb2}));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("0.1.0", "");
        Style result = IconPropertyInjector.injectProperties((Style)input, properties);
        FeatureTypeStyle fts = (FeatureTypeStyle)IconPropertyInjectorTest.assumeSingleElement(result.featureTypeStyles());
        Rule rule = (Rule)IconPropertyInjectorTest.assertSingleElement(fts.rules());
        PointSymbolizer symb = IconPropertyInjectorTest.assertSingleElement(rule.symbolizers(), PointSymbolizer.class);
        Mark mark = IconPropertyInjectorTest.assertSingleElement(symb.getGraphic().graphicalSymbols(), Mark.class);
        Assert.assertThat((Object)mark.getFill().getColor().evaluate(null, Color.class), (Matcher)CoreMatchers.is((Object)Color.BLUE));
    }

    @Test
    public void testGraphicFallbacks() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Style style = SLD.createPointStyle((String)"circle", (Color)Color.RED, (Color)Color.yellow, (float)0.5f, (float)10.0f);
        Graphic g = SLD.graphic((PointSymbolizer)SLD.pointSymbolizer((Style)style));
        g.setRotation((Expression)ff.literal(45));
        g.setOpacity((Expression)ff.literal(0.5));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("0.0.0", "");
        style = IconPropertyInjector.injectProperties((Style)style, props);
        g = SLD.graphic((PointSymbolizer)SLD.pointSymbolizer((Style)style));
        Assert.assertEquals((double)10.0, (double)((Double)g.getSize().evaluate(null, Double.class)), (double)0.1);
        Assert.assertEquals((double)45.0, (double)((Double)g.getRotation().evaluate(null, Double.class)), (double)0.1);
        Assert.assertEquals((double)0.5, (double)((Double)g.getOpacity().evaluate(null, Double.class)), (double)0.1);
    }
}

