/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.TextFeatureInfoOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextFeatureInfoOutputFormatTest
extends WMSTestSupport {
    private TextFeatureInfoOutputFormat outputFormat;
    private FeatureCollectionType fcType;
    Map<String, Object> parameters;
    GetFeatureInfoRequest getFeatureInfoRequest;

    @Before
    public void setUp() throws URISyntaxException, IOException {
        this.outputFormat = new TextFeatureInfoOutputFormat(this.getWMS());
        Request request = new Request();
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("LAYER", "testLayer");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TEST1", "VALUE1");
        env.put("TEST2", "VALUE2");
        this.parameters.put("ENV", env);
        request.setKvp(this.parameters);
        Dispatcher.REQUEST.set(request);
        FeatureTypeInfo featureType = this.getFeatureTypeInfo(MockData.NULLS);
        this.fcType = WfsFactory.eINSTANCE.createFeatureCollectionType();
        this.fcType.getFeature().add((Object)featureType.getFeatureSource(null, null).getFeatures());
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setType(PublishedType.VECTOR);
        FeatureTypeInfoImpl resourceInfo = new FeatureTypeInfoImpl(null);
        NamespaceInfoImpl nameSpace = new NamespaceInfoImpl();
        nameSpace.setPrefix("topp");
        nameSpace.setURI("http://www.topp.org");
        resourceInfo.setNamespace((NamespaceInfo)nameSpace);
        layerInfo.setResource((ResourceInfo)resourceInfo);
        MapLayerInfo mapLayerInfo = new MapLayerInfo((LayerInfo)layerInfo);
        queryLayers.add(mapLayerInfo);
        this.getFeatureInfoRequest = new GetFeatureInfoRequest();
        this.getFeatureInfoRequest.setQueryLayers(queryLayers);
    }

    @Test
    public void testNullGeometry() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertFalse((boolean)result.contains("java.lang.NullPointerException"));
        Assert.assertTrue((boolean)result.contains("pointProperty = null"));
    }
}

