/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.wms_1_1_1.GetFeatureInfoTest;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetFeatureInfoJSONTest
extends GetFeatureInfoTest {
    @Test
    public void testSimpleJSONP() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "text/javascript";
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertEquals((Object)"text/javascript", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.startsWith("parseResponse"));
        Assert.assertTrue((boolean)result.endsWith(")"));
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        result = result.substring(0, result.length() - 1);
        result = result.substring("parseResponse".length() + 1, result.length());
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testCustomJSONP() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "text/javascript" + "&format_options=" + "callback" + ":custom";
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertEquals((Object)"text/javascript", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.startsWith("custom("));
        Assert.assertTrue((boolean)result.endsWith(")"));
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        result = result.substring(0, result.length() - 1);
        result = result.substring("custom".length() + 1, result.length());
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testSimpleJSON() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json";
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testPropertySelection() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?service=wms&version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json" + "&propertyName=NAME";
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertTrue((boolean)aFeature.getJSONObject("geometry").isNullObject());
        JSONObject properties = aFeature.getJSONObject("properties");
        Assert.assertTrue((boolean)properties.getJSONObject("FID").isNullObject());
        Assert.assertEquals((Object)"Green Forest", (Object)properties.get("NAME"));
    }

    @Test
    public void testReprojectedLayer() throws Exception {
        String layer = this.getLayerId(MockData.MPOLYGONS);
        String request = "wms?version=1.1.1&bbox=500525,500025,500575,500050&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject feature = (JSONObject)json.getJSONArray("features").get(0);
        JSONObject geom = feature.getJSONObject("geometry");
        JSONArray coords = geom.getJSONArray("coordinates").getJSONArray(0).getJSONArray(0).getJSONArray(0);
        Assert.assertTrue((boolean)new NumberRange(Double.class, (Number)500525.0, (Number)500575.0).contains((Number)coords.getDouble(0)));
        Assert.assertTrue((boolean)new NumberRange(Double.class, (Number)500025.0, (Number)500050.0).contains((Number)coords.getDouble(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCQLFilter() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONArray features = json.getJSONArray("features");
        Assert.assertTrue((features.size() > 0 ? 1 : 0) != 0);
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(layer);
        try {
            info.setCqlFilter("NAME LIKE 'Red%'");
            this.getCatalog().save((ResourceInfo)info);
            json = (JSONObject)this.getAsJSON(request);
            features = json.getJSONArray("features");
            Assert.assertEquals((long)0L, (long)features.size());
        }
        finally {
            info = this.getCatalog().getFeatureTypeByName(layer);
            info.setCqlFilter(null);
            this.getCatalog().save((ResourceInfo)info);
        }
    }
}

