/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.awt.Color;
import java.util.List;
import org.geoserver.wms.featureinfo.DynamicSizeStyleExtractor;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Stroke;

public class DynamicSizeStyleExtractorTest {
    StyleBuilder sb = new StyleBuilder();
    private Rule staticPolygonRule;
    private Rule staticLineRule;
    private DynamicSizeStyleExtractor visitor;

    @Before
    public void setup() {
        this.staticPolygonRule = this.sb.createRule((Symbolizer)this.sb.createPolygonSymbolizer(Color.RED));
        this.staticLineRule = this.sb.createRule((Symbolizer)this.sb.createLineSymbolizer(Color.BLUE, 1.0));
        this.visitor = new DynamicSizeStyleExtractor();
    }

    @Test
    public void testOneFtsFullyStatic() {
        Style style = this.sb.createStyle();
        FeatureTypeStyle fts = this.sb.createFeatureTypeStyle("Feature", this.staticPolygonRule);
        fts.rules().add(this.staticLineRule);
        style.featureTypeStyles().add(fts);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertNull((Object)copy);
    }

    @Test
    public void testTwoFtsFullyStatic() {
        Style style = this.sb.createStyle();
        FeatureTypeStyle fts1 = this.sb.createFeatureTypeStyle("Feature", this.staticPolygonRule);
        FeatureTypeStyle fts2 = this.sb.createFeatureTypeStyle("Feature", this.staticLineRule);
        style.featureTypeStyles().add(fts1);
        style.featureTypeStyles().add(fts2);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertNull((Object)copy);
    }

    @Test
    public void testMixDynamicStroke() {
        Style style = this.sb.createStyle();
        FeatureTypeStyle fts1 = this.sb.createFeatureTypeStyle("Feature", this.staticPolygonRule);
        LineSymbolizer ls = this.sb.createLineSymbolizer();
        ls.getStroke().setWidth((Expression)this.sb.getFilterFactory().property("myAttribute"));
        FeatureTypeStyle fts2 = this.sb.createFeatureTypeStyle((Symbolizer)ls);
        style.featureTypeStyles().add(fts1);
        style.featureTypeStyles().add(fts2);
        this.checkSingleSymbolizer(style, ls);
    }

    @Test
    public void testMultipleSymbolizers() {
        Style style = this.sb.createStyle();
        LineSymbolizer ls = this.sb.createLineSymbolizer();
        ls.getStroke().setWidth((Expression)this.sb.getFilterFactory().property("myAttribute"));
        FeatureTypeStyle fts = this.sb.createFeatureTypeStyle((Symbolizer)this.sb.createPolygonSymbolizer());
        style.featureTypeStyles().add(fts);
        ((Rule)fts.rules().get(0)).symbolizers().add(ls);
        ((Rule)fts.rules().get(0)).symbolizers().add(this.sb.createLineSymbolizer());
        this.checkSingleSymbolizer(style, ls);
    }

    private void checkSingleSymbolizer(Style style, LineSymbolizer ls) {
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertNotNull((Object)copy);
        List featureTypeStyles = copy.featureTypeStyles();
        Assert.assertEquals((long)1L, (long)featureTypeStyles.size());
        List rules = ((FeatureTypeStyle)featureTypeStyles.get(0)).rules();
        Assert.assertEquals((long)1L, (long)rules.size());
        List symbolizers = ((Rule)rules.get(0)).symbolizers();
        Assert.assertEquals((long)1L, (long)symbolizers.size());
        Assert.assertEquals((Object)ls, symbolizers.get(0));
    }

    @Test
    public void testMixDynamicGraphicStroke() {
        Style style = this.sb.createStyle();
        FeatureTypeStyle fts1 = this.sb.createFeatureTypeStyle("Feature", this.staticPolygonRule);
        Graphic graphic = this.sb.createGraphic(null, this.sb.createMark("square"), null);
        graphic.setSize((Expression)this.sb.getFilterFactory().property("myAttribute"));
        LineSymbolizer ls = this.sb.createLineSymbolizer();
        ls.getStroke().setGraphicStroke((org.opengis.style.Graphic)graphic);
        FeatureTypeStyle fts2 = this.sb.createFeatureTypeStyle((Symbolizer)ls);
        style.featureTypeStyles().add(fts1);
        style.featureTypeStyles().add(fts2);
        this.checkSingleSymbolizer(style, ls);
    }

    @Test
    public void testDynamicSymbolizerStrokeLineSymbolizer() {
        ExternalGraphic dynamicSymbolizer = this.sb.createExternalGraphic("file://./${myAttribute}.jpeg", "image/jpeg");
        Graphic graphic = this.sb.createGraphic(dynamicSymbolizer, null, null);
        LineSymbolizer ls = this.sb.createLineSymbolizer();
        ls.getStroke().setGraphicStroke((org.opengis.style.Graphic)graphic);
        Style style = this.sb.createStyle((Symbolizer)ls);
        this.checkSingleSymbolizer(style, ls);
    }

    @Test
    public void testStaticGraphicLineSymbolizer() {
        ExternalGraphic dynamicSymbolizer = this.sb.createExternalGraphic("file://./hello.jpeg", "image/jpeg");
        Graphic graphic = this.sb.createGraphic(dynamicSymbolizer, null, null);
        LineSymbolizer ls = this.sb.createLineSymbolizer();
        ls.getStroke().setGraphicStroke((org.opengis.style.Graphic)graphic);
        Style style = this.sb.createStyle((Symbolizer)ls);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertNull((Object)copy);
    }

    @Test
    public void testDynamicStrokeInGraphicMark() {
        org.geotools.styling.Stroke markStroke = this.sb.createStroke();
        markStroke.setWidth((Expression)this.sb.getFilterFactory().property("myAttribute"));
        Mark mark = this.sb.createMark("square");
        mark.setStroke((Stroke)markStroke);
        Graphic graphic = this.sb.createGraphic(null, mark, null);
        LineSymbolizer ls = this.sb.createLineSymbolizer();
        ls.getStroke().setGraphicStroke((org.opengis.style.Graphic)graphic);
        Style style = this.sb.createStyle((Symbolizer)ls);
        this.checkSingleSymbolizer(style, ls);
    }

    @Test
    public void testDynamicStrokeInGraphicFill() {
        org.geotools.styling.Stroke markStroke = this.sb.createStroke();
        markStroke.setWidth((Expression)this.sb.getFilterFactory().property("myAttribute"));
        Mark mark = this.sb.createMark("square");
        mark.setStroke((Stroke)markStroke);
        Graphic graphic = this.sb.createGraphic(null, mark, null);
        PolygonSymbolizer ps = this.sb.createPolygonSymbolizer();
        ps.getFill().setGraphicFill((org.opengis.style.Graphic)graphic);
        Style style = this.sb.createStyle((Symbolizer)ps);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertNull((Object)copy);
    }
}

