/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.io.Serializable;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RasterCustomDimensionDefaultValueTest
extends WMSTestSupport {
    private static final QName WATTEMP_CUSTOM = new QName(MockData.SF_URI, "watertemp_custom", MockData.SF_PREFIX);
    private static final String COVERAGE_DIMENSION_NAME = "MY_DIMENSION";
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setup() throws Exception {
        this.wms = this.getWMS();
        ((SystemTestData)testData).addRasterLayer(WATTEMP_CUSTOM, "custwatertemp.zip", null, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testDefaultCustomDimValueVectorSelector() throws Exception {
        this.setupCoverageMyDimension(WATTEMP_CUSTOM, null);
        CoverageInfo customCoverage = this.getCatalog().getCoverageByName(WATTEMP_CUSTOM.getLocalPart());
        String expected = "CustomDimValueA";
        String def = (String)this.wms.getDefaultCustomDimensionValue(COVERAGE_DIMENSION_NAME, (ResourceInfo)customCoverage, String.class);
        Assert.assertTrue((String)"Default dimension value is null", (def != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default dimension value should be the smallest one", (boolean)expected.equals(def));
    }

    @Test
    public void testExplicitMinCustomDimValueVectorSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.setupCoverageMyDimension(WATTEMP_CUSTOM, defaultValueSetting);
        CoverageInfo customCoverage = this.getCatalog().getCoverageByName(WATTEMP_CUSTOM.getLocalPart());
        String expected = "CustomDimValueA";
        String def = (String)this.wms.getDefaultCustomDimensionValue(COVERAGE_DIMENSION_NAME, (ResourceInfo)customCoverage, String.class);
        Assert.assertTrue((String)"Default dimension value is null", (def != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default dimension value should be the smallest one", (boolean)expected.equals(def));
    }

    @Test
    public void testExplicitMaxCustomDimValueVectorSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.setupCoverageMyDimension(WATTEMP_CUSTOM, defaultValueSetting);
        CoverageInfo customCoverage = this.getCatalog().getCoverageByName(WATTEMP_CUSTOM.getLocalPart());
        String expected = "CustomDimValueC";
        String def = (String)this.wms.getDefaultCustomDimensionValue(COVERAGE_DIMENSION_NAME, (ResourceInfo)customCoverage, String.class);
        Assert.assertTrue((String)"Default dimension value is null", (def != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default dimension value should be the biggest one", (boolean)expected.equals(def));
    }

    @Test
    public void testExplicitNearestToGivenValueCustomDimValueVectorSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        String referenceValue = "CustomDimValueD";
        defaultValueSetting.setReferenceValue(referenceValue);
        this.setupCoverageMyDimension(WATTEMP_CUSTOM, defaultValueSetting);
        CoverageInfo customCoverage = this.getCatalog().getCoverageByName(WATTEMP_CUSTOM.getLocalPart());
        String expected = "CustomDimValueC";
        String def = (String)this.wms.getDefaultCustomDimensionValue(COVERAGE_DIMENSION_NAME, (ResourceInfo)customCoverage, String.class);
        Assert.assertTrue((String)"Default dimension value is null", (def != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default dimension value should be the closest one", (boolean)expected.equals(def));
    }

    protected void setupCoverageMyDimension(QName name, DimensionDefaultValueSetting defaultValue) {
        CoverageInfo info = this.getCatalog().getCoverageByName(name.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(DimensionPresentation.LIST);
        di.setDefaultValue(defaultValue);
        info.getMetadata().put("custom_dimension_MY_DIMENSION", (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }
}

