/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class DimensionInfoSerializationTest
extends WMSTestSupport {
    @Test
    public void testMinStrategyXMLSerialization() throws Exception {
        this.assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy.MINIMUM);
    }

    @Test
    public void testMaxStrategyXMLSerialization() throws Exception {
        this.assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy.MAXIMUM);
    }

    @Test
    public void testFixedStrategyXMLSerialization() throws Exception {
        this.assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy.FIXED);
        this.assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy.FIXED, "2014-01-24T13:25:00.000Z");
    }

    @Test
    public void testNearestStrategyXMLSerialization() throws Exception {
        this.assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy.NEAREST);
        this.assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy.NEAREST, "2014-01-24T13:25:00.000Z");
    }

    protected void assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy used) throws Exception {
        this.assertBackAndForthSerialization(used, null);
    }

    protected void assertBackAndForthSerialization(DimensionDefaultValueSetting.Strategy used, String referenceValue) throws Exception {
        DimensionInfo di2;
        DimensionDefaultValueSetting setting = new DimensionDefaultValueSetting();
        setting.setStrategyType(used);
        if (referenceValue != null) {
            setting.setReferenceValue(referenceValue);
        }
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setDefaultValue(setting);
        Document diDOM = this.marshallToXML((DimensionInfo)di);
        XMLAssert.assertXpathExists((String)"//defaultValue/strategy", (Document)diDOM);
        XMLAssert.assertXpathEvaluatesTo((String)used.name(), (String)"//defaultValue/strategy", (Document)diDOM);
        if (referenceValue != null) {
            XMLAssert.assertXpathExists((String)"//defaultValue/referenceValue", (Document)diDOM);
            XMLAssert.assertXpathEvaluatesTo((String)referenceValue, (String)"//defaultValue/referenceValue", (Document)diDOM);
        }
        Assert.assertTrue((String)"Unmarshalled strategy does not match the original one", ((di2 = this.unmarshallFromXML(diDOM)).getDefaultValue().getStrategyType() == used ? 1 : 0) != 0);
        if (referenceValue != null) {
            Assert.assertTrue((String)"Unmarshalled referenceValue does not match the original one", (boolean)di2.getDefaultValue().getReferenceValue().equals(referenceValue));
        }
    }

    protected Document marshallToXML(DimensionInfo di) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XStreamPersisterFactory xpf = (XStreamPersisterFactory)GeoServerExtensions.bean(XStreamPersisterFactory.class);
        XStreamPersister persister = xpf.createXMLPersister();
        persister.save((Object)di, (OutputStream)baos);
        baos.flush();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(baos.toByteArray()));
    }

    protected DimensionInfo unmarshallFromXML(Document doc) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        transformer.transform(source, result);
        XStreamPersisterFactory xpf = (XStreamPersisterFactory)GeoServerExtensions.bean(XStreamPersisterFactory.class);
        XStreamPersister persister = xpf.createXMLPersister();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return (DimensionInfo)persister.load((InputStream)bais, DimensionInfo.class);
    }
}

