/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedImageList;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.animate.FrameCatalog;
import org.geoserver.wms.animate.FrameCatalogVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class AnimatorTest
extends WMSTestSupport {
    public static final String GIF_ANIMATED_FORMAT = "image/gif;subtype=animated";

    @Test
    public void testFrameCatalog() throws Exception {
        WebMapService wms = (WebMapService)applicationContext.getBean("wmsService2");
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName(layerName));
        FrameCatalog catalog = null;
        try {
            catalog = new FrameCatalog(getMapRequest, wms, this.getWMS());
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Missing \"animator\" mandatory params \"aparam\" and \"avalues\".", (Object)e.getLocalizedMessage());
        }
        getMapRequest.getRawKvp().put("aparam", "fake_param");
        getMapRequest.getRawKvp().put("avalues", "val0,val\\,1,val2\\,\\,,val3");
        catalog = new FrameCatalog(getMapRequest, wms, this.getWMS());
        Assert.assertNotNull((Object)catalog);
        Assert.assertEquals((Object)"fake_param", (Object)catalog.getParameter());
        Assert.assertEquals((long)4L, (long)catalog.getValues().length);
        Assert.assertEquals((Object)"val0", (Object)catalog.getValues()[0]);
        Assert.assertEquals((Object)"val\\,1", (Object)catalog.getValues()[1]);
        Assert.assertEquals((Object)"val2\\,\\,", (Object)catalog.getValues()[2]);
        Assert.assertEquals((Object)"val3", (Object)catalog.getValues()[3]);
    }

    @Test
    public void testFrameVisitor() throws Exception {
        WebMapService wms = (WebMapService)applicationContext.getBean("wmsService2");
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName(layerName));
        FrameCatalog catalog = null;
        getMapRequest.getRawKvp().put("aparam", "fake_param");
        getMapRequest.getRawKvp().put("avalues", "val0,val\\,1,val2\\,\\,,val3");
        getMapRequest.getRawKvp().put("format", GIF_ANIMATED_FORMAT);
        getMapRequest.getRawKvp().put("LAYERS", layerName);
        catalog = new FrameCatalog(getMapRequest, wms, this.getWMS());
        Assert.assertNotNull((Object)catalog);
        FrameCatalogVisitor visitor = new FrameCatalogVisitor();
        catalog.getFrames(visitor);
        Assert.assertEquals((long)4L, (long)visitor.framesNumber);
        RenderedImageList frames = visitor.produce(this.getWMS());
        Assert.assertNotNull((Object)frames);
        Assert.assertEquals((long)4L, (long)frames.size());
    }

    @Test
    public void testAnimator() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestURL = "wms/animate?layers=" + layerName + "&aparam=fake_param&avalues=val0,val\\,1,val2\\,\\,,val3";
        this.checkAnimatedGif(requestURL, false, "none");
        this.checkAnimatedGif(requestURL + "&format_options=gif_loop_continuously:true", true, "none");
        this.checkAnimatedGif(requestURL + "&format_options=gif_loop_continuosly:true", true, "none");
        for (String disposal : WMS.DISPOSAL_METHODS) {
            this.checkAnimatedGif(requestURL + "&format_options=gif_disposal:" + disposal, false, disposal);
        }
    }

    private void checkAnimatedGif(String requestURL, boolean loopContinously, String disposal) throws Exception, IOException {
        MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
        Assert.assertEquals((Object)"image/gif", (Object)resp.getContentType());
        try (ImageInputStream is = ImageIO.createImageInputStream(this.getBinaryInputStream(resp));){
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            reader.setInput(is);
            Assert.assertEquals((long)4L, (long)reader.getNumImages(true));
            IIOMetadata imageMetadata = reader.getImageMetadata(0);
            LOGGER.info(Arrays.toString(imageMetadata.getMetadataFormatNames()));
            IIOMetadataNode node = (IIOMetadataNode)imageMetadata.getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode nodeGCE = (IIOMetadataNode)node.getElementsByTagName("GraphicControlExtension").item(0);
            if (disposal == "backgroundColor") {
                disposal = "restoreToBackgroundColor";
            } else if (disposal == "previous") {
                disposal = "restoreToPrevious";
            }
            Assert.assertEquals((Object)disposal, (Object)nodeGCE.getAttribute("disposalMethod").toString());
            NodeList nodes = node.getElementsByTagName("ApplicationExtensions");
            node = (IIOMetadataNode)nodes.item(0);
            nodes = node.getElementsByTagName("ApplicationExtension");
            boolean found = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = (IIOMetadataNode)nodes.item(i);
                if (!"NETSCAPE".equals(node.getAttribute("applicationID")) || !"2.0".equals(node.getAttribute("authenticationCode"))) continue;
                found = true;
                byte[] flags = (byte[])node.getUserObject();
                if (loopContinously) {
                    Assert.assertArrayEquals((byte[])new byte[]{1, 0, 0}, (byte[])flags);
                    continue;
                }
                Assert.assertArrayEquals((byte[])new byte[]{1, 1, 0}, (byte[])flags);
            }
            if (!found) {
                Assert.fail((String)"Could not find custom metadata node containing the loop control extension");
            }
        }
    }

    private void print(String prefix, IIOMetadataNode node) {
        Object user = node.getUserObject();
        System.out.println(prefix + node.getNodeName() + ": " + node.getNodeValue() + ", " + (user instanceof byte[] ? Arrays.toString((byte[])user) : user));
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.print(prefix + "Attribute ", (IIOMetadataNode)attributes.item(i));
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.print("  " + prefix, (IIOMetadataNode)children.item(i));
        }
    }

    @Test
    public void testAnimatorLayers() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestURL = "cite/wms/animate?&aparam=layers&avalues=MapNeatline,Buildings,Lakes";
        MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
        Assert.assertEquals((Object)"image/gif", (Object)resp.getContentType());
        ByteArrayInputStream bis = this.getBinaryInputStream(resp);
        ImageInputStream iis = ImageIO.createImageInputStream(bis);
        ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
        reader.setInput(iis);
        Assert.assertEquals((long)3L, (long)reader.getNumImages(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnimatorLayerGroups() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo singleGroup = this.createLakesPlacesLayerGroup(catalog, "singleGroup", LayerGroupInfo.Mode.SINGLE, null);
        try {
            LayerGroupInfo namedGroup = this.createLakesPlacesLayerGroup(catalog, "namedGroup", LayerGroupInfo.Mode.NAMED, null);
            try {
                LayerGroupInfo eoGroup = this.createLakesPlacesLayerGroup(catalog, "eoGroup", LayerGroupInfo.Mode.EO, catalog.getLayerByName(this.getLayerId(MockData.LAKES)));
                try {
                    String requestURL = "wms/animate?BBOX=0.0000,-0.0020,0.0035,0.0010&width=512&aparam=layers&avalues=" + singleGroup.getName() + "," + namedGroup.getName() + "," + eoGroup.getName();
                    MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
                    Assert.assertEquals((Object)"image/gif", (Object)resp.getContentType());
                    ByteArrayInputStream bis = this.getBinaryInputStream(resp);
                    ImageInputStream iis = ImageIO.createImageInputStream(bis);
                    ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
                    reader.setInput(iis);
                    Assert.assertEquals((long)3L, (long)reader.getNumImages(true));
                    BufferedImage image = reader.read(0);
                    this.assertPixel(image, 300, 270, Color.WHITE);
                    this.assertPixel(image, 380, 30, COLOR_PLACES_GRAY);
                    this.assertPixel(image, 180, 350, COLOR_LAKES_BLUE);
                    image = reader.read(1);
                    this.assertPixel(image, 300, 270, Color.WHITE);
                    this.assertPixel(image, 380, 30, COLOR_PLACES_GRAY);
                    this.assertPixel(image, 180, 350, COLOR_LAKES_BLUE);
                    image = reader.read(2);
                    this.assertPixel(image, 300, 270, Color.WHITE);
                    this.assertPixel(image, 380, 30, Color.WHITE);
                    this.assertPixel(image, 180, 350, COLOR_LAKES_BLUE);
                }
                finally {
                    catalog.remove(eoGroup);
                }
            }
            finally {
                catalog.remove(namedGroup);
            }
        }
        finally {
            catalog.remove(singleGroup);
        }
    }
}

