/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMapService;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.FeatureSource;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class WMSTestSupport
extends GeoServerSystemTestSupport {
    protected static final String NATURE_GROUP = "nature";
    protected static final String CONTAINER_GROUP = "containerGroup";
    protected static final String OPAQUE_GROUP = "opaqueGroup";
    protected static final int SHOW_TIMEOUT = 2000;
    protected static final boolean INTERACTIVE = false;
    protected static final Color BG_COLOR = Color.white;
    protected static final Color COLOR_PLACES_GRAY = new Color(170, 170, 170);
    protected static final Color COLOR_LAKES_BLUE = new Color(64, 64, 192);

    protected WMS getWMS() {
        WMS wms = (WMS)applicationContext.getBean("wms");
        return wms;
    }

    protected WebMapService getWebMapService() {
        return (WebMapService)applicationContext.getBean("webMapService");
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("wcs", "http://www.opengis.net/wcs/1.1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("sf", "http://cite.opengeospatial.org/gmlsf");
        namespaces.put("kml", "http://www.opengis.net/kml/2.2");
        SystemTestData.registerNamespaces(namespaces);
        this.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        testData.setUpRasterLayer(MockData.WORLD, "world.tiff", null, null, TestData.class);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forests = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        if (lakes != null && forests != null) {
            group.setName(NATURE_GROUP);
            group.getLayers().add(lakes);
            group.getLayers().add(forests);
            group.getStyles().add(null);
            group.getStyles().add(null);
            CatalogBuilder cb = new CatalogBuilder(catalog);
            cb.calculateLayerGroupBounds(group);
            catalog.add(group);
        }
        testData.addStyle("default", "Default.sld", MockData.class, catalog);
        LayerGroupInfo containerGroup = catalog.getFactory().createLayerGroup();
        LayerGroupInfo nature = catalog.getLayerGroupByName(NATURE_GROUP);
        if (nature != null) {
            containerGroup.setName(CONTAINER_GROUP);
            containerGroup.setMode(LayerGroupInfo.Mode.CONTAINER);
            containerGroup.getLayers().add(nature);
            containerGroup.getStyles().add(null);
            CatalogBuilder cb = new CatalogBuilder(catalog);
            cb.calculateLayerGroupBounds(containerGroup);
            catalog.add(containerGroup);
        }
    }

    protected void setupOpaqueGroup(Catalog catalog) throws Exception {
        LayerGroupInfo opaqueGroup = catalog.getFactory().createLayerGroup();
        LayerInfo roadSegments = catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS));
        LayerInfo neatline = catalog.getLayerByName(this.getLayerId(MockData.MAP_NEATLINE));
        if (roadSegments != null && neatline != null) {
            opaqueGroup.setName(OPAQUE_GROUP);
            opaqueGroup.setMode(LayerGroupInfo.Mode.OPAQUE_CONTAINER);
            opaqueGroup.getLayers().add(roadSegments);
            opaqueGroup.getLayers().add(neatline);
            opaqueGroup.getStyles().add(null);
            opaqueGroup.getStyles().add(null);
            CatalogBuilder cb = new CatalogBuilder(catalog);
            cb.calculateLayerGroupBounds(opaqueGroup);
            catalog.add(opaqueGroup);
        }
    }

    protected void registerNamespaces(Map<String, String> namespaces) {
    }

    protected Layer createMapLayer(QName layerName) throws IOException {
        return this.createMapLayer(layerName, null);
    }

    protected Layer createMapLayer(QName layerName, String styleName) throws IOException {
        Catalog catalog = this.getCatalog();
        LayerInfo layerInfo = catalog.getLayerByName(layerName.getLocalPart());
        Style style = layerInfo.getDefaultStyle().getStyle();
        if (styleName != null) {
            style = catalog.getStyleByName(styleName).getStyle();
        }
        FeatureTypeInfo info = catalog.getFeatureTypeByName(layerName.getPrefix(), layerName.getLocalPart());
        FeatureLayer layer = null;
        if (info != null) {
            FeatureSource featureSource = info.getFeatureSource(null, null);
            layer = new FeatureLayer(featureSource, style);
        } else {
            CoverageInfo cinfo = catalog.getCoverageByName(layerName.getNamespaceURI(), layerName.getLocalPart());
            GridCoverage2D cov = (GridCoverage2D)cinfo.getGridCoverage(null, null);
            layer = new GridCoverageLayer(cov, style);
        }
        if (layer == null) {
            throw new IllegalArgumentException("Could not find layer for " + layerName);
        }
        layer.setTitle(layerInfo.getTitle());
        return layer;
    }

    protected GetMapRequest createGetMapRequest(QName layerName) {
        return this.createGetMapRequest(new QName[]{layerName});
    }

    protected GetMapRequest createGetMapRequest(QName[] layerNames) {
        GetMapRequest request = new GetMapRequest();
        request.setBaseUrl("http://localhost:8080/geoserver");
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>(layerNames.length);
        ArrayList<Style> styles = new ArrayList<Style>();
        for (int i = 0; i < layerNames.length; ++i) {
            LayerInfo layerInfo = this.getCatalog().getLayerByName(layerNames[i].getLocalPart());
            try {
                styles.add(layerInfo.getDefaultStyle().getStyle());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            layers.add(new MapLayerInfo(layerInfo));
        }
        request.setLayers(layers);
        request.setStyles(styles);
        request.setBbox(new Envelope(-180.0, -90.0, 180.0, 90.0));
        request.setCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        request.setSRS("EPSG:4326");
        request.setRawKvp(new HashMap());
        return request;
    }

    protected void assertNotBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = this.countNonBlankPixels(testName, image, bgColor);
        Assert.assertTrue((String)(testName + " image is comlpetely blank"), (0 < pixelsDiffer ? 1 : 0) != 0);
    }

    protected void assertBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = this.countNonBlankPixels(testName, image, bgColor);
        Assert.assertEquals((String)(testName + " image is completely blank"), (long)0L, (long)pixelsDiffer);
    }

    protected int countNonBlankPixels(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getRGB(x, y) == bgColor.getRGB()) continue;
                ++pixelsDiffer;
            }
        }
        LOGGER.fine(testName + ": pixel count=" + image.getWidth() * image.getHeight() + " non bg pixels: " + pixelsDiffer);
        return pixelsDiffer;
    }

    public static Document transform(Object req, TransformerBase tr) throws Exception {
        return WMSTestSupport.transform(req, tr, true);
    }

    public static Document transform(Object req, TransformerBase tr, boolean namespaceAware) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        tr.transform(req, (OutputStream)out);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaceAware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        class EmptyResolver
        implements EntityResolver {
            EmptyResolver() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                InputSource source = new InputSource(reader);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
        }
        db.setEntityResolver(new EmptyResolver());
        Document doc = db.parse(new ByteArrayInputStream(out.toByteArray()));
        return doc;
    }

    protected void assertNotBlank(String testName, BufferedImage image) {
        this.assertNotBlank(testName, image, BG_COLOR);
        WMSTestSupport.showImage(testName, image);
    }

    protected void assertBlank(String testName, BufferedImage image) {
        this.assertBlank(testName, image, BG_COLOR);
        WMSTestSupport.showImage(testName, image);
    }

    public static void showImage(String frameName, BufferedImage image) {
        WMSTestSupport.showImage(frameName, 2000L, image);
    }

    public static void showImage(String frameName, long timeOut, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (System.getProperty("java.awt.headless") == null || !System.getProperty("java.awt.headless").equals("true")) {
            // empty if block
        }
    }

    protected void checkImage(MockHttpServletResponse response) {
        this.checkImage(response, "image/png", -1, -1);
    }

    protected void checkImage(MockHttpServletResponse response, String mimeType, int width, int height) {
        try {
            if (response.getContentType().contains("text")) {
                Assert.assertEquals((String)response.getContentAsString(), (Object)mimeType, (Object)response.getContentType());
            } else {
                Assert.assertEquals((Object)mimeType, (Object)response.getContentType());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
            Assert.assertNotNull((Object)image);
            if (width > 0) {
                Assert.assertEquals((long)width, (long)image.getWidth());
            }
            if (height > 0) {
                Assert.assertEquals((long)height, (long)image.getHeight());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            TestCase.fail((String)("Could not read image returned from GetMap:" + t.getLocalizedMessage()));
        }
    }

    protected void setupTemplate(QName featureTypeName, String template, String body) throws IOException {
        ResourceInfo info = this.getCatalog().getResourceByName(this.toName(featureTypeName), ResourceInfo.class);
        this.getDataDirectory().copyToResourceDir(info, (InputStream)new ByteArrayInputStream(body.getBytes()), template);
    }

    protected LayerGroupInfo createLakesPlacesLayerGroup(Catalog catalog, LayerGroupInfo.Mode mode, LayerInfo rootLayer) throws Exception {
        return this.createLakesPlacesLayerGroup(catalog, "lakes_and_places", mode, rootLayer);
    }

    protected LayerGroupInfo createLakesPlacesLayerGroup(Catalog catalog, String name, LayerGroupInfo.Mode mode, LayerInfo rootLayer) throws Exception {
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo places = catalog.getLayerByName(this.getLayerId(MockData.NAMED_PLACES));
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        group.setName(name);
        group.setMode(mode);
        if (rootLayer != null) {
            group.setRootLayer(rootLayer);
            group.setRootLayerStyle(rootLayer.getDefaultStyle());
        }
        group.getLayers().add(lakes);
        group.getLayers().add(places);
        group.getStyles().add(null);
        group.getStyles().add(null);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.calculateLayerGroupBounds(group);
        catalog.add(group);
        return group;
    }

    protected int getRawTopLayerCount() {
        Catalog rawCatalog = (Catalog)GeoServerExtensions.bean((String)"rawCatalog");
        ArrayList layers = new ArrayList(rawCatalog.getLayers());
        ListIterator it = layers.listIterator();
        while (it.hasNext()) {
            LayerInfo next = (LayerInfo)it.next();
            if (next.enabled() && !next.getName().equals(MockData.GEOMETRYLESS.getLocalPart())) continue;
            it.remove();
        }
        List groups = rawCatalog.getLayerGroups();
        int opaqueDelta = groups.stream().anyMatch(lg -> OPAQUE_GROUP.equals(lg.getName())) ? 2 : 0;
        int expectedLayerCount = layers.size() + groups.size() - 1 - opaqueDelta;
        return expectedLayerCount;
    }

    protected void checkWms13ValidationErrors(Document dom) throws Exception {
        Parser p = new Parser((Configuration)Class.forName("org.geotools.wms.v1_3.WMSConfiguration").newInstance());
        p.setValidating(true);
        p.parse((Source)new DOMSource(dom));
        if (!p.getValidationErrors().isEmpty()) {
            for (SAXParseException ex : p.getValidationErrors()) {
                System.out.println(ex.getLineNumber() + "," + ex.getColumnNumber() + " -" + ex.toString());
            }
            TestCase.fail((String)"Document did not validate.");
        }
    }

    public static void checkNumberSimilar(String rawValue, double expected, double precision) {
        Assert.assertThat((Object)rawValue, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)rawValue.trim().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        double value = 0.0;
        try {
            value = Double.parseDouble(rawValue);
        }
        catch (NumberFormatException exception) {
            Assert.fail((String)String.format("Value '%s' is not a number.", rawValue));
        }
        double difference = Math.abs(expected - value);
        Assert.assertThat((Object)(difference <= precision ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }
}

