/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class WMSMockData {
    public static final String TEST_NS_PREFIX = "geos";
    public static final String TEST_NAMESPACE = "http://geoserver.org";
    private CatalogImpl catalog;
    private MemoryDataStore dataStore;
    private DataStoreInfo dataStoreInfo;
    private NamespaceInfoImpl namespaceInfo;
    private WorkspaceInfoImpl workspaceInfo;
    private StyleInfoImpl defaultStyle;
    private GetMapOutputFormat mockMapProducer;
    private GeoServer mockGeoServer;
    private WMS mockWMS;

    public void setUp() throws Exception {
        this.mockMapProducer = new DummyRasterMapProducer();
        this.catalog = new CatalogImpl();
        this.namespaceInfo = new NamespaceInfoImpl();
        this.namespaceInfo.setId("testNs");
        this.namespaceInfo.setPrefix(TEST_NS_PREFIX);
        this.namespaceInfo.setURI(TEST_NAMESPACE);
        this.catalog.add((NamespaceInfo)this.namespaceInfo);
        this.workspaceInfo = new WorkspaceInfoImpl();
        this.workspaceInfo.setName("testWs");
        this.catalog.add((WorkspaceInfo)this.workspaceInfo);
        this.catalog.setDefaultWorkspace((WorkspaceInfo)this.workspaceInfo);
        this.defaultStyle = new StyleInfoImpl((Catalog)this.catalog){

            public Style getStyle() throws IOException {
                StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
                Style style = styleFactory.createStyle();
                style.setName("Default Style");
                return style;
            }
        };
        this.defaultStyle.setFilename("defaultStyleFileName");
        this.defaultStyle.setId("defaultStyleId");
        this.defaultStyle.setName("defaultStyleName");
        this.catalog.add((StyleInfo)this.defaultStyle);
        this.dataStoreInfo = new DataStoreInfoImpl((Catalog)this.catalog);
        this.dataStoreInfo.setName("mockDataStore");
        this.dataStoreInfo.setEnabled(true);
        this.dataStoreInfo.setWorkspace((WorkspaceInfo)this.workspaceInfo);
        this.dataStore = new MemoryDataStore();
        this.dataStore.setNamespaceURI(TEST_NAMESPACE);
        ResourcePool resourcePool = new ResourcePool((Catalog)this.catalog){

            public DataStore getDataStore(DataStoreInfo info) throws IOException {
                return WMSMockData.this.dataStore;
            }
        };
        this.catalog.setResourcePool(resourcePool);
        this.mockGeoServer = new GeoServerImpl();
        this.mockGeoServer.setCatalog((Catalog)this.catalog);
        GeoServerInfoImpl geoserverInfo = new GeoServerInfoImpl(this.mockGeoServer);
        geoserverInfo.setId("geoserver");
        this.mockGeoServer.setGlobal((GeoServerInfo)geoserverInfo);
        WMSInfoImpl wmsInfo = new WMSInfoImpl();
        wmsInfo.setId("wms");
        wmsInfo.setName("WMS");
        wmsInfo.setEnabled(true);
        this.mockGeoServer.add((ServiceInfo)wmsInfo);
        this.mockWMS = new WMS(this.mockGeoServer);
    }

    public WMS getWMS() {
        return this.mockWMS;
    }

    public StyleInfo getDefaultStyle() {
        return this.defaultStyle;
    }

    public GetMapRequest createRequest() {
        GetMapRequest request = new GetMapRequest();
        request.setFormat("image/dummy");
        request.setWidth(512);
        request.setHeight(256);
        Envelope envelope = new Envelope(-180.0, 180.0, -90.0, 90.0);
        request.setBbox(envelope);
        request.setSRS("EPSG:4326");
        request.setCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        try {
            request.setStyles(Collections.singletonList(this.defaultStyle.getStyle()));
        }
        catch (IOException e) {
            throw new RuntimeException("shouldn't happen", e);
        }
        request.setRawKvp(new HashMap());
        request.setBaseUrl("http://example.geoserver.org/geoserver");
        return request;
    }

    public MapLayerInfo addFeatureTypeLayer(String name, Class<? extends Geometry> geometryType) throws IOException {
        MemoryDataStore dataStore = this.dataStore;
        FeatureTypeInfoImpl featureTypeInfo = new FeatureTypeInfoImpl((Catalog)this.catalog, (DataStore)dataStore){
            final /* synthetic */ DataStore val$dataStore;
            {
                this.val$dataStore = dataStore;
                super(x0);
            }

            public FeatureSource getFeatureSource(ProgressListener listener, Hints hints) {
                try {
                    return this.val$dataStore.getFeatureSource(this.getQualifiedName());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        featureTypeInfo.setName(name);
        featureTypeInfo.setNativeName(name);
        featureTypeInfo.setEnabled(true);
        DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)wgs84);
        featureTypeInfo.setLatLonBoundingBox(bbox);
        featureTypeInfo.setNamespace((NamespaceInfo)this.namespaceInfo);
        featureTypeInfo.setNativeBoundingBox(bbox);
        featureTypeInfo.setNativeCRS((CoordinateReferenceSystem)wgs84);
        featureTypeInfo.setSRS("EPSG:4326");
        featureTypeInfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        featureTypeInfo.setStore((StoreInfo)this.dataStoreInfo);
        this.catalog.add((ResourceInfo)featureTypeInfo);
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setResource((ResourceInfo)featureTypeInfo);
        layerInfo.setName(name);
        layerInfo.setEnabled(true);
        layerInfo.setDefaultStyle((StyleInfo)this.defaultStyle);
        layerInfo.setType(PublishedType.VECTOR);
        this.catalog.add((LayerInfo)layerInfo);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setNamespaceURI(TEST_NAMESPACE);
        ftb.setName(name);
        ftb.add("name", String.class);
        ftb.add("geom", geometryType, (CoordinateReferenceSystem)wgs84);
        SimpleFeatureType featureType = ftb.buildFeatureType();
        dataStore.createSchema((FeatureType)featureType);
        return new MapLayerInfo((LayerInfo)layerInfo);
    }

    public SimpleFeature addFeature(SimpleFeatureType featureType, Object[] values) throws IOException, ParseException {
        SimpleFeatureStore fs = (SimpleFeatureStore)this.dataStore.getFeatureSource(featureType.getName());
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(featureType);
        sfb.addAll(values);
        SimpleFeature feature = sfb.buildFeature(null);
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        return feature;
    }

    public GeoServer getGeoServer() {
        return this.mockGeoServer;
    }

    public static class DummyRasterMapProducer
    extends Response
    implements GetMapOutputFormat {
        public static final String MIME_TYPE = "image/dummy";
        public boolean produceMapCalled;
        public String outputFormat;
        public boolean writeToCalled;

        public DummyRasterMapProducer() {
            super(WebMap.class);
        }

        public Set<String> getOutputFormatNames() {
            return Collections.singleton(MIME_TYPE);
        }

        public String getMimeType() {
            return MIME_TYPE;
        }

        public WebMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
            this.produceMapCalled = true;
            return new WebMap(mapContent){};
        }

        public String getMimeType(Object value, Operation operation) throws ServiceException {
            return MIME_TYPE;
        }

        public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        }

        public MapProducerCapabilities getCapabilities(String format) {
            return new MapProducerCapabilities(true, true, true, true, MIME_TYPE);
        }
    }
}

