/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.SystemUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.renderer.style.FontCache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class WMSLifecycleHandlerTest
extends WMSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testOTFFontRegistration() throws IOException {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        FontCache fontCache = FontCache.getDefaultInstance();
        String fontName = "League Mono Regular";
        Assume.assumeThat((Object)fontCache.getFont(fontName), (Matcher)CoreMatchers.nullValue());
        Resource styles = this.getDataDirectory().get("styles");
        String fontFileName = "LeagueMono-Regular.otf";
        try (InputStream is = WMSLifecycleHandlerTest.class.getResourceAsStream(fontFileName);){
            Assert.assertNotNull((Object)is);
            Resources.copy((InputStream)is, (Resource)styles, (String)fontFileName);
        }
        this.getGeoServer().reset();
        Font theFont = fontCache.getFont(fontName);
        Assert.assertThat((String)fontCache.getAvailableFonts().toString(), (Object)theFont, (Matcher)CoreMatchers.notNullValue());
    }
}

