/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.junit.Before;

public abstract class WMSCascadeTestSupport
extends WMSTestSupport {
    protected static final String WORLD4326_130 = "world4326_130";
    protected static final String WORLD4326_110 = "world4326_110";
    protected static final String WORLD4326_110_NFI = "world4326_110_NFI";
    protected MockHttpClient wms13Client;
    protected URL wms13BaseURL;
    protected MockHttpClient wms11Client;
    protected URL wms11BaseURL;
    protected MockHttpClient wms11ClientNfi;
    protected URL wms11BaseNfiURL;
    protected XpathEngine xpath;

    @Before
    public void setupXpathEngine() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        this.setupWMS130Layer();
        this.setupWMS110Layer();
        this.setupWMS110NfiLayer();
    }

    private void setupWMS130Layer() throws MalformedURLException, IOException {
        this.wms13Client = new MockHttpClient();
        this.wms13BaseURL = new URL("http://mock.test.geoserver.org/wms13");
        URL capsDocument = WMSTestSupport.class.getResource("caps130.xml");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?service=WMS&request=GetCapabilities&version=1.3.0"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        URL pngImage = WMSTestSupport.class.getResource("world.png");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?service=WMS&version=1.3.0&request=GetMap&layers=world4326&styles&bbox=-90.0,-180.0,90.0,180.0&crs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=180&height=90"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        String caps = this.wms13BaseURL + "?service=WMS&request=GetCapabilities&version=1.3.0";
        TestHttpClientProvider.bind((HTTPClient)this.wms13Client, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-store-130");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("world4326");
        wmsLayer.setName(WORLD4326_130);
        this.getCatalog().add((ResourceInfo)wmsLayer);
        LayerInfo gsLayer = cb.buildLayer(wmsLayer);
        this.getCatalog().add(gsLayer);
    }

    private void setupWMS110Layer() throws MalformedURLException, IOException {
        this.wms11Client = new MockHttpClient();
        this.wms11BaseURL = new URL("http://mock.test.geoserver.org/wms11");
        URL capsDocument = WMSTestSupport.class.getResource("caps111.xml");
        this.wms11Client.expectGet(new URL(this.wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        URL pngImage = WMSTestSupport.class.getResource("world.png");
        this.wms11Client.expectGet(new URL(this.wms11BaseURL + "?service=WMS&version=1.1.1&request=GetMap&layers=world4326&styles&bbox=-180.0,-90.0,180.0,90.0&srs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=180&height=90"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        String caps = this.wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1";
        TestHttpClientProvider.bind((HTTPClient)this.wms11Client, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-store-110");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("world4326");
        wmsLayer.setName(WORLD4326_110);
        this.getCatalog().add((ResourceInfo)wmsLayer);
        LayerInfo gsLayer = cb.buildLayer(wmsLayer);
        this.getCatalog().add(gsLayer);
    }

    private void setupWMS110NfiLayer() throws MalformedURLException, IOException {
        this.wms11ClientNfi = new MockHttpClient();
        this.wms11BaseNfiURL = new URL("http://mock.test.geoserver.org/wms11_nfi");
        URL capsDocument = WMSTestSupport.class.getResource("caps111_no_feature_info.xml");
        this.wms11ClientNfi.expectGet(new URL(this.wms11BaseNfiURL + "?service=WMS&request=GetCapabilities&version=1.1.1"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        String caps = this.wms11BaseNfiURL + "?service=WMS&request=GetCapabilities&version=1.1.1";
        TestHttpClientProvider.bind((HTTPClient)this.wms11ClientNfi, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-store-110-nfi");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("world4326");
        wmsLayer.setName(WORLD4326_110_NFI);
        this.getCatalog().add((ResourceInfo)wmsLayer);
        LayerInfo gsLayer = cb.buildLayer(wmsLayer);
        this.getCatalog().add(gsLayer);
    }
}

