/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class ResourceAccessManagerWMSTest
extends WMSTestSupport {
    static final Logger LOGGER = Logging.getLogger(ResourceAccessManagerWMSTest.class);
    static final String BASE = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625";
    static final String GET_MAP = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetMap";
    static final String BASE_GET_FEATURE_INFO = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain";
    static final String GET_FEATURE_INFO_CALIFORNIA = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain&X=191&Y=178";
    static final String GET_FEATURE_INFO_TEXAS = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain&X=368&Y=227";

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wms/ResourceAccessManagerContext.xml");
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle("raster", "raster.sld", SystemTestData.class, this.getCatalog());
        HashMap<SystemTestData.LayerProperty, String> properties = new HashMap<SystemTestData.LayerProperty, String>();
        properties.put(SystemTestData.LayerProperty.STYLE, "raster");
        testData.addRasterLayer(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), "raster-filter-test.zip", null, properties, SystemTestData.class, this.getCatalog());
        GeoServerUserGroupStore ugStore = this.getSecurityManager().loadUserGroupService(AbstractUserGroupService.DEFAULT_NAME).createStore();
        ugStore.addUser(ugStore.createUserObject("cite", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_noinfo", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_nostates", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_texas", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_mosaic1", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_mosaic2", "cite", true));
        ugStore.store();
        GeoServerRoleStore roleStore = this.getSecurityManager().getActiveRoleService().createStore();
        GeoServerRole role = roleStore.createRoleObject("ROLE_DUMMY");
        roleStore.addRole(role);
        roleStore.associateRoleToUser(role, "cite");
        roleStore.associateRoleToUser(role, "cite_noinfo");
        roleStore.associateRoleToUser(role, "cite_nostates");
        roleStore.associateRoleToUser(role, "cite_cite_texas");
        roleStore.associateRoleToUser(role, "cite_mosaic1");
        roleStore.associateRoleToUser(role, "cite_mosaic2");
        roleStore.store();
        this.prepare();
    }

    public void prepare() throws Exception {
        Catalog catalog = this.getCatalog();
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        CoverageInfo coverage = catalog.getCoverageByName("sf:mosaic");
        Filter green = CQL.toFilter((String)"location like 'green%'");
        tam.putLimits("cite_mosaic1", (CatalogInfo)coverage, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, green, null, null));
        WKTReader wkt = new WKTReader();
        MultiPolygon cropper = (MultiPolygon)wkt.read("MULTIPOLYGON(((0 0, 0.5 0, 0.5 0.5, 0 0.5, 0 0)))");
        tam.putLimits("cite_mosaic2", (CatalogInfo)coverage, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, green, cropper, null));
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        CatalogBuilder cb = new CatalogBuilder(catalog);
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities");
        catalog.save((StoreInfo)wms);
        cb.setStore((StoreInfo)wms);
        WMSLayerInfo states = cb.buildWMSLayer("topp:states");
        states.setName("rstates");
        catalog.add((ResourceInfo)states);
        LayerInfo layer = cb.buildLayer(states);
        catalog.add(layer);
        tam.putLimits("cite_nostates", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, false));
        tam.putLimits("cite_noinfo", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.INCLUDE, null, false));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo texas = ff.equal((Expression)ff.property("STATE_NAME"), (Expression)ff.literal((Object)"Texas"), false);
        tam.putLimits("cite_texas", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)texas, null, true));
    }

    @Test
    public void testGetMapNoRestrictions() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.setRequestAuth("cite", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        this.assertNotBlank("testNoRestrictions", image);
        int[] pixel = new int[4];
        image.getData().getPixel(368, 227, pixel);
        Assert.assertEquals((long)130L, (long)pixel[0]);
        Assert.assertEquals((long)130L, (long)pixel[1]);
        Assert.assertEquals((long)255L, (long)pixel[2]);
        image.getData().getPixel(191, 178, pixel);
        Assert.assertEquals((long)130L, (long)pixel[0]);
        Assert.assertEquals((long)130L, (long)pixel[1]);
        Assert.assertEquals((long)255L, (long)pixel[2]);
    }

    @Test
    public void testGetMapDisallowed() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testGetMapDisallowed");
            return;
        }
        this.setRequestAuth("cite_nostates", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
    }

    @Test
    public void testGetMapFiltered() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testGetMapFiltered");
            return;
        }
        this.setRequestAuth("cite_texas", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        this.assertNotBlank("testGetMapFiltered", image);
        int[] pixel = new int[4];
        image.getData().getPixel(368, 227, pixel);
        Assert.assertEquals((long)130L, (long)pixel[0]);
        Assert.assertEquals((long)130L, (long)pixel[1]);
        Assert.assertEquals((long)255L, (long)pixel[2]);
        image.getData().getPixel(191, 178, pixel);
        Assert.assertEquals((long)255L, (long)pixel[0]);
        Assert.assertEquals((long)255L, (long)pixel[1]);
        Assert.assertEquals((long)255L, (long)pixel[2]);
    }

    @Test
    public void testGetFeatureInfoNoRestrictions() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.setRequestAuth("cite", "cite");
        String texas = this.getAsString(GET_FEATURE_INFO_TEXAS);
        Assert.assertTrue((boolean)texas.contains("STATE_NAME = Texas"));
        String california = this.getAsString(GET_FEATURE_INFO_CALIFORNIA);
        Assert.assertTrue((boolean)california.contains("STATE_NAME = California"));
    }

    @Test
    public void testGetFeatureInfoDisallowedLayer() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.setRequestAuth("cite_nostates", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_FEATURE_INFO_TEXAS);
        Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
    }

    @Test
    public void testGetFeatureInfoDisallowedInfo() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.setRequestAuth("cite_noinfo", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_FEATURE_INFO_TEXAS);
        Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"OperationNotSupported", (String)"//ServiceException/@code", (Document)dom);
    }

    @Test
    public void testGetFeatureInfoFiltered() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.setRequestAuth("cite_texas", "cite");
        String texas = this.getAsString(GET_FEATURE_INFO_TEXAS);
        Assert.assertTrue((boolean)texas.contains("STATE_NAME = Texas"));
        String california = this.getAsString(GET_FEATURE_INFO_CALIFORNIA);
        Assert.assertTrue((boolean)california.contains("no features were found"));
    }

    @Test
    public void testDoubleMosaic() throws Exception {
        this.setRequestAuth("cite_mosaic1", "cite");
        String path = "wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testRasterFilterGreen() throws Exception {
        this.setRequestAuth("cite_mosaic1", "cite");
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)255L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
    }

    @Test
    public void testRasterCrop() throws Exception {
        this.setRequestAuth("cite_mosaic2", "cite");
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] pixel = new int[3];
        image.getData().getPixel(0, 149, pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)255L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        image.getData().getPixel(149, 149, pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
    }
}

