/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.opengis.wcs20.ExtensionItemType;
import net.opengis.wcs20.ExtensionType;
import net.opengis.wcs20.GetCoverageType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.Response;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.platform.Operation;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.coverage.grid.GridCoverage;

public class WCS20GetCoverageResponse
extends Response {
    public static final String COVERAGE_ID_PARAM = "coverageId";
    CoverageResponseDelegateFinder responseFactory;

    public WCS20GetCoverageResponse(CoverageResponseDelegateFinder responseFactory) {
        super(GridCoverage.class);
        this.responseFactory = responseFactory;
    }

    public String getMimeType(Object value, Operation operation) {
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String format = getCoverage.getFormat();
        if (format == null) {
            return "image/tiff";
        }
        CoverageResponseDelegate delegate = this.responseFactory.encoderFor(format);
        if (delegate == null) {
            throw new WCS20Exception("Unsupported format " + format, OWS20Exception.OWSExceptionCode.InvalidParameterValue, "format");
        }
        return format;
    }

    public boolean canHandle(Operation operation) {
        Object firstParam = operation.getParameters()[0];
        if (!(firstParam instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)firstParam;
        return getCoverage.getMediaType() == null;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException {
        String coverageId;
        GridCoverage2D coverage = (GridCoverage2D)value;
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String format = getCoverage.getFormat();
        if (format == null) {
            format = "image/tiff";
        }
        HashMap<String, String> encodingParameters = new HashMap<String, String>();
        ExtensionType extension = getCoverage.getExtension();
        if (extension != null) {
            EList extensions = extension.getContents();
            for (ExtensionItemType ext : extensions) {
                encodingParameters.put(ext.getName(), ext.getSimpleContent());
            }
        }
        if ((coverageId = getCoverage.getCoverageId()) != null) {
            encodingParameters.put(COVERAGE_ID_PARAM, coverageId);
        }
        CoverageResponseDelegate delegate = this.responseFactory.encoderFor(format);
        delegate.encode(coverage, format, encodingParameters, output);
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String format = getCoverage.getFormat();
        if (format == null) {
            format = "image/tiff";
        }
        CoverageResponseDelegate delegate = this.responseFactory.encoderFor(format);
        String extension = delegate.getFileExtension(format);
        return delegate.getFileName((GridCoverage2D)value, getCoverage.getCoverageId(), format);
    }
}

