/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wcs20.GetCapabilitiesType;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs2_0.WCS20Const;
import org.geoserver.wcs2_0.response.TranslatorHelper;
import org.geoserver.wcs2_0.response.WCSExtendedCapabilitiesProvider;
import org.geoserver.wcs2_0.util.NCNameResourceCodec;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.util.ResponseUtils;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class WCS20GetCapabilitiesTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger(WCS20GetCapabilitiesTransformer.class);
    protected static final String CUR_VERSION = "2.0.1";
    private WCSInfo wcs;
    private final boolean skipMisconfigured;
    private CoverageResponseDelegateFinder responseFactory;

    public WCS20GetCapabilitiesTransformer(GeoServer gs, CoverageResponseDelegateFinder responseFactory) {
        this.wcs = (WCSInfo)gs.getService(WCSInfo.class);
        this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)gs.getGlobal().getResourceErrorHandling());
        this.responseFactory = responseFactory;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS20GetCapabilitiesTranslator(handler);
    }

    private class WCS20GetCapabilitiesTranslator
    extends TransformerBase.TranslatorSupport {
        private GetCapabilitiesType request;
        private List<WCSExtendedCapabilitiesProvider> extensions;
        private ExtendedCapabilitiesProvider.Translator translator;
        private TranslatorHelper helper;

        public WCS20GetCapabilitiesTranslator(ContentHandler handler) {
            super(handler, null, null);
            this.helper = new TranslatorHelper();
            this.extensions = GeoServerExtensions.extensions(WCSExtendedCapabilitiesProvider.class);
            NamespaceSupport namespaces = this.getNamespaceSupport();
            namespaces.declarePrefix("wcscrs", "http://www.opengis.net/wcs/service-extension/crs/1.0");
            namespaces.declarePrefix("int", "http://www.opengis.net/WCS_service-extension_interpolation/1.0");
            for (WCSExtendedCapabilitiesProvider cp : this.extensions) {
                cp.registerNamespaces(namespaces);
            }
            this.translator = new ExtendedCapabilitiesProvider.Translator(){

                public void start(String element, Attributes attributes) {
                    WCS20GetCapabilitiesTranslator.this.start(element, attributes);
                }

                public void start(String element) {
                    WCS20GetCapabilitiesTranslator.this.start(element);
                }

                public void end(String element) {
                    WCS20GetCapabilitiesTranslator.this.end(element);
                }

                public void chars(String text) {
                    WCS20GetCapabilitiesTranslator.this.chars(text);
                }
            };
        }

        public void encode(Object o) throws IllegalArgumentException {
            boolean allSections;
            EList sections;
            if (!(o instanceof GetCapabilitiesType)) {
                throw new IllegalArgumentException("Not a GetCapabilitiesType: " + o != null ? o.toString() : "null");
            }
            this.request = (GetCapabilitiesType)o;
            long updateSequence = WCS20GetCapabilitiesTransformer.this.wcs.getGeoServer().getGlobal().getUpdateSequence();
            long requestedUpdateSequence = -1L;
            if (this.request.getUpdateSequence() != null) {
                try {
                    requestedUpdateSequence = Long.parseLong(this.request.getUpdateSequence());
                }
                catch (NumberFormatException e) {
                    throw new WcsException("Invalid update sequence number format, should be an integer", WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence > updateSequence) {
                    throw new WcsException("Invalid update sequence value, it's higher than the current value, " + updateSequence, WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
            }
            if (this.request.getSections() == null) {
                sections = Collections.emptyList();
                allSections = true;
            } else {
                sections = this.request.getSections().getSection();
                allSections = sections.contains(SECTIONS.All.name());
                for (String section : sections) {
                    if (SECTIONS.names.contains(section)) continue;
                    throw new WcsException("Unknown section " + section, WcsException.WcsExceptionCode.InvalidParameterValue, "Sections");
                }
            }
            AttributesImpl attributes = WCS20Const.getDefaultNamespaces();
            attributes.addAttribute("", "version", "version", "", WCS20GetCapabilitiesTransformer.CUR_VERSION);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(updateSequence));
            this.helper.registerNamespaces(this.getNamespaceSupport(), attributes);
            String location = this.buildSchemaLocation(this.request.getBaseUrl(), "http://www.opengis.net/wcs/2.0", "http://schemas.opengis.net/wcs/2.0/wcsGetCapabilities.xsd");
            attributes.addAttribute("", "xsi:schemaLocation", "xsi:schemaLocation", "", location);
            this.start("wcs:Capabilities", attributes);
            if (requestedUpdateSequence < updateSequence) {
                if (allSections || sections.contains(SECTIONS.ServiceIdentification.name())) {
                    this.handleServiceIdentification();
                }
                if (allSections || sections.contains(SECTIONS.ServiceProvider.name())) {
                    this.handleServiceProvider();
                }
                if (allSections || sections.contains(SECTIONS.OperationsMetadata.name())) {
                    this.handleOperationsMetadata();
                }
                if (allSections || sections.contains(SECTIONS.ServiceMetadata.name())) {
                    this.handleServiceMetadata(this.request);
                }
                if (allSections || sections.contains(SECTIONS.Contents.name())) {
                    this.handleContents();
                }
                if (allSections || sections.contains(SECTIONS.Languages.name())) {
                    this.handleLanguages();
                }
            }
            this.end("wcs:Capabilities");
        }

        String buildSchemaLocation(String schemaBaseURL, String ... locations) {
            for (WCSExtendedCapabilitiesProvider cp : this.extensions) {
                locations = this.helper.append(locations, cp.getSchemaLocations(schemaBaseURL));
            }
            return this.helper.buildSchemaLocation(locations);
        }

        private void handleServiceMetadata(GetCapabilitiesType ct) {
            this.start("wcs:ServiceMetadata");
            if (ct.getAcceptVersions() == null || ct.getAcceptVersions().getVersion() == null || ct.getAcceptVersions().getVersion().isEmpty() || ct.getAcceptVersions().getVersion().contains((Object)WCS20GetCapabilitiesTransformer.CUR_VERSION)) {
                TreeSet<String> formats = new TreeSet<String>();
                for (String format : WCS20GetCapabilitiesTransformer.this.responseFactory.getOutputFormats()) {
                    CoverageResponseDelegate delegate = WCS20GetCapabilitiesTransformer.this.responseFactory.encoderFor(format);
                    String mime = delegate.getMimeType(format);
                    try {
                        new URI(mime);
                        formats.add(mime);
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                for (String format : formats) {
                    this.element("wcs:formatSupported", format);
                }
            }
            this.start("wcs:Extension");
            Collection codes = WCS20GetCapabilitiesTransformer.this.wcs.getSRS() == null || WCS20GetCapabilitiesTransformer.this.wcs.getSRS().isEmpty() ? CRS.getSupportedCodes((String)"EPSG") : WCS20GetCapabilitiesTransformer.this.wcs.getSRS();
            for (String code : codes) {
                if (code.equals("WGS84(DD)")) continue;
                this.element("wcscrs:crsSupported", "http://www.opengis.net/def/crs/EPSG/0/" + code);
            }
            this.element("int:interpolationSupported", "http://www.opengis.net/def/interpolation/OGC/1/nearest-neighbor");
            this.element("int:interpolationSupported", "http://www.opengis.net/def/interpolation/OGC/1/linear");
            this.element("int:interpolationSupported", "http://www.opengis.net/def/interpolation/OGC/1/cubic");
            this.end("wcs:Extension");
            this.end("wcs:ServiceMetadata");
        }

        private void handleServiceIdentification() {
            this.start("ows:ServiceIdentification");
            this.element("ows:Title", WCS20GetCapabilitiesTransformer.this.wcs.getTitle());
            this.element("ows:Abstract", WCS20GetCapabilitiesTransformer.this.wcs.getAbstract());
            this.handleKeywords(WCS20GetCapabilitiesTransformer.this.wcs.getKeywords());
            this.element("ows:ServiceType", "urn:ogc:service:wcs");
            this.element("ows:ServiceTypeVersion", WCS20GetCapabilitiesTransformer.CUR_VERSION);
            this.element("ows:ServiceTypeVersion", "1.1.1");
            this.element("ows:ServiceTypeVersion", "1.1.0");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS/2.0/conf/core");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_protocol-binding_get-kvp/1.0.1");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_protocol-binding_post-xml/1.0");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_crs/1.0/conf/crs-gridded-coverage");
            this.element("ows:Profile", " http://www.opengis.net/spec/WCS_geotiff-coverages/1.0/conf/geotiff-coverage");
            this.element("ows:Profile", "http://www.opengis.net/spec/GMLCOV/1.0/conf/gml-coverage");
            this.element("ows:Profile", "http://www.opengis.net/spec/GMLCOV/1.0/conf/special-format");
            this.element("ows:Profile", "http://www.opengis.net/spec/GMLCOV/1.0/conf/multipart");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_scaling/1.0/conf/scaling");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_crs/1.0/conf/crs");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_interpolation/1.0/conf/interpolation");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_interpolation/1.0/conf/interpolation-per-axis");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_interpolation/1.0/conf/nearest-neighbor");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_interpolation/1.0/conf/linear");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_interpolation/1.0/conf/cubic");
            this.element("ows:Profile", "http://www.opengis.net/spec/WCS_service-extension_range-subsetting/1.0/conf/record-subsetting");
            String fees = WCS20GetCapabilitiesTransformer.this.wcs.getFees();
            if (StringUtils.isBlank((CharSequence)fees)) {
                fees = "NONE";
            }
            this.element("ows:Fees", fees);
            String accessConstraints = WCS20GetCapabilitiesTransformer.this.wcs.getAccessConstraints();
            if (StringUtils.isBlank((CharSequence)accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("ows:AccessConstraints", accessConstraints);
            this.end("ows:ServiceIdentification");
        }

        private void handleServiceProvider() {
            this.start("ows:ServiceProvider");
            SettingsInfo settings = WCS20GetCapabilitiesTransformer.this.wcs.getGeoServer().getSettings();
            this.element("ows:ProviderName", settings.getContact().getContactOrganization());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", settings.getOnlineResource() != null ? settings.getOnlineResource() : "");
            this.element("ows:ProviderSite", null, attributes);
            this.handleContact();
            this.end("ows:ServiceProvider");
        }

        private void handleOperationsMetadata() {
            this.start("ows:OperationsMetadata");
            this.handleOperation("GetCapabilities", null);
            this.handleOperation("DescribeCoverage", null);
            this.handleOperation("GetCoverage", null);
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, "PostEncoding");
            this.start("ows:Constraint", attributes);
            this.start("ows:AllowedValues");
            this.element("ows:Value", "XML");
            this.end("ows:AllowedValues");
            this.end("ows:Constraint");
            if (this.extensions != null && this.extensions.size() > 0) {
                try {
                    for (WCSExtendedCapabilitiesProvider provider : this.extensions) {
                        provider.encodeExtendedOperations(this.translator, WCS20GetCapabilitiesTransformer.this.wcs, this.request);
                    }
                }
                catch (Exception e) {
                    throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                }
            }
            this.end("ows:OperationsMetadata");
        }

        private void handleOperation(String capabilityName, Map<String, List<String>> parameters) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, capabilityName);
            this.start("ows:Operation", attributes);
            String url = org.geoserver.ows.util.ResponseUtils.appendQueryString((String)org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE), (String)"");
            this.start("ows:DCP");
            this.start("ows:HTTP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.element("ows:Get", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("ows:DCP");
            this.start("ows:HTTP");
            this.element("ows:Post", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, List<String>> param : parameters.entrySet()) {
                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "name", "name", "", param.getKey());
                    this.start("ows:Parameter", attributes);
                    this.start("ows:AllowedValues");
                    for (String value : param.getValue()) {
                        this.element("ows:Value", value);
                    }
                    this.end("ows:AllowedValues");
                    this.end("ows:Parameter");
                }
            }
            this.end("ows:Operation");
        }

        private void handleKeywords(List<KeywordInfo> kwords) {
            if (kwords != null && !kwords.isEmpty()) {
                this.start("ows:Keywords");
                for (KeywordInfo kword : kwords) {
                    this.element("ows:Keyword", kword.getValue());
                }
                this.end("ows:Keywords");
            }
        }

        private void handleContact() {
            GeoServer gs = WCS20GetCapabilitiesTransformer.this.wcs.getGeoServer();
            this.start("ows:ServiceContact");
            ContactInfo contact = gs.getSettings().getContact();
            this.elementIfNotEmpty("ows:IndividualName", contact.getContactPerson());
            this.elementIfNotEmpty("ows:PositionName", contact.getContactPosition());
            this.start("ows:ContactInfo");
            this.start("ows:Phone");
            this.elementIfNotEmpty("ows:Voice", contact.getContactVoice());
            this.elementIfNotEmpty("ows:Facsimile", contact.getContactFacsimile());
            this.end("ows:Phone");
            this.start("ows:Address");
            this.elementIfNotEmpty("ows:DeliveryPoint", contact.getAddress());
            this.elementIfNotEmpty("ows:City", contact.getAddressCity());
            this.elementIfNotEmpty("ows:AdministrativeArea", contact.getAddressState());
            this.elementIfNotEmpty("ows:PostalCode", contact.getAddressPostalCode());
            this.elementIfNotEmpty("ows:Country", contact.getAddressCountry());
            this.elementIfNotEmpty("ows:ElectronicMailAddress", contact.getContactEmail());
            this.end("ows:Address");
            String or = gs.getSettings().getOnlineResource();
            if (StringUtils.isNotBlank((CharSequence)or)) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "xlink:href", "xlink:href", "", or);
                this.start("ows:OnlineResource", attributes);
                this.end("OnlineResource");
            }
            this.end("ows:ContactInfo");
            this.end("ows:ServiceContact");
        }

        private void handleWGS84BoundingBox(BoundingBox envelope) {
            this.start("ows:WGS84BoundingBox");
            this.element("ows:LowerCorner", Double.toString(envelope.getLowerCorner().getOrdinate(0)) + " " + envelope.getLowerCorner().getOrdinate(1));
            this.element("ows:UpperCorner", Double.toString(envelope.getUpperCorner().getOrdinate(0)) + " " + envelope.getUpperCorner().getOrdinate(1));
            this.end("ows:WGS84BoundingBox");
        }

        private void handleContents() {
            this.start("wcs:Contents");
            TreeSet coverages = new TreeSet(new CoverageInfoLabelComparator());
            coverages.addAll(WCS20GetCapabilitiesTransformer.this.wcs.getGeoServer().getCatalog().getCoverages());
            Iterator<Object> it = coverages.iterator();
            while (it.hasNext()) {
                CoverageInfo cv = (CoverageInfo)it.next();
                if (cv.enabled()) continue;
                it.remove();
            }
            for (CoverageInfo cv : coverages) {
                try {
                    this.mark();
                    this.handleCoverageSummary(cv);
                    this.commit();
                }
                catch (Exception e) {
                    if (WCS20GetCapabilitiesTransformer.this.skipMisconfigured) {
                        this.reset();
                        LOGGER.log(Level.SEVERE, "Skipping coverage " + cv.prefixedName() + " as its capabilities generation failed", e);
                        continue;
                    }
                    throw new RuntimeException("Capabilities document generation failed on coverage " + cv.prefixedName(), e);
                }
            }
            if (this.extensions != null && this.extensions.size() > 0) {
                this.start("wcs:Extension");
                try {
                    for (WCSExtendedCapabilitiesProvider provider : this.extensions) {
                        provider.encodeExtendedContents(this.translator, WCS20GetCapabilitiesTransformer.this.wcs, new ArrayList<CoverageInfo>(coverages), this.request);
                    }
                }
                catch (Exception e) {
                    throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                }
                this.end("wcs:Extension");
            }
            this.end("wcs:Contents");
        }

        private void handleCoverageSummary(CoverageInfo cv) throws Exception {
            this.start("wcs:CoverageSummary");
            this.elementIfNotEmpty("ows:Title", cv.getTitle());
            this.elementIfNotEmpty("ows:Abstract", cv.getDescription());
            this.handleKeywords(cv.getKeywords());
            String covId = NCNameResourceCodec.encode((ResourceInfo)cv);
            this.element("wcs:CoverageId", covId);
            this.element("wcs:CoverageSubtype", "RectifiedGridCoverage");
            this.handleWGS84BoundingBox((BoundingBox)cv.getLatLonBoundingBox());
            this.handleBoundingBox((BoundingBox)cv.boundingBox());
            cv.getMetadataLinks().forEach(this::handleMetadataLink);
            this.end("wcs:CoverageSummary");
        }

        private void handleBoundingBox(BoundingBox boundingBox) throws Exception {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "crs", "crs", "", "http://www.opengis.net/def/crs/EPSG/0/" + CRS.lookupIdentifier((IdentifiedObject)boundingBox.getCoordinateReferenceSystem(), (boolean)false));
            this.start("ows:BoundingBox", attributes);
            this.element("ows:LowerCorner", Double.toString(boundingBox.getLowerCorner().getOrdinate(0)) + " " + boundingBox.getLowerCorner().getOrdinate(1));
            this.element("ows:UpperCorner", Double.toString(boundingBox.getUpperCorner().getOrdinate(0)) + " " + boundingBox.getUpperCorner().getOrdinate(1));
            this.end("ows:BoundingBox");
        }

        private void handleMetadataLink(MetadataLinkInfo mdl) {
            if (StringUtils.isNotBlank((CharSequence)mdl.getContent())) {
                String url = ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)mdl, (String)this.request.getBaseUrl());
                AttributesImpl attributes = new AttributesImpl();
                if (StringUtils.isNotBlank((CharSequence)mdl.getAbout())) {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                attributes.addAttribute("", "xlink:type", "xlink:type", "", "simple");
                attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
                this.element("ows:Metadata", null, attributes);
            }
        }

        private void handleLanguages() {
        }

        private void elementIfNotEmpty(String elementName, String content) {
            if (StringUtils.isNotBlank((CharSequence)content)) {
                this.element(elementName, content);
            }
        }
    }

    static enum SECTIONS {
        ServiceIdentification,
        ServiceProvider,
        OperationsMetadata,
        ServiceMetadata,
        Contents,
        Languages,
        All;

        public static final Set<String> names;

        static {
            HashSet<String> tmp = new HashSet<String>();
            for (SECTIONS section : SECTIONS.values()) {
                tmp.add(section.name());
            }
            names = Collections.unmodifiableSet(tmp);
        }
    }
}

