/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.wcs20.DescribeCoverageType;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs2_0.WCS20Const;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.response.GMLTransformer;
import org.geoserver.wcs2_0.response.MIMETypeMapper;
import org.geoserver.wcs2_0.response.WCS20CoverageMetadataProvider;
import org.geoserver.wcs2_0.response.WCSDimensionsHelper;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geoserver.wcs2_0.util.NCNameResourceCodec;
import org.geoserver.wcs2_0.util.RequestUtils;
import org.geoserver.wcs2_0.util.WCS20DescribeCoverageExtension;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.vfny.geoserver.util.ResponseUtils;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class WCS20DescribeCoverageTransformer
extends GMLTransformer {
    public static final Logger LOGGER = Logging.getLogger((String)WCS20DescribeCoverageTransformer.class.getPackage().getName());
    private MIMETypeMapper mimemapper;
    private WCSInfo wcs;
    private Catalog catalog;
    private CoverageResponseDelegateFinder responseFactory;
    private List<WCS20DescribeCoverageExtension> wcsDescribeCoverageExtensions;
    private boolean availableDescribeCoverageExtensions;

    public WCS20DescribeCoverageTransformer(WCSInfo wcs, Catalog catalog, CoverageResponseDelegateFinder responseFactory, EnvelopeAxesLabelsMapper envelopeDimensionsMapper, MIMETypeMapper mimemapper) {
        super(envelopeDimensionsMapper);
        this.wcs = wcs;
        this.catalog = catalog;
        this.responseFactory = responseFactory;
        this.mimemapper = mimemapper;
        this.setNamespaceDeclarationEnabled(false);
        this.setIndentation(2);
        this.wcsDescribeCoverageExtensions = GeoServerExtensions.extensions(WCS20DescribeCoverageExtension.class);
        this.availableDescribeCoverageExtensions = this.wcsDescribeCoverageExtensions != null && !this.wcsDescribeCoverageExtensions.isEmpty();
    }

    public WCS20DescribeCoverageTranslator createTranslator(ContentHandler handler) {
        return new WCS20DescribeCoverageTranslator(handler);
    }

    public class WCS20DescribeCoverageTranslator
    extends GMLTransformer.GMLTranslator {
        private DescribeCoverageType request;
        private String proxifiedBaseUrl;

        public WCS20DescribeCoverageTranslator(ContentHandler handler) {
            super(handler);
        }

        @Override
        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof DescribeCoverageType)) {
                throw new IllegalArgumentException(new StringBuffer("Not a DescribeCoverageType: ").append(o).toString());
            }
            this.request = (DescribeCoverageType)o;
            ArrayList<CoverageInfo> coverages = new ArrayList<CoverageInfo>();
            ArrayList<Object> covIds = new ArrayList<Object>();
            for (Object encodedCoverageId : this.request.getCoverageId()) {
                LayerInfo layer;
                String newCoverageID = encodedCoverageId;
                if (WCS20DescribeCoverageTransformer.this.availableDescribeCoverageExtensions) {
                    for (WCS20DescribeCoverageExtension ext : WCS20DescribeCoverageTransformer.this.wcsDescribeCoverageExtensions) {
                        newCoverageID = ext.handleCoverageId(newCoverageID);
                    }
                }
                if ((layer = NCNameResourceCodec.getCoverage(WCS20DescribeCoverageTransformer.this.catalog, newCoverageID)) != null) {
                    coverages.add((CoverageInfo)layer.getResource());
                    covIds.add(encodedCoverageId);
                    continue;
                }
                throw new IllegalArgumentException("Failed to locate coverage " + (String)encodedCoverageId + ", unexpected, the coverage existance has been checked earlier in the request lifecycle");
            }
            NamespaceSupport namespaces = this.getNamespaceSupport();
            namespaces.declarePrefix("swe", "http://www.opengis.net/swe/2.0");
            namespaces.declarePrefix("wcsgs", "http://www.geoserver.org/wcsgs/2.0");
            for (WCS20CoverageMetadataProvider cp : this.extensions) {
                cp.registerNamespaces(namespaces);
            }
            AttributesImpl attributes = WCS20Const.getDefaultNamespaces();
            this.helper.registerNamespaces(this.getNamespaceSupport(), attributes);
            String location = this.buildSchemaLocation(this.request.getBaseUrl(), "http://www.opengis.net/wcs/2.0", "http://schemas.opengis.net/wcs/2.0/wcsDescribeCoverage.xsd", "http://www.geoserver.org/wcsgs/2.0", org.geoserver.ows.util.ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wcs/2.0/wcsgs.xsd"));
            attributes.addAttribute("", "xsi:schemaLocation", "xsi:schemaLocation", "", location);
            this.start("wcs:CoverageDescriptions", attributes);
            int coverageIndex = 0;
            for (CoverageInfo ci : coverages) {
                try {
                    String encodedId = NCNameResourceCodec.encode((ResourceInfo)ci);
                    CoverageInfo ciNew = ci;
                    String newCoverageID = (String)covIds.get(coverageIndex);
                    if (WCS20DescribeCoverageTransformer.this.availableDescribeCoverageExtensions) {
                        for (WCS20DescribeCoverageExtension ext : WCS20DescribeCoverageTransformer.this.wcsDescribeCoverageExtensions) {
                            newCoverageID = ext.handleEncodedId(location, newCoverageID);
                            ciNew = ext.handleCoverageInfo((String)covIds.get(coverageIndex), ci);
                        }
                    } else {
                        newCoverageID = encodedId;
                    }
                    this.handleCoverageDescription(newCoverageID, ciNew);
                    ++coverageIndex;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error occurred during describe coverage xml encoding", e);
                }
            }
            this.end("wcs:CoverageDescriptions");
        }

        String buildSchemaLocation(String schemaBaseURL, String ... locations) {
            for (WCS20CoverageMetadataProvider cp : this.extensions) {
                locations = this.helper.append(locations, cp.getSchemaLocations(schemaBaseURL));
            }
            return this.helper.buildSchemaLocation(locations);
        }

        public void handleCoverageDescription(String encodedId, CoverageInfo ci) {
            try {
                GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
                if (reader == null) {
                    throw new WCS20Exception("Unable to read sample coverage for " + ci.getName());
                }
                Map<String, DimensionInfo> dimensionsMap = WCSDimensionsHelper.getDimensionsFromMetadata(ci.getMetadata());
                WCSDimensionsHelper dimensionsHelper = null;
                if (dimensionsMap != null && !dimensionsMap.isEmpty()) {
                    dimensionsHelper = WCSDimensionsHelper.getWCSDimensionsHelper(encodedId, ci, reader);
                }
                CoordinateReferenceSystem crs = reader.getCoordinateReferenceSystem();
                List<String> axesNames = WCS20DescribeCoverageTransformer.this.envelopeDimensionsMapper.getAxesNames((Envelope)reader.getOriginalEnvelope(), true);
                Integer EPSGCode = null;
                try {
                    EPSGCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                }
                catch (FactoryException e) {
                    throw new IllegalStateException("Unable to lookup epsg code for this CRS:" + crs, e);
                }
                if (EPSGCode == null) {
                    throw new IllegalStateException("Unable to lookup epsg code for this CRS:" + crs);
                }
                String srsName = "http://www.opengis.net/def/crs/EPSG/0/" + EPSGCode;
                boolean axisSwap = !CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)srsName)).equals((Object)CRS.AxisOrder.EAST_NORTH);
                AttributesImpl coverageAttributes = new AttributesImpl();
                coverageAttributes.addAttribute("", "gml:id", "gml:id", "", encodedId);
                this.start("wcs:CoverageDescription", coverageAttributes);
                this.elementSafe("gml:description", ci.getDescription());
                this.elementSafe("gml:name", ci.getTitle());
                StringBuilder builder = new StringBuilder();
                for (String axisName : axesNames) {
                    builder.append(axisName).append(" ");
                }
                if (dimensionsHelper != null && dimensionsHelper.getElevationDimension() != null) {
                    builder.append("elevation ");
                }
                if (dimensionsHelper != null && dimensionsHelper.getTimeDimension() != null) {
                    builder.append("time ");
                }
                String axesLabel = builder.substring(0, builder.length() - 1);
                GeneralEnvelope envelope = reader.getOriginalEnvelope();
                this.handleBoundedBy(envelope, axisSwap, srsName, axesLabel, dimensionsHelper);
                this.element("wcs:CoverageId", encodedId);
                this.handleCoverageFunction((GridEnvelope)((GridEnvelope2D)reader.getOriginalGridRange()), axisSwap);
                this.handleMetadata(ci, dimensionsHelper);
                builder.setLength(0);
                axesNames = WCS20DescribeCoverageTransformer.this.envelopeDimensionsMapper.getAxesNames((Envelope)reader.getOriginalEnvelope(), false);
                for (String axisName : axesNames) {
                    builder.append(axisName).append(" ");
                }
                axesLabel = builder.substring(0, builder.length() - 1);
                GridGeometry2D gg = new GridGeometry2D(reader.getOriginalGridRange(), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem());
                this.handleDomainSet(gg, 2, encodedId, srsName, axisSwap);
                this.handleRangeType(ci.getDimensions());
                this.handleServiceParameters(ci);
                this.end("wcs:CoverageDescription");
            }
            catch (Exception e) {
                throw new WcsException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GridSampleDimension[] getSampleDimensions(GridCoverage2DReader reader) throws Exception {
            GridSampleDimension[] gridSampleDimensionArray;
            block3: {
                GridCoverage2D coverage = null;
                try {
                    coverage = RequestUtils.readSampleGridCoverage(reader);
                    gridSampleDimensionArray = coverage.getSampleDimensions();
                    if (coverage == null) break block3;
                }
                catch (Throwable throwable) {
                    if (coverage != null) {
                        CoverageCleanerCallback.addCoverages((GridCoverage[])new GridCoverage[]{coverage});
                    }
                    throw throwable;
                }
                CoverageCleanerCallback.addCoverages((GridCoverage[])new GridCoverage[]{coverage});
            }
            return gridSampleDimensionArray;
        }

        @Override
        protected void handleAdditionalMetadata(Object context) {
            if (context instanceof CoverageInfo) {
                CoverageInfo ci = (CoverageInfo)context;
                List keywords = ci.getKeywords();
                if (keywords != null && !keywords.isEmpty()) {
                    this.start("ows:Keywords");
                    keywords.forEach(kw -> this.element("ows:Keyword", kw.getValue()));
                    this.end("ows:Keywords");
                }
                ci.getMetadataLinks().forEach(this::handleMetadataLink);
            }
        }

        private void handleMetadataLink(MetadataLinkInfo mdl) {
            if (StringUtils.isNotBlank((CharSequence)mdl.getContent())) {
                String url = ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)mdl, (String)this.request.getBaseUrl());
                AttributesImpl attributes = new AttributesImpl();
                if (StringUtils.isNotBlank((CharSequence)mdl.getAbout())) {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                attributes.addAttribute("", "xlink:type", "xlink:type", "", "simple");
                attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
                this.element("ows:Metadata", null, attributes);
            }
        }

        private void handleServiceParameters(CoverageInfo ci) throws IOException {
            this.start("wcs:ServiceParameters");
            this.element("wcs:CoverageSubtype", "RectifiedGridCoverage");
            String mapNativeFormat = WCS20DescribeCoverageTransformer.this.mimemapper.mapNativeFormat(ci);
            this.element("wcs:nativeFormat", mapNativeFormat);
            this.end("wcs:ServiceParameters");
        }

        public void handleRangeType(List<CoverageDimensionInfo> bands) {
            this.start("gmlcov:rangeType");
            this.start("swe:DataRecord");
            for (CoverageDimensionInfo sd : bands) {
                AttributesImpl fieldAttr = new AttributesImpl();
                fieldAttr.addAttribute("", "name", "name", "", sd.getName());
                this.start("swe:field", fieldAttr);
                this.start("swe:Quantity");
                this.start("swe:description");
                this.chars(sd.getName());
                this.end("swe:description");
                List nullValues = sd.getNullValues();
                if (nullValues != null && !nullValues.isEmpty()) {
                    int size = nullValues.size();
                    double[] noDataValues = new double[size];
                    for (int i = 0; i < size; ++i) {
                        noDataValues[i] = (Double)nullValues.get(i);
                    }
                    this.handleSampleDimensionNilValues(null, noDataValues);
                }
                AttributesImpl uomAttr = new AttributesImpl();
                String unit = sd.getUnit();
                uomAttr.addAttribute("", "code", "code", "", unit == null ? "W.m-2.Sr-1" : unit);
                this.start("swe:uom", uomAttr);
                this.end("swe:uom");
                this.start("swe:constraint");
                this.start("swe:AllowedValues");
                this.handleSampleDimensionRange(sd);
                this.end("swe:AllowedValues");
                this.end("swe:constraint");
                this.end("swe:Quantity");
                this.end("swe:field");
            }
            this.end("swe:DataRecord");
            this.end("gmlcov:rangeType");
        }
    }
}

