/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.util.Enumeration;
import org.geoserver.platform.ServiceException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

class TranslatorHelper {
    TranslatorHelper() {
    }

    void registerNamespaces(NamespaceSupport ns, AttributesImpl attributes) {
        Enumeration<String> declaredPrefixes = ns.getDeclaredPrefixes();
        while (declaredPrefixes.hasMoreElements()) {
            String prefix = declaredPrefixes.nextElement();
            String uri = ns.getURI(prefix);
            if ("xml".equals(prefix)) continue;
            String prefixDef = "xmlns:" + prefix;
            attributes.addAttribute("", prefixDef, prefixDef, "", uri);
        }
    }

    String[] append(String[] locations1, String[] locations2) {
        String[] result = new String[locations1.length + locations2.length];
        System.arraycopy(locations1, 0, result, 0, locations1.length);
        System.arraycopy(locations2, 0, result, locations1.length, locations2.length);
        return result;
    }

    String buildSchemaLocation(String ... schemaLocations) {
        StringBuilder schemaLocation = new StringBuilder();
        try {
            for (int i = 0; i < schemaLocations.length - 1; i += 2) {
                schemaLocation.append(" ");
                schemaLocation.append(schemaLocations[i]).append(" ").append(schemaLocations[i + 1]);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ServiceException("Extended capabilities provider returned improper set of namespace,location pairs from getSchemaLocations()", (Throwable)e);
        }
        return schemaLocation.toString();
    }
}

