/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import javax.media.jai.Interpolation;
import net.opengis.wcs20.InterpolationMethodType;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.util.Utilities;

enum InterpolationPolicy {
    linear("http://www.opengis.net/def/interpolation/OGC/1/linear"){

        @Override
        public Interpolation getInterpolation() {
            return Interpolation.getInstance((int)1);
        }
    }
    ,
    nearestneighbor("http://www.opengis.net/def/interpolation/OGC/1/nearest-neighbor"){

        @Override
        public Interpolation getInterpolation() {
            return Interpolation.getInstance((int)0);
        }
    }
    ,
    quadratic("http://www.opengis.net/def/interpolation/OGC/1/quadratic"){

        @Override
        public Interpolation getInterpolation() {
            throw new WCS20Exception("Interpolation not supported", WCS20Exception.WCS20ExceptionCode.InterpolationMethodNotSupported, quadratic.toString());
        }
    }
    ,
    cubic("http://www.opengis.net/def/interpolation/OGC/1/cubic"){

        @Override
        public Interpolation getInterpolation() {
            return Interpolation.getInstance((int)3);
        }
    }
    ,
    lostarea("http://www.opengis.net/def/interpolation/OGC/1/lost-area"){

        @Override
        public Interpolation getInterpolation() {
            throw new WCS20Exception("Interpolation not supported", WCS20Exception.WCS20ExceptionCode.InterpolationMethodNotSupported, lostarea.toString());
        }
    }
    ,
    barycentric("http://www.opengis.net/def/interpolation/OGC/1/barycentric"){

        @Override
        public Interpolation getInterpolation() {
            throw new WCS20Exception("Interpolation not supported", WCS20Exception.WCS20ExceptionCode.InterpolationMethodNotSupported, barycentric.toString());
        }
    };

    private final String strVal;

    private InterpolationPolicy(String representation) {
        this.strVal = representation;
    }

    public abstract Interpolation getInterpolation();

    static InterpolationPolicy getPolicy(InterpolationMethodType interpolationMethodType) {
        Utilities.ensureNonNull((String)"interpolationMethodType", (Object)interpolationMethodType);
        String interpolationMethod = interpolationMethodType.getInterpolationMethod();
        return InterpolationPolicy.getPolicy(interpolationMethod);
    }

    static InterpolationPolicy getPolicy(String interpolationMethod) {
        InterpolationPolicy[] values;
        Utilities.ensureNonNull((String)"interpolationMethod", (Object)interpolationMethod);
        for (InterpolationPolicy policy : values = InterpolationPolicy.values()) {
            if (!policy.strVal.equals(interpolationMethod)) continue;
            return policy;
        }
        throw new WCS20Exception("Interpolation method not supported", WCS20Exception.WCS20ExceptionCode.InterpolationMethodNotSupported, interpolationMethod);
    }

    static InterpolationPolicy getDefaultPolicy() {
        return nearestneighbor;
    }
}

