/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.Wcs20Factory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wcs2_0.DefaultWebCoverageService20;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataSourceException;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetCoverageTest
extends WCSTestSupport {
    protected static QName WATTEMP = new QName(MockData.SF_URI, "watertemp", MockData.SF_PREFIX);
    protected static QName WATTEMP_DILATED = new QName(MockData.SF_URI, "watertemp_dilated", MockData.SF_PREFIX);
    protected static QName TIMERANGES = new QName(MockData.SF_URI, "timeranges", MockData.SF_PREFIX);
    protected static QName CUSTOMDIMS = new QName(MockData.SF_URI, "customdimensions", MockData.SF_PREFIX);
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    private static final QName BORDERS = new QName(MockData.SF_URI, "borders", MockData.SF_PREFIX);
    private static final QName SPATIO_TEMPORAL = new QName(MockData.SF_URI, "spatio-temporal", MockData.SF_PREFIX);

    @Before
    public void clearDimensions() {
        this.clearDimensions(this.getLayerId(WATTEMP));
        this.clearDimensions(this.getLayerId(TIMERANGES));
        this.clearDimensions(this.getLayerId(CUSTOMDIMS));
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(WATTEMP, "watertemp.zip", null, null, SystemTestData.class, this.getCatalog());
        GeoServerDataDirectory dataDirectory = this.getDataDirectory();
        Resource watertemp = dataDirectory.getResourceLoader().get("watertemp");
        File data = watertemp.dir();
        FilenameFilter groundElevationFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(".*_000_.*tiff") || name.matches("watertemp\\..*");
            }
        };
        for (File file : data.listFiles(groundElevationFilter)) {
            file.delete();
        }
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(BORDERS, "/borders.zip", null, this.getCatalog());
        testData.addRasterLayer(TIMERANGES, "timeranges.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(CUSTOMDIMS, "customdimensions.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(SPATIO_TEMPORAL, "spatio-temporal.zip", null, null, SystemTestData.class, this.getCatalog());
        this.sortByElevation(TIMERANGES);
        this.sortByElevation(CUSTOMDIMS);
        testData.addRasterLayer(WATTEMP_DILATED, "/watertemp_dilated.zip", null, null, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    private void sortByElevation(QName layer) {
        CoverageInfo coverage = this.getCatalog().getCoverageByName(this.getLayerId(layer));
        String sortByKey = ImageMosaicFormat.SORT_BY.getName().toString();
        coverage.getParameters().put(sortByKey, "elevation");
        this.getCatalog().save((ResourceInfo)coverage);
    }

    @Test
    public void testCoverageTrimmingLatitudeNativeCRSXML() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingLatitudeNativeCRSXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        this.checkCoverageTrimmingLatitudeNativeCRS(tiffContents);
    }

    @Test
    public void testCoverageTrimmingLatitudeNativeCRSXMLMultipart() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageTrimmingLatitudeNativeCRSXMLMultipart.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"multipart/related", (String)response.getContentType());
        Multipart multipart = this.getMultipart(response);
        TestCase.assertEquals((int)2, (int)multipart.getCount());
        BodyPart xmlPart = multipart.getBodyPart(0);
        TestCase.assertEquals((String)"application/gml+xml", (String)xmlPart.getHeader("Content-Type")[0]);
        TestCase.assertEquals((String)"wcs", (String)xmlPart.getHeader("Content-ID")[0]);
        Document gml = this.dom(xmlPart.getInputStream());
        XMLAssert.assertXpathEvaluatesTo((String)"fileReference", (String)"//gml:rangeSet/gml:File/gml:rangeParameters/@xlink:arcrole", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"cid:/coverages/wcs__BlueMarble.tif", (String)"//gml:rangeSet/gml:File/gml:rangeParameters/@xlink:href", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.opengis.net/spec/GMLCOV_geotiff-coverages/1.0/conf/geotiff-coverage", (String)"//gml:rangeSet/gml:File/gml:rangeParameters/@xlink:role", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"cid:/coverages/wcs__BlueMarble.tif", (String)"//gml:rangeSet/gml:File/gml:fileReference", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//gml:rangeSet/gml:File/gml:mimeType", (Document)gml);
        BodyPart coveragePart = multipart.getBodyPart(1);
        TestCase.assertEquals((String)"/coverages/wcs__BlueMarble.tif", (String)coveragePart.getHeader("Content-ID")[0]);
        TestCase.assertEquals((String)"image/tiff", (String)coveragePart.getContentType());
        byte[] tiffContents = IOUtils.toByteArray((InputStream)coveragePart.getInputStream());
        this.checkCoverageTrimmingLatitudeNativeCRS(tiffContents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCoverageTrimmingLatitudeNativeCRS(byte[] tiffContents) throws IOException, DataSourceException, NoSuchAuthorityCodeException, FactoryException {
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{targetCoverage.getEnvelope().getMinimum(0), -43.5}, new double[]{targetCoverage.getEnvelope().getMaximum(0), -43.0});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double scale = GetCoverageTest.getScale((Coverage)targetCoverage);
            GetCoverageTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralEnvelope)targetCoverage.getEnvelope(), scale);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)expectedEnvelope.getCoordinateReferenceSystem()));
            TestCase.assertEquals((int)gridRange.getSpan(0), (int)360);
            TestCase.assertEquals((int)gridRange.getSpan(1), (int)120);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoverageTrimmingNativeCRSXML() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingNativeCRSXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{146.5, -43.5}, new double[]{147.0, -43.0});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double scale = GetCoverageTest.getScale((Coverage)targetCoverage);
            GetCoverageTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralEnvelope)targetCoverage.getEnvelope(), scale);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)expectedEnvelope.getCoordinateReferenceSystem()));
            TestCase.assertEquals((int)gridRange.getSpan(0), (int)120);
            TestCase.assertEquals((int)gridRange.getSpan(1), (int)120);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testCoverageTrimmingBorders() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingBorders.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
    }

    @Test
    public void testCoverageTrimmingOutsideBorders() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingOutsideBorders.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        this.checkOws20Exception(response, 404, "InvalidSubsetting", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFullCoverageXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetFullCoverage.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        String contentDisposition = response.getHeader("Content-disposition");
        TestCase.assertEquals((String)"inline; filename=wcs__BlueMarble.tif", (String)contentDisposition);
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getGridGeometry().getGridRange(), (Object)targetCoverage.getGridGeometry().getGridRange());
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((Object)sourceCoverage.getEnvelope(), (Object)targetCoverage.getEnvelope());
        }
        catch (Throwable throwable) {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            readerTarget.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.scheduleForCleaning((GridCoverage)sourceCoverage);
        }
        catch (Exception exception) {}
    }

    @Test
    public void testInputLimits() throws Exception {
        File xml = new File("./src/test/resources/requestGetFullCoverage.xml");
        String request = FileUtils.readFileToString((File)xml);
        this.setInputLimit(1);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        System.out.println(new String(this.getBinary(response)));
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.setInputLimit(-1);
    }

    @Test
    public void testOutputLimits() throws Exception {
        File xml = new File("./src/test/resources/requestGetFullCoverage.xml");
        String request = FileUtils.readFileToString((File)xml);
        this.setOutputLimit(1);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.setOutputLimit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoverageTrimmingLongitudeNativeCRSXML() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingLongNativeCRSXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{146.5, targetCoverage.getEnvelope().getMinimum(1)}, new double[]{147.0, targetCoverage.getEnvelope().getMaximum(1)});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double scale = GetCoverageTest.getScale((Coverage)targetCoverage);
            GetCoverageTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralEnvelope)targetCoverage.getEnvelope(), scale);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)expectedEnvelope.getCoordinateReferenceSystem()));
            TestCase.assertEquals((int)gridRange.getSpan(0), (int)120);
            TestCase.assertEquals((int)gridRange.getSpan(1), (int)360);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoverageTrimmingSlicingNativeCRSXML() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingSlicingNativeCRSXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{146.49999999999477, -43.5}, new double[]{146.99999999999477, -43.49583333333119});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double scale = GetCoverageTest.getScale((Coverage)targetCoverage);
            GetCoverageTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralEnvelope)targetCoverage.getEnvelope(), scale);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)expectedEnvelope.getCoordinateReferenceSystem()));
            TestCase.assertEquals((int)gridRange.getSpan(1), (int)1);
            TestCase.assertEquals((int)gridRange.getSpan(0), (int)120);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testCoverageTrimmingDuplicatedNativeCRSXML() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingDuplicatedNativeCRSXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
    }

    @Test
    public void testCoverageTrimmingBordersOverlap() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingBordersOverlap.xml");
        this.testCoverageResult(xml, targetCoverage -> {
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{7.0, 40.0}, new double[]{11.0, 43.0});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double pixelSize = 0.057934032977228;
            TestCase.assertTrue((boolean)expectedEnvelope.equals(targetCoverage.getEnvelope(), pixelSize, false));
        });
    }

    @Test
    public void testCoverageTrimmingBordersOverlapVertical() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingBordersOverlapVertical.xml");
        this.testCoverageResult(xml, targetCoverage -> {
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{13.0, 37.0}, new double[]{14.0, 39.0});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double pixelSize = 0.057934032977228;
            TestCase.assertTrue((boolean)expectedEnvelope.equals(targetCoverage.getEnvelope(), pixelSize, false));
        });
    }

    @Test
    public void testCoverageTrimmingBordersOverlapOutside() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTrimmingBordersOverlapOutside.xml");
        this.testCoverageResult(xml, targetCoverage -> {
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{6.344, 40.0}, new double[]{11.0, 46.59});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double pixelSize = 0.057934032977228;
            TestCase.assertTrue((boolean)expectedEnvelope.equals(targetCoverage.getEnvelope(), pixelSize, false));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testCoverageResult(File xml, GridTester tester) throws Exception {
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("borderOverlap", "borderOverlap.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            tester.test(targetCoverage);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoverageSlicingLongitudeNativeCRSXML() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageSlicingLongitudeNativeCRSXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{146.5, -44.49999999999784}, new double[]{146.50416666666143, -42.99999999999787});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double scale = GetCoverageTest.getScale((Coverage)targetCoverage);
            GetCoverageTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralEnvelope)targetCoverage.getEnvelope(), scale);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)expectedEnvelope.getCoordinateReferenceSystem()));
            TestCase.assertEquals((int)gridRange.getSpan(0), (int)1);
            TestCase.assertEquals((int)gridRange.getSpan(1), (int)360);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoverageSlicingLatitudeNativeCRSXML() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageSlicingLatitudeNativeCRSXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralEnvelope expectedEnvelope = new GeneralEnvelope(new double[]{146.49999999999477, -43.499999999997854}, new double[]{147.99999999999474, -43.49583333333119});
            expectedEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326", (boolean)true));
            double scale = GetCoverageTest.getScale((Coverage)targetCoverage);
            GetCoverageTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralEnvelope)targetCoverage.getEnvelope(), scale);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)expectedEnvelope.getCoordinateReferenceSystem()));
            TestCase.assertEquals((int)gridRange.getSpan(1), (int)1);
            TestCase.assertEquals((int)gridRange.getSpan(0), (int)360);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testCoverageTimeSlicingNoTimeConfigured() throws Exception {
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__watertemp");
        request = request.replace("${slicePoint}", "2000-10-31T00:00:00.000Z");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel.getExceptionCode(), null);
    }

    @Test
    public void testCoverageTimeSlicingTimeBefore() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__watertemp");
        request = request.replace("${slicePoint}", "2000-10-31T00:00:00.000Z");
        this.checkWaterTempValue(request, 14.897999757668003);
    }

    @Test
    public void testCoverageTimeSlicingTimeFirst() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__watertemp");
        request = request.replace("${slicePoint}", "2008-10-31T00:00:00.000Z");
        this.checkWaterTempValue(request, 14.897999757668003);
    }

    @Test
    public void testCoverageTimeSlicingTimeClosest() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__watertemp");
        request = request.replace("${slicePoint}", "2000-10-31T11:30:00.000Z");
        this.checkWaterTempValue(request, 14.897999757668003);
    }

    @Test
    public void testCoverageTimeSlicingTimeSecond() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.LIST, null);
        System.out.println(this.getDataDirectory().root());
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__watertemp");
        request = request.replace("${slicePoint}", "2008-11-01T00:00:00.000Z");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    @Test
    public void testCoverageTimeSlicingTimeAfter() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__watertemp");
        request = request.replace("${slicePoint}", "2011-11-01T00:00:00.000Z");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    @Test
    public void testCoverageTimeSlicingAgainstFirstRange() throws Exception {
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "elevation", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePoint}", "2008-10-31T00:00:00.000Z");
        this.checkWaterTempValue(request, 18.478999927756377);
    }

    @Test
    public void testCoverageTimeSlicingAgainstRangeHole() throws Exception {
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "elevation", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePoint}", "2008-11-04T11:00:00.000Z");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    @Test
    public void testCoverageTimeSlicingAgainstSecondRange() throws Exception {
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "elevation", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePoint}", "2008-11-06T00:00:00.000Z");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    @Test
    public void testCoverageTimeElevationSlicingAgainstLowestOldestGranule() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeElevationCustomSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePointElevation}", "20");
        request = request.replace("${slicePointTime}", "2008-10-31T00:00:00.000Z");
        request = request.replace("${Custom}", "WAVELENGTH");
        request = request.replace("${slicePointCustom}", "20");
        this.checkWaterTempValue(request, 18.478999927756377);
        request = request.replace("WAVELENGTH", "wavelength");
        this.checkWaterTempValue(request, 18.478999927756377);
    }

    @Test
    public void testCoverageTimeElevationSlicingAgainstHighestNewestGranuleLatestWavelength() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeElevationCustomSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePointElevation}", "140");
        request = request.replace("${slicePointTime}", "2008-11-07T00:00:00.000Z");
        request = request.replace("${Custom}", "WAVELENGTH");
        request = request.replace("${slicePointCustom}", "80");
        this.checkWaterTempValue(request, 14.529999740188941);
        request = request.replace("WAVELENGTH", "wavelength");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    @Test
    public void testCoverageMultipleCustomSubsets() throws Exception {
        this.setupTimeRangesTimeElevationCustom(CUSTOMDIMS, "time", "elevation", "WAVELENGTH");
        this.setupRasterDimension(this.getLayerId(CUSTOMDIMS), "custom_dimension_CUSTOM", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageMultipleCustomSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__customdimensions");
        request = request.replace("${slicePointElevation}", "140");
        request = request.replace("${slicePointTime}", "2008-11-07T00:00:00.000Z");
        request = request.replace("${CustomOne}", "WAVELENGTH");
        request = request.replace("${slicePointCustomOne}", "80");
        request = request.replace("${CustomTwo}", "CUSTOM");
        request = request.replace("${slicePointCustomTwo}", "99");
        this.checkWaterTempValue(request, 14.529999740188941);
        request = request.replace("WAVELENGTH", "wavelength").replace("CUSTOM", "custom");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    @Test
    public void testCoverageTimeElevationSlicingAgainstHighestNewestGranule() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeElevationSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePointElevation}", "140");
        request = request.replace("${slicePointTime}", "2008-11-07T00:00:00.000Z");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    @Test
    public void testCoverageElevationSlicingDefaultTime() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageElevationSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePoint}", "140");
        this.checkWaterTempValue(request, 14.529999740188941);
    }

    private void setupTimeRangesTimeElevationCustom(QName timeranges, String time, String elevation, String customDimensionName) {
        this.setupRasterDimension(this.getLayerId(timeranges), time, DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(timeranges), elevation, DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(timeranges), "custom_dimension_" + customDimensionName, DimensionPresentation.LIST, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWaterTempValue(String request, double expectedValue) throws Exception, IOException, DataSourceException {
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            GridCoverage2DReader sourceReader = (GridCoverage2DReader)this.getCatalog().getCoverageByName(this.getLayerId(WATTEMP)).getGridCoverageReader(null, null);
            GeneralEnvelope expectedEnvelope = sourceReader.getOriginalEnvelope();
            GetCoverageTest.assertEnvelopeEquals(expectedEnvelope, 1.0, (GeneralEnvelope)targetCoverage.getEnvelope(), 1.0);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)expectedEnvelope.getCoordinateReferenceSystem()));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GridEnvelope expectedGridRange = sourceReader.getOriginalGridRange();
            TestCase.assertEquals((int)gridRange.getSpan(0), (int)expectedGridRange.getSpan(0));
            TestCase.assertEquals((int)gridRange.getSpan(1), (int)expectedGridRange.getSpan(1));
            double[] pixel = new double[1];
            targetCoverage.getRenderedImage().getData().getPixel(1, 24, pixel);
            TestCase.assertEquals((double)expectedValue, (double)pixel[0], (double)1.0E-6);
        }
        finally {
            readerTarget.dispose();
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
    }

    @Test
    public void testDatelineCrossingMinGreaterThanMax() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageAcrossDateline.xml");
        this.checkDatelineCrossing(xml);
    }

    @Test
    public void testDatelineCrossingPositiveCoordinates() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageAcrossDateline2.xml");
        this.checkDatelineCrossing(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatelineCrossing(File xml) throws IOException, Exception, DataSourceException {
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("rain_gtiff", "rain_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Envelope2D envelope = targetCoverage.getEnvelope2D();
            TestCase.assertEquals((double)160.0, (double)envelope.getMinX(), (double)0.0);
            TestCase.assertEquals((double)0.0, (double)envelope.getMinY(), (double)0.0);
            TestCase.assertEquals((double)200.0, (double)envelope.getMaxX(), (double)0.0);
            TestCase.assertEquals((double)40.0, (double)envelope.getMaxY(), (double)0.0);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)targetCoverage.getCoordinateReferenceSystem2D()));
            Raster data = targetCoverage.getRenderedImage().getData();
            double[] pixel = new double[1];
            for (int i = data.getMinY(); i < data.getMinY() + data.getHeight(); ++i) {
                for (int j = data.getMinX(); j < data.getMinX() + data.getWidth(); ++j) {
                    data.getPixel(i, j, pixel);
                    double d = pixel[0];
                    TestCase.assertTrue((String)String.valueOf(d), (d > 500.0 && d < 5500.0 ? 1 : 0) != 0);
                }
            }
        }
        finally {
            readerTarget.dispose();
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatelineCrossingPolar() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageAcrossDatelinePolar.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("polar_gtiff", "polar_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Envelope2D envelope = targetCoverage.getEnvelope2D();
            TestCase.assertEquals((double)-1139998.0, (double)envelope.getMinX(), (double)1.0);
            TestCase.assertEquals((double)-3333134.0, (double)envelope.getMinY(), (double)1.0);
            TestCase.assertEquals((double)1139998.0, (double)envelope.getMaxX(), (double)1.0);
            TestCase.assertEquals((double)-1023493.0, (double)envelope.getMaxY(), (double)1.0);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:3031", (boolean)true), (Object)targetCoverage.getCoordinateReferenceSystem2D()));
        }
        finally {
            readerTarget.dispose();
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatelineCrossingMercatorPDC() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageAcrossDatelineMercatorPacific.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("polar_gtiff", "polar_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Envelope2D envelope = targetCoverage.getEnvelope2D();
            TestCase.assertEquals((double)160.0, (double)envelope.getMinX(), (double)0.0);
            TestCase.assertEquals((double)0.0, (double)envelope.getMinY(), (double)0.0);
            TestCase.assertEquals((double)200.0, (double)envelope.getMaxX(), (double)0.0);
            TestCase.assertEquals((double)40.0, (double)envelope.getMaxY(), (double)0.0);
            TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)targetCoverage.getCoordinateReferenceSystem2D()));
            RenderedImage renderedImage = targetCoverage.getRenderedImage();
            Raster data = renderedImage.getData();
            double[] pixel = new double[1];
            for (int i = data.getMinY(); i < data.getMinY() + data.getHeight(); ++i) {
                for (int j = data.getMinX(); j < data.getMinX() + data.getWidth(); ++j) {
                    data.getPixel(i, j, pixel);
                    double d = pixel[0];
                    TestCase.assertTrue((String)String.valueOf(d), (d > 500.0 && d < 5500.0 ? 1 : 0) != 0);
                }
            }
        }
        finally {
            readerTarget.dispose();
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeferredLoading() throws Exception {
        DefaultWebCoverageService20 wcs = (DefaultWebCoverageService20)GeoServerExtensions.bean(DefaultWebCoverageService20.class);
        GetCoverageType getCoverage = Wcs20Factory.eINSTANCE.createGetCoverageType();
        getCoverage.setCoverageId(this.getLayerId(SPATIO_TEMPORAL));
        getCoverage.setVersion("2.0.0");
        getCoverage.setService("WCS");
        GridCoverage coverage = null;
        try {
            coverage = wcs.getCoverage(getCoverage);
            Assert.assertNotNull((Object)coverage);
            this.assertDeferredLoading(coverage.getRenderedImage());
        }
        finally {
            this.scheduleForCleaning(coverage);
        }
    }

    @Test
    public void testInvalidElevationTrimmingOutsideRange() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageDimensionTrimmingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${dimension}", "elevation");
        request = request.replace("${trimLow}", "-500");
        request = request.replace("${trimHigh}", "-400");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        String errorMessage = this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), "subset");
        TestCase.assertEquals((String)"Requested elevation subset does not intersect the declared range 20.0/150.0", (String)errorMessage);
    }

    @Test
    public void testInvalidElevationTrimmingInsideRange() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageDimensionTrimmingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${dimension}", "elevation");
        request = request.replace("${trimLow}", "99.5");
        request = request.replace("${trimHigh}", "99.7");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        String errorMessage = this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), "subset");
        TestCase.assertEquals((String)"Requested elevation subset does not intersect available values [[20.0, 99.0], [100.0, 150.0]]", (String)errorMessage);
    }

    @Test
    public void testInvalidTimeTrimmingOutsideRange() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageDimensionTrimmingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${dimension}", "time");
        request = request.replace("${trimLow}", "1990-11-01T00:00:00.000Z");
        request = request.replace("${trimHigh}", "1991-11-01T00:00:00.000Z");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        String errorMessage = this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), "subset");
        TestCase.assertEquals((String)"Requested time subset does not intersect the declared range 2008-10-31T00:00:00.000Z/2008-11-07T00:00:00.000Z", (String)errorMessage);
    }

    @Test
    public void testInvalidTimeTrimmingInsideRange() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP_DILATED), "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(WATTEMP_DILATED), "elevation", DimensionPresentation.LIST, null);
        File xml = new File("./src/test/resources/trimming/requestGetCoverageDimensionTrimmingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__watertemp_dilated");
        request = request.replace("${dimension}", "time");
        request = request.replace("${trimLow}", "2008-11-01T11:00:00.000Z");
        request = request.replace("${trimHigh}", "2008-11-01T12:01:00.000Z");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        String errorMessage = this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), "subset");
        TestCase.assertEquals((String)"Requested time subset does not intersect available values [2008-10-31T00:00:00.000Z, 2008-11-03T00:00:00.000Z]", (String)errorMessage);
    }

    @Test
    public void testInvalidCustomDimensionSlicing() throws Exception {
        this.setupTimeRangesTimeElevationCustom(TIMERANGES, "time", "elevation", "WAVELENGTH");
        File xml = new File("./src/test/resources/trimming/requestGetCoverageTimeElevationCustomSlicingXML.xml");
        String request = FileUtils.readFileToString((File)xml);
        request = request.replace("${coverageId}", "sf__timeranges");
        request = request.replace("${slicePointElevation}", "20");
        request = request.replace("${slicePointTime}", "2008-10-31T00:00:00.000Z");
        request = request.replace("${Custom}", "WAVELENGTH");
        request = request.replace("${slicePointCustom}", "-300");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        String errorMessage = this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), "subset");
        TestCase.assertEquals((String)"Requested WAVELENGTH subset does not intersect the available values [12/24, 25/80]", (String)errorMessage);
        request = request.replace("WAVELENGTH", "wavelength");
        response = this.postAsServletResponse("wcs", request);
        errorMessage = this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), "subset");
        TestCase.assertEquals((String)"Requested WAVELENGTH subset does not intersect the available values [12/24, 25/80]", (String)errorMessage);
    }

    @FunctionalInterface
    public static interface GridTester {
        public void test(GridCoverage2D var1) throws Exception;
    }
}

