/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class ScaleKvpTest
extends WCSKVPTestSupport {
    private Logger LOGGER = Logging.getLogger(ScaleKvpTest.class);
    private String axisPrefix;
    private String subsetPrefix;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"", ""}, {"http://www.opengis.net/def/axis/OGC/1/", "http://www.opengis.net/def/axis/OGC/0/"});
    }

    public ScaleKvpTest(String axisPrefix, String subsetPrefix) {
        this.axisPrefix = axisPrefix;
        this.subsetPrefix = subsetPrefix;
    }

    @Test
    public void capabilties() throws Exception {
        File xml = new File("./src/test/resources/getcapabilities/getCap.xml");
        String request = FileUtils.readFileToString((File)xml);
        Document dom = this.postAsDOM("wcs", request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_range-subsetting/1.0/conf/record-subsetting'])", (Document)dom);
        dom = this.getAsDOM("wcs?request=Getcapabilities&service=wCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleFactor() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=0.5");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) / 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) / 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=2");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        tiffContents = this.getBinary(response);
        file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        readerTarget = new GeoTiffReader((Object)file);
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) * 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) * 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=0");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "0.0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=-12");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "-12.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleAxesByFactor() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(0.5)," + this.axisPrefix + "j(0.5)");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) / 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) / 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(2)," + this.axisPrefix + "j(2)");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        tiffContents = this.getBinary(response);
        file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        readerTarget = new GeoTiffReader((Object)file);
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) * 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) * 2), (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(0)," + this.axisPrefix + "j(0.5)");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "0.0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(-1)," + this.axisPrefix + "j(0.5)");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "-1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleToSize() throws Exception {
        GeneralEnvelope finalEnvelope;
        File file;
        byte[] tiffContents;
        MockHttpServletResponse response;
        Envelope2D sourceEnvelope;
        GeoTiffReader readerTarget = null;
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.x + "," + (sourceEnvelope.x + sourceEnvelope.width / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.y + "," + (sourceEnvelope.y + sourceEnvelope.height / 2.0) + ")&SCALESIZE=" + this.axisPrefix + "i(50)," + this.axisPrefix + "j(50)");
            TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            finalEnvelope = new GeneralEnvelope(new double[]{sourceEnvelope.x, sourceEnvelope.y}, new double[]{sourceEnvelope.x + sourceEnvelope.width / 2.0, sourceEnvelope.y + sourceEnvelope.height / 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((int)50, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)50, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((double)29.0, (double)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0], (double)1.0);
        }
        catch (Throwable throwable) {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            throw throwable;
        }
        try {
            readerTarget.dispose();
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)sourceCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALESIZE=" + this.axisPrefix + "i(1000)," + this.axisPrefix + "j(1000)&&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.x + "," + (sourceEnvelope.x + sourceEnvelope.width / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.y + "," + (sourceEnvelope.y + sourceEnvelope.height / 2.0) + ")");
            TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            finalEnvelope = new GeneralEnvelope(new double[]{sourceEnvelope.x, sourceEnvelope.y}, new double[]{sourceEnvelope.x + sourceEnvelope.width * 2.0, sourceEnvelope.y + sourceEnvelope.height * 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((Object)29.0, (Object)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0]);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        MockHttpServletResponse response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALESIZE=" + this.axisPrefix + "i(100)," + this.axisPrefix + "j(0)");
        TestCase.assertEquals((String)"application/xml", (String)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALESIZE=" + this.axisPrefix + "i(-2)," + this.axisPrefix + "j(100)");
        TestCase.assertEquals((String)"application/xml", (String)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "-2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleToExtent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(0,99)," + this.axisPrefix + "j(0,99)");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        tiffContents = this.getBinary(response);
        file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        readerTarget = new GeoTiffReader((Object)file);
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            TestCase.assertEquals((int)999, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            TestCase.assertEquals((int)999, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        try {
            targetCoverage = (GridCoverage2D)this.executeGetCoverage("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)");
            TestCase.assertNotNull((Object)targetCoverage);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            TestCase.assertEquals((int)1099, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            TestCase.assertEquals((int)1099, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,0)," + this.axisPrefix + "j(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,1000)," + this.axisPrefix + "j(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,0)," + this.axisPrefix + "i(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,1000)," + this.axisPrefix + "i(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleToExtentWithTrim() throws Exception {
        GeneralEnvelope finalEnvelope;
        File file;
        byte[] tiffContents;
        MockHttpServletResponse response;
        Envelope2D sourceEnvelope;
        GeoTiffReader readerTarget = null;
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(50,149)," + this.axisPrefix + "j(50,149)&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.x + "," + (sourceEnvelope.x + sourceEnvelope.width / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.y + "," + (sourceEnvelope.y + sourceEnvelope.height / 2.0) + ")");
            TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            finalEnvelope = new GeneralEnvelope(new double[]{sourceEnvelope.x, sourceEnvelope.y}, new double[]{sourceEnvelope.x + sourceEnvelope.width / 2.0, sourceEnvelope.y + sourceEnvelope.height / 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((Object)29.0, (Object)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0]);
        }
        catch (Throwable throwable) {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            throw throwable;
        }
        try {
            readerTarget.dispose();
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)sourceCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.x + "," + (sourceEnvelope.x + sourceEnvelope.width / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.y + "," + (sourceEnvelope.y + sourceEnvelope.height / 2.0) + ")");
            TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            finalEnvelope = new GeneralEnvelope(new double[]{sourceEnvelope.x, sourceEnvelope.y}, new double[]{sourceEnvelope.x + sourceEnvelope.width / 2.0, sourceEnvelope.y + sourceEnvelope.height / 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            TestCase.assertEquals((int)999, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            TestCase.assertEquals((int)999, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
            TestCase.assertEquals((Object)29.0, (Object)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0]);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        try {
            targetCoverage = (GridCoverage2D)this.executeGetCoverage("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)");
            TestCase.assertNotNull((Object)targetCoverage);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)1000, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            TestCase.assertEquals((int)100, (int)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            TestCase.assertEquals((int)1099, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            TestCase.assertEquals((int)1099, (int)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        MockHttpServletResponse response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,0)," + this.axisPrefix + "j(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,1000)," + this.axisPrefix + "j(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,0)," + this.axisPrefix + "i(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,1000)," + this.axisPrefix + "i(0,1000)");
        TestCase.assertEquals((String)"application/xml", (String)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRequests() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 8);
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (int i = 0; i < 100; ++i) {
                Future future = executor.submit(() -> {
                    MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=0.5");
                    TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
                    return null;
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }
}

