/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.io.File;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.junit.Test;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class RangeSubsetKvpTest
extends WCSKVPTestSupport {
    private Logger LOGGER = Logging.getLogger(RangeSubsetKvpTest.class);

    @Test
    public void capabilties() throws Exception {
        Document dom = this.getAsDOM("wcs?reQueSt=GetCapabilities&seErvIce=WCS");
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_range-subsetting/1.0/conf/record-subsetting'])", (Document)dom);
        dom = this.getAsDOM("wcs?request=Getcapabilities&service=wCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    @Test
    public void test9to3() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__multiband&&Format=image/tiff&RANGESUBSET=Band1,Band6,Band7");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        TestCase.assertEquals((int)68, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)56, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)3, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void test9to4() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__multiband&&Format=image/tiff&RANGESUBSET=Band1,Band6,Band9,Band4");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        TestCase.assertEquals((int)68, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)56, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)4, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void test9to7() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__multiband&&Format=image/tiff&RANGESUBSET=Band1,Band6,Band4,Band9,Band8,Band7,Band2");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        TestCase.assertEquals((int)68, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)56, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)7, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void testBasic() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&RANGESUBSET=RED_BAND");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)1, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void testRange() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&RANGESUBSET=RED_BAND:BLUE_BAND");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)3, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void mixed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&RANGESUBSET=RED_BAND:BLUE_BAND,RED_BAND,GREEN_BAND");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)5, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void testWrong() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&RANGESUBSET=Band1,GREEN_BAND");
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.NoSuchField.getExceptionCode(), "Band1");
    }
}

