/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.opengis.wcs20.InterpolationAxisType;
import net.opengis.wcs20.InterpolationType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wcs2_0.kvp.InterpolationKvpParser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InterpolationKvpParserTest
extends GeoServerSystemTestSupport {
    InterpolationKvpParser parser = new InterpolationKvpParser();
    private String axisPrefix;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({""}, {"http://www.opengis.net/def/axis/OGC/1/"});
    }

    public InterpolationKvpParserTest(String axisPrefix) {
        this.axisPrefix = axisPrefix;
    }

    @Test
    public void testInvalidValues() throws Exception {
        try {
            this.parser.parse(":interpolation");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("a:linear,,b:nearest");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("a::linear");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
    }

    private void checkInvalidSyntaxException(OWS20Exception e) {
        Assert.assertNotNull((Object)e.getHttpCode());
        Assert.assertEquals((long)400L, (long)e.getHttpCode().intValue());
        Assert.assertEquals((Object)"InvalidEncodingSyntax", (Object)e.getCode());
        Assert.assertEquals((Object)"interpolation", (Object)e.getLocator());
    }

    @Test
    public void testUniformValue() throws Exception {
        InterpolationType it = (InterpolationType)this.parser.parse("http://www.opengis.net/def/interpolation/OGC/1/linear");
        Assert.assertEquals((Object)"http://www.opengis.net/def/interpolation/OGC/1/linear", (Object)it.getInterpolationMethod().getInterpolationMethod());
    }

    @Test
    public void testSingleAxis() throws Exception {
        InterpolationType it = (InterpolationType)this.parser.parse(this.axisPrefix + "latitude:http://www.opengis.net/def/interpolation/OGC/1/linear");
        EList axes = it.getInterpolationAxes().getInterpolationAxis();
        Assert.assertEquals((long)1L, (long)axes.size());
        Assert.assertEquals((Object)(this.axisPrefix + "latitude"), (Object)((InterpolationAxisType)axes.get(0)).getAxis());
        Assert.assertEquals((Object)"http://www.opengis.net/def/interpolation/OGC/1/linear", (Object)((InterpolationAxisType)axes.get(0)).getInterpolationMethod());
    }

    @Test
    public void testMultiAxis() throws Exception {
        InterpolationType it = (InterpolationType)this.parser.parse(this.axisPrefix + "latitude:http://www.opengis.net/def/interpolation/OGC/1/linear," + this.axisPrefix + "longitude:http://www.opengis.net/def/interpolation/OGC/1/nearest");
        EList axes = it.getInterpolationAxes().getInterpolationAxis();
        Assert.assertEquals((long)2L, (long)axes.size());
        Assert.assertEquals((Object)(this.axisPrefix + "latitude"), (Object)((InterpolationAxisType)axes.get(0)).getAxis());
        Assert.assertEquals((Object)"http://www.opengis.net/def/interpolation/OGC/1/linear", (Object)((InterpolationAxisType)axes.get(0)).getInterpolationMethod());
        Assert.assertEquals((Object)(this.axisPrefix + "longitude"), (Object)((InterpolationAxisType)axes.get(1)).getAxis());
        Assert.assertEquals((Object)"http://www.opengis.net/def/interpolation/OGC/1/nearest", (Object)((InterpolationAxisType)axes.get(1)).getInterpolationMethod());
    }

    @Test
    public void testParserForVersion() throws Exception {
        List parsers = GeoServerExtensions.extensions(KvpParser.class);
        KvpParser parser = KvpUtils.findParser((String)"interpolation", (String)"WCS", null, (String)"2.0.0", (Collection)parsers);
        Assert.assertNotNull((Object)parser);
        Assert.assertEquals(parser.getClass(), InterpolationKvpParser.class);
        parser = KvpUtils.findParser((String)"interpolation", (String)"WCS", null, (String)"2.0.1", (Collection)parsers);
        Assert.assertNotNull((Object)parser);
        Assert.assertEquals(parser.getClass(), InterpolationKvpParser.class);
    }
}

