/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.InterpolationType;
import net.opengis.wcs20.RangeItemType;
import net.opengis.wcs20.RangeSubsetType;
import net.opengis.wcs20.ScaleAxisByFactorType;
import net.opengis.wcs20.ScaleAxisType;
import net.opengis.wcs20.ScaleByFactorType;
import net.opengis.wcs20.ScaleToExtentType;
import net.opengis.wcs20.ScaleToSizeType;
import net.opengis.wcs20.ScalingType;
import net.opengis.wcs20.TargetAxisExtentType;
import net.opengis.wcs20.TargetAxisSizeType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataSourceException;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetCoverageKvpTest
extends WCSKVPTestSupport {
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), "raster-filter-test.zip", null, null, SystemTestData.class, this.getCatalog());
    }

    @Test
    public void testParseBasic() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage");
        TestCase.assertEquals((String)"theCoverage", (String)gc.getCoverageId());
    }

    @Test
    public void testGetCoverageNoWs() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=BlueMarble&Format=image/tiff");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
    }

    @Test
    public void testGetCoverageNativeFormat() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__rain");
        TestCase.assertEquals((String)"text/plain", (String)response.getContentType());
    }

    @Test
    public void testNotExistent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=NotThere&&Format=image/tiff");
        this.checkOws20Exception(response, 404, "NoSuchCoverage", "coverageId");
    }

    @Test
    public void testGetCoverageLocalWs() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs/wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=BlueMarble&&Format=image/tiff");
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
    }

    @Test
    public void testExtensionScaleFactor() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scaleFactor=2");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        TestCase.assertEquals((int)1, (int)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleByFactorType sbf = scaling.getScaleByFactor();
        TestCase.assertEquals((double)2.0, (double)sbf.getScaleFactor(), (double)0.0);
    }

    @Test
    public void testExtensionScaleAxes() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scaleaxes=http://www.opengis.net/def/axis/OGC/1/i(3.5),http://www.opengis.net/def/axis/OGC/1/j(5.0),http://www.opengis.net/def/axis/OGC/1/k(2.0)");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        TestCase.assertEquals((int)1, (int)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleAxisByFactorType sax = scaling.getScaleAxesByFactor();
        EList saxes = sax.getScaleAxis();
        TestCase.assertEquals((int)3, (int)saxes.size());
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/i", (String)((ScaleAxisType)saxes.get(0)).getAxis());
        TestCase.assertEquals((double)3.5, (double)((ScaleAxisType)saxes.get(0)).getScaleFactor(), (double)0.0);
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/j", (String)((ScaleAxisType)saxes.get(1)).getAxis());
        TestCase.assertEquals((double)5.0, (double)((ScaleAxisType)saxes.get(1)).getScaleFactor(), (double)0.0);
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/k", (String)((ScaleAxisType)saxes.get(2)).getAxis());
        TestCase.assertEquals((double)2.0, (double)((ScaleAxisType)saxes.get(2)).getScaleFactor(), (double)0.0);
    }

    @Test
    public void testExtensionScaleSize() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scalesize=http://www.opengis.net/def/axis/OGC/1/i(1000),http://www.opengis.net/def/axis/OGC/1/j(1000),http://www.opengis.net/def/axis/OGC/1/k(10)");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        TestCase.assertEquals((int)1, (int)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleToSizeType sts = scaling.getScaleToSize();
        EList scaleAxes = sts.getTargetAxisSize();
        TestCase.assertEquals((int)3, (int)scaleAxes.size());
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/i", (String)((TargetAxisSizeType)scaleAxes.get(0)).getAxis());
        TestCase.assertEquals((double)1000.0, (double)((TargetAxisSizeType)scaleAxes.get(0)).getTargetSize(), (double)0.0);
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/j", (String)((TargetAxisSizeType)scaleAxes.get(1)).getAxis());
        TestCase.assertEquals((double)1000.0, (double)((TargetAxisSizeType)scaleAxes.get(1)).getTargetSize(), (double)0.0);
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/k", (String)((TargetAxisSizeType)scaleAxes.get(2)).getAxis());
        TestCase.assertEquals((double)10.0, (double)((TargetAxisSizeType)scaleAxes.get(2)).getTargetSize(), (double)0.0);
    }

    @Test
    public void testExtensionScaleExtent() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scaleextent=http://www.opengis.net/def/axis/OGC/1/i(10,20),http://www.opengis.net/def/axis/OGC/1/j(20,30)");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        TestCase.assertEquals((int)1, (int)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleToExtentType ste = scaling.getScaleToExtent();
        TestCase.assertEquals((int)2, (int)ste.getTargetAxisExtent().size());
        TargetAxisExtentType tax = (TargetAxisExtentType)ste.getTargetAxisExtent().get(0);
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/i", (String)tax.getAxis());
        TestCase.assertEquals((double)10.0, (double)tax.getLow(), (double)0.0);
        TestCase.assertEquals((double)20.0, (double)tax.getHigh(), (double)0.0);
        tax = (TargetAxisExtentType)ste.getTargetAxisExtent().get(1);
        TestCase.assertEquals((String)"http://www.opengis.net/def/axis/OGC/1/j", (String)tax.getAxis());
        TestCase.assertEquals((double)20.0, (double)tax.getLow(), (double)0.0);
        TestCase.assertEquals((double)30.0, (double)tax.getHigh(), (double)0.0);
    }

    @Test
    public void testExtensionRangeSubset() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&rangesubset=band01,band03:band05,band10,band19:band21");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        TestCase.assertEquals((int)1, (int)extensions.size());
        RangeSubsetType rangeSubset = (RangeSubsetType)extensions.get("http://www.opengis.net/wcs/range-subsetting/1.0:RangeSubset");
        EList items = rangeSubset.getRangeItems();
        TestCase.assertEquals((int)4, (int)items.size());
        RangeItemType i1 = (RangeItemType)items.get(0);
        TestCase.assertEquals((String)"band01", (String)i1.getRangeComponent());
        RangeItemType i2 = (RangeItemType)items.get(1);
        TestCase.assertEquals((String)"band03", (String)i2.getRangeInterval().getStartComponent());
        TestCase.assertEquals((String)"band05", (String)i2.getRangeInterval().getEndComponent());
        RangeItemType i3 = (RangeItemType)items.get(2);
        TestCase.assertEquals((String)"band10", (String)i3.getRangeComponent());
        RangeItemType i4 = (RangeItemType)items.get(3);
        TestCase.assertEquals((String)"band19", (String)i4.getRangeInterval().getStartComponent());
        TestCase.assertEquals((String)"band21", (String)i4.getRangeInterval().getEndComponent());
    }

    @Test
    public void testExtensionCRS() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&SUBSETTINGCRS=http://www.opengis.net/def/crs/EPSG/0/4326&outputcrs=http://www.opengis.net/def/crs/EPSG/0/32632");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        TestCase.assertEquals((int)2, (int)extensions.size());
        TestCase.assertEquals((Object)"http://www.opengis.net/def/crs/EPSG/0/4326", (Object)extensions.get("http://www.opengis.net/wcs/service-extension/crs/1.0:subsettingCrs"));
        TestCase.assertEquals((Object)"http://www.opengis.net/def/crs/EPSG/0/32632", (Object)extensions.get("http://www.opengis.net/wcs/service-extension/crs/1.0:outputCrs"));
    }

    @Test
    public void testExtensionInterpolationLinear() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&interpolation=http://www.opengis.net/def/interpolation/OGC/1/linear");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        InterpolationType interp = (InterpolationType)extensions.get("http://www.opengis.net/WCS_service-extension_interpolation/1.0:Interpolation");
        TestCase.assertEquals((String)"http://www.opengis.net/def/interpolation/OGC/1/linear", (String)interp.getInterpolationMethod().getInterpolationMethod());
    }

    @Test
    public void testExtensionInterpolationMixed() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&interpolation=http://www.opengis.net/def/interpolation/OGC/1/linear");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        InterpolationType interp = (InterpolationType)extensions.get("http://www.opengis.net/WCS_service-extension_interpolation/1.0:Interpolation");
        TestCase.assertEquals((String)"http://www.opengis.net/def/interpolation/OGC/1/linear", (String)interp.getInterpolationMethod().getInterpolationMethod());
    }

    @Test
    public void testExtensionOverview() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&overviewPolicy=QUALITY");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        TestCase.assertEquals((int)1, (int)extensions.size());
        String overviewPolicy = (String)extensions.get("http://www.geoserver.org/WCS_service-extension_overviewpolicy/1.0:OverviewPolicy");
        TestCase.assertEquals((String)overviewPolicy, (String)"QUALITY");
    }

    @Test
    public void testGetMissingCoverage() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=notThereBaby");
        this.checkOws20Exception(response, 404, "NoSuchCoverage", "coverageId");
    }

    @Test
    public void testCqlFilterRed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&CQL_FILTER=location like 'red%25'");
        this.assertOriginPixelColor(response, new int[]{255, 0, 0});
    }

    @Test
    public void testCqlFilterGreen() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&CQL_FILTER=location like 'green%25'");
        this.assertOriginPixelColor(response, new int[]{0, 255, 0});
    }

    @Test
    public void testSortByLocationAscending() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&sortBy=location");
        this.assertOriginPixelColor(response, new int[]{0, 255, 0});
    }

    @Test
    public void testSortByLocationDescending() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&sortBy=location D");
        this.assertOriginPixelColor(response, new int[]{255, 255, 0});
    }

    private void assertOriginPixelColor(MockHttpServletResponse response, int[] expected) throws DataSourceException, IOException {
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] bytes = response.getContentAsByteArray();
        GeoTiffReader reader = new GeoTiffReader((Object)new ByteArrayInputStream(bytes));
        GridCoverage2D coverage = reader.read(null);
        Raster raster = coverage.getRenderedImage().getData();
        int[] pixel = new int[3];
        raster.getPixel(0, 0, pixel);
        Assert.assertThat((Object)pixel, (Matcher)CoreMatchers.equalTo((Object)expected));
    }
}

