/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.io.ByteArrayInputStream;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GMLGetCoverageKVPTest
extends WCSTestSupport {
    private static final double DELTA = 1.0E-6;

    @Test
    public void gmlFormat() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&format=application%2Fgml%2Bxml");
        Assert.assertEquals((Object)"application/gml+xml", (Object)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
    }

    @Test
    public void gmlFormatCoverageBandDetails() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo c = catalog.getCoverageByName("wcs", "BlueMarble");
        List dimensions = c.getDimensions();
        CoverageDimensionInfo dimension = (CoverageDimensionInfo)dimensions.get(0);
        Assert.assertEquals((Object)"RED_BAND", (Object)dimension.getName());
        NumberRange range = dimension.getRange();
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)range.getMinimum(), (double)1.0E-6);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)range.getMaximum(), (double)1.0E-6);
        Assert.assertEquals((Object)"GridSampleDimension[-Infinity,Infinity]", (Object)dimension.getDescription());
        List nullValues = dimension.getNullValues();
        Assert.assertEquals((long)0L, (long)nullValues.size());
        Assert.assertEquals((Object)"W.m-2.Sr-1", (Object)dimension.getUnit());
        int i = 1;
        for (CoverageDimensionInfo dimensionInfo : dimensions) {
            dimensionInfo.getNullValues().add(-999.0);
            dimensionInfo.setDescription("GridSampleDimension[-100.0,1000.0]");
            dimensionInfo.setUnit("m");
            dimensionInfo.setRange(NumberRange.create((int)-100, (int)1000));
            dimensionInfo.setName("Band" + i++);
        }
        catalog.save((ResourceInfo)c);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&format=application%2Fgml%2Bxml");
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        String name = xpath.evaluate("//swe:field/@name", dom);
        Assert.assertEquals((Object)"Band1", (Object)name);
        String interval = xpath.evaluate("//swe:interval", dom);
        Assert.assertEquals((Object)"-100 1000", (Object)interval);
        String unit = xpath.evaluate("//swe:uom/@code", dom);
        Assert.assertEquals((Object)"m", (Object)unit);
        String noData = xpath.evaluate("//swe:nilValue", dom);
        Assert.assertEquals((Object)"-999.0", (Object)noData);
    }
}

