/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class DescribeCoverageTest
extends WCSTestSupport {
    protected static final String DESCRIBE_URL = "wcs?service=WCS&version=2.0.1&request=DescribeCoverage";
    private static final QName MOSAIC = new QName(MockData.SF_URI, "rasterFilter", MockData.SF_PREFIX);
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    protected static QName WATTEMP = new QName(MockData.SF_URI, "watertemp", MockData.SF_PREFIX);
    protected static QName TIMERANGES = new QName(MockData.SF_URI, "timeranges", MockData.SF_PREFIX);
    protected static QName MULTIDIM = new QName(MockData.SF_URI, "multidim", MockData.SF_PREFIX);
    protected static QName PK50095 = new QName(MockData.SF_URI, "pk50095", MockData.SF_PREFIX);

    @Before
    public void clearDimensions() {
        this.clearDimensions(this.getLayerId(WATTEMP));
        this.clearDimensions(this.getLayerId(TIMERANGES));
        this.clearDimensions(this.getLayerId(MULTIDIM));
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(MOSAIC, "raster-filter-test.zip", null, this.getCatalog());
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(WATTEMP, "watertemp.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(TIMERANGES, "timeranges.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(MULTIDIM, "multidim.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(PK50095, "wi-utm.zip", null, null, SystemTestData.class, this.getCatalog());
    }

    @Test
    public void testBasicKVP() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=wcs__BlueMarble");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testProjectectedKVP() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=wcs__utm11");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"E N", (String)"//gml:boundedBy/gml:Envelope/@axisLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testCustomUnit() throws Exception {
        CoverageInfo ciRain = this.getCatalog().getCoverageByName(this.getLayerId(RAIN));
        ((CoverageDimensionInfo)ciRain.getDimensions().get(0)).setUnit("mm");
        this.getCatalog().save((ResourceInfo)ciRain);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__rain");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:CoverageDescription/gmlcov:rangeType/swe:DataRecord/swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"rain", (String)"//wcs:CoverageDescription/gmlcov:rangeType//swe:DataRecord/swe:field/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"mm", (String)"//wcs:CoverageDescription/gmlcov:rangeType/swe:DataRecord/swe:field/swe:Quantity/swe:uom/@code", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"text/plain", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testAxisOrderUtm() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__pk50095");
        Assert.assertNotNull((Object)dom);
        this.print(dom, System.out);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"347660.5162105911 5191763.949937257", (String)"//gml:boundedBy/gml:Envelope/gml:lowerCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"353440.1129425911 5196950.767517257", (String)"//gml:boundedBy/gml:Envelope/gml:upperCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"+1 +2", (String)"//gml:coverageFunction/gml:GridFunction/gml:sequenceRule/@axisOrder", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"347671.1015525911 5196940.182175256", (String)"//gml:domainSet/gml:RectifiedGrid/gml:origin/gml:Point/gml:pos", (Document)dom);
    }

    @Test
    public void testCustomNullValue() throws Exception {
        CoverageInfo ciRain = this.getCatalog().getCoverageByName(this.getLayerId(RAIN));
        CoverageDimensionImpl dimension = (CoverageDimensionImpl)ciRain.getDimensions().get(0);
        ArrayList<Double> nullValues = new ArrayList<Double>();
        nullValues.add(-999.9);
        dimension.setNullValues(nullValues);
        this.getCatalog().save((ResourceInfo)ciRain);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__rain");
        Assert.assertNotNull((Object)dom);
        this.print(dom, System.out);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:CoverageDescription/gmlcov:rangeType/swe:DataRecord/swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"rain", (String)"//wcs:CoverageDescription/gmlcov:rangeType//swe:DataRecord/swe:field/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-999.9", (String)"//wcs:CoverageDescription/gmlcov:rangeType/swe:DataRecord/swe:field/swe:Quantity/swe:nilValues/swe:NilValues/swe:nilValue", (Document)dom);
    }

    @Test
    public void testMultiBandKVP() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=wcs__multiband");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testMultiBandKVPNoWs() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=multiband");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testMultiBandKVPLocalWs() throws Exception {
        Document dom = this.getAsDOM("wcs/wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=multiband");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testMultipleCoverages() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=wcs__multiband,wcs__BlueMarble");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wcs:CoverageDescription)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__multiband", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription[1]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__BlueMarble", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription[2]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[2]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testMultipleCoveragesNoWs() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=multiband,wcs__BlueMarble");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wcs:CoverageDescription)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__multiband", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription[1]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__BlueMarble", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription[2]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[2]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testMultipleCoveragesLocalWs() throws Exception {
        Document dom = this.getAsDOM("wcs/wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=multiband,BlueMarble");
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wcs:CoverageDescription)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__multiband", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription[1]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__BlueMarble", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription[2]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[2]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testMultipleCoveragesOneNotExists() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=wcs__multiband,wcs__IAmNotThere");
        this.checkOws20Exception(response, 404, "NoSuchCoverage", "coverageId");
    }

    @Test
    public void testNativeFormatMosaic() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__rasterFilter");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:CoverageDescription)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__rasterFilter", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription[1]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void gridCellCenterEnforce() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=wcs__BlueMarble");
        Assert.assertNotNull((Object)dom);
        this.print(dom, System.out);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-43.0020833333312 146.5020833333281", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//gml:domainSet//gml:RectifiedGrid//gml:origin//gml:Point//gml:pos", (Document)dom);
    }

    @Test
    public void testNativeFormatArcGrid() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__rain");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:CoverageDescription)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__rain", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:CoverageDescription[1]//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"text/plain", (String)"//wcs:CoverageDescriptions/wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }

    @Test
    public void testMetadata() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        ci.setTitle("My Title");
        ci.setDescription("My Abstract");
        ci.getKeywords().add(0, new Keyword("my_keyword"));
        MetadataLinkInfo mdl1 = catalog.getFactory().createMetadataLink();
        mdl1.setContent("http://www.geoserver.org/tasmania/dem.xml");
        mdl1.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(mdl1);
        MetadataLinkInfo mdl2 = catalog.getFactory().createMetadataLink();
        mdl2.setContent("/metadata?key=value");
        mdl2.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(mdl2);
        catalog.save((ResourceInfo)ci);
        String coverageId = this.getLayerId(MockData.TASMANIA_DEM).replace(":", "__");
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=" + coverageId);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        String base = "//wcs:CoverageDescriptions/wcs:CoverageDescription/";
        XMLAssert.assertXpathEvaluatesTo((String)"My Title", (String)(base + "gml:name"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"My Abstract", (String)(base + "gml:description"), (Document)dom);
        base = base + "gmlcov:metadata/gmlcov:Extension/";
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)("count(" + base + "ows:Keywords/ows:Keyword)"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"my_keyword", (String)(base + "ows:Keywords/ows:Keyword[1]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(" + base + "ows:Metadata)"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(base + "ows:Metadata[1]/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(base + "ows:Metadata[1]/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org/tasmania/dem.xml", (String)(base + "ows:Metadata[1]/@xlink:href"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(base + "ows:Metadata[2]/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(base + "ows:Metadata[2]/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"src/test/resources/geoserver/metadata?key=value", (String)(base + "ows:Metadata[2]/@xlink:href"), (Document)dom);
    }

    @Test
    public void testDescribeTimeList() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__watertemp");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkWaterTempTimeEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_td_0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[1]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_td_1", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[2]/gml:timePosition", (Document)dom);
    }

    @Test
    public void testDescribeTimeContinousInterval() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.CONTINUOUS_INTERVAL, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__watertemp");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkWaterTempTimeEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_tp_0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/gml:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/gml:timeInterval)", (Document)dom);
    }

    @Test
    public void testDescribeTimeDiscreteInterval() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.DISCRETE_INTERVAL, 8.64E7);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__watertemp");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkWaterTempTimeEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_tp_0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/gml:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/gml:timeInterval", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"day", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod/gml:timeInterval/@unit", (Document)dom);
    }

    @Test
    public void testDescribeTimeRangeList() throws Exception {
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "time", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__timeranges");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:boundedBy/gml:EnvelopeWithTimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Lat Long time", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@axisLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Deg Deg s", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@uomLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__timeranges_td_0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[1]/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-04T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[1]/gml:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__timeranges_td_1", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-05T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[2]/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[2]/gml:endPosition", (Document)dom);
    }

    @Test
    public void testDescribeElevationDiscreteInterval() throws Exception {
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "elevation", DimensionPresentation.DISCRETE_INTERVAL, 50.0, "m");
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__timeranges");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkElevationRangesEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"150.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range/wcsgs:end", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"50.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range/wcsgs:Interval", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"m", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range/wcsgs:Interval/@unit", (Document)dom);
    }

    @Test
    public void testDescribeElevationContinuousInterval() throws Exception {
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__timeranges");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkElevationRangesEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"150.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range/wcsgs:end", (Document)dom);
    }

    @Test
    public void testDescribeElevationValuesList() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "elevation", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__watertemp");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkWaterTempElevationEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:SingleValue)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:SingleValue[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:SingleValue[2]", (Document)dom);
    }

    @Test
    public void testDescribeElevationRangeList() throws Exception {
        this.setupRasterDimension(this.getLayerId(TIMERANGES), "elevation", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__timeranges");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkElevationRangesEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[1]/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"99.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[1]/wcsgs:end", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[2]/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"150.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[2]/wcsgs:end", (Document)dom);
    }

    @Test
    public void testDescribeTimeElevationList() throws Exception {
        this.setupRasterDimension(this.getLayerId(WATTEMP), "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(WATTEMP), "elevation", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__watertemp");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkWaterTempTimeElevationEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_td_0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[1]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_td_1", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[2]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:SingleValue)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:SingleValue[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:SingleValue[2]", (Document)dom);
    }

    @Test
    public void testDescribeCustomDimensionsList() throws Exception {
        this.setupRasterDimension(this.getLayerId(MULTIDIM), "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(MULTIDIM), "elevation", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(MULTIDIM), "custom_dimension_WAVELENGTH", DimensionPresentation.LIST, null);
        this.setupRasterDimension(this.getLayerId(MULTIDIM), "custom_dimension_DATE", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=sf__multidim");
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        this.checkTimeElevationRangesEnvelope(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__multidim_td_0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[1]/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-04T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[1]/gml:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__multidim_td_1", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-05T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[2]/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimePeriod[2]/gml:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[1]/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"99.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[1]/wcsgs:end", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[2]/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"150.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:Range[2]/wcsgs:end", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"DATE", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[1]/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[1]/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[1]/gml:TimeInstant)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[1]/gml:TimeInstant[1]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[1]/gml:TimeInstant[2]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-05T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[1]/gml:TimeInstant[3]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WAVELENGTH", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[2]/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"12", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[2]/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[2]/wcsgs:Range)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"12.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[2]/wcsgs:Range[1]/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"24.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[2]/wcsgs:Range[1]/wcsgs:end", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"25.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[2]/wcsgs:Range[2]/wcsgs:start", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"80.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:DimensionDomain[2]/wcsgs:Range[2]/wcsgs:end", (Document)dom);
    }

    private void checkWaterTempTimeEnvelope(Document dom) throws XpathException {
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:boundedBy/gml:EnvelopeWithTimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Lat Long time", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@axisLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Deg Deg s", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@uomLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:endPosition", (Document)dom);
    }

    private void checkWaterTempTimeElevationEnvelope(Document dom) throws XpathException {
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:boundedBy/gml:EnvelopeWithTimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Lat Long elevation time", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@axisLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Deg Deg m s", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@uomLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@srsDimension", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"40.562080748421806 0.23722068851276978 0.0", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:lowerCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"44.55808294568743 14.592757149389236 100.0", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:upperCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:endPosition", (Document)dom);
    }

    private void checkWaterTempElevationEnvelope(Document dom) throws XpathException {
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:boundedBy/gml:Envelope)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Lat Long elevation", (String)"//gml:boundedBy/gml:Envelope/@axisLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Deg Deg m", (String)"//gml:boundedBy/gml:Envelope/@uomLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"//gml:boundedBy/gml:Envelope/@srsDimension", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"40.562080748421806 0.23722068851276978 0.0", (String)"//gml:boundedBy/gml:Envelope/gml:lowerCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"44.55808294568743 14.592757149389236 100.0", (String)"//gml:boundedBy/gml:Envelope/gml:upperCorner", (Document)dom);
    }

    private void checkElevationRangesEnvelope(Document dom) throws XpathException {
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:boundedBy/gml:Envelope)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Lat Long elevation", (String)"//gml:boundedBy/gml:Envelope/@axisLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Deg Deg m", (String)"//gml:boundedBy/gml:Envelope/@uomLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"//gml:boundedBy/gml:Envelope/@srsDimension", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"40.562080748421806 0.23722068851276978 20.0", (String)"//gml:boundedBy/gml:Envelope/gml:lowerCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"44.55808294568743 14.592757149389236 150.0", (String)"//gml:boundedBy/gml:Envelope/gml:upperCorner", (Document)dom);
    }

    private void checkTimeElevationRangesEnvelope(Document dom) throws XpathException {
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:boundedBy/gml:EnvelopeWithTimePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Lat Long elevation time", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@axisLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Deg Deg m s", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@uomLabels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/@srsDimension", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"40.562080748421806 0.23722068851276978 20.0", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:lowerCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"44.55808294568743 14.592757149389236 150.0", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:upperCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)"//gml:boundedBy/gml:EnvelopeWithTimePeriod/gml:endPosition", (Document)dom);
    }
}

